/* Power Render Viewport Interface */

#ifndef _PRVIEWPORT_
#define _PRVIEWPORT_

#ifdef __cplusplus
  extern "C" {
#endif

#define NO_ZBUFFER 0
#define ZBUFFER_8 1
#define ZBUFFER_16 2
#define ZBUFFER_32 4

#define VIEW_PLAIN 8
#define VIEW_DOUBLE 16
#define VIEW_DIRTYRECT 32
#define VIEW_MOTIONBLUR 64

#define VIEW_VESA 128
#define VIEW_PARALLEL 256
#define VIEW_LINEAR 512


typedef struct
 {
  PR_REAL               width;
  PR_REAL               height;

  PR_REAL               centerx;
  PR_REAL               centery;

  PR_DWORD              topx, topy;             /* Clipping boundary */
  PR_DWORD              bottomx, bottomy;
  PR_REAL               xscale, yscale;         /* Scaling factors */ 

  block                 current_frame;
  block                 previous_frame;

  PR_DWORD              shadetable;
  PR_UCHAR *            zbuffer;
  PR_DWORD              zbuffer_bits;
  PR_DWORD              zbuffer_scale;

  PR_REAL               parallel_scale;

  PR_DWORD              flags;
 } PR_VIEWPORT;


void PR_ClearZBuffer (PR_VIEWPORT *viewport);
/* -----------------------------------------------------------------------
   Function:   PR_ClearZBuffer
   Purpose:    Clears a zbuffer of a viewport
   Parameters: viewport - Pointer to the viewport 
   Return:     None
   ----------------------------------------------------------------------- */


void PR_CloseViewport (PR_VIEWPORT *viewport);
/* -----------------------------------------------------------------------
   Function:   PR_CloseViewport
   Purpose:    Frees the blocks and zbuffer associated with a viewport
   Parameters: viewport - Pointer to the viewport
   Return:     None
   ----------------------------------------------------------------------- */


void PR_CopyDoubleHeight (block virt, PR_DWORD x, PR_DWORD y);
/* -----------------------------------------------------------------------
   Function:   PR_CopyDoubleHeight
   Purpose:    Copies a viewport to the screen using double height mode
               in 320x200
   Parameters: virt - Rendering buffer
               x,y - Upper left corner of viewport on screen
   Return:     None
   ----------------------------------------------------------------------- */


void PR_CopyDoubleHeightVESA (block virt, PR_DWORD x, PR_DWORD y);
/* -----------------------------------------------------------------------
   Function:   PR_CopyDoubleHeightVESA
   Purpose:    Copies a viewport to the screen using double height mode
               in VESA
   Parameters: virt - Rendering buffer
               x,y - Upper left corner of viewport on screen
   Return:     None
   ----------------------------------------------------------------------- */


void PR_OpenViewport (PR_VIEWPORT *viewport,
                PR_DWORD x0, PR_DWORD y0,
                PR_DWORD x1, PR_DWORD y1,
                PR_DWORD flags);
/* -----------------------------------------------------------------------
   Function:   PR_OpenViewport
   Purpose:    Initializes a viewport
   Parameters: viewport - Pointer to the viewport
               x0,y0,x1,y1 - Rectangular region of window
               flags - Display flags
   Return:     None
   ----------------------------------------------------------------------- */


void PR_ResizeViewport (PR_VIEWPORT *viewport, 
                        PR_DWORD x0, PR_DWORD y0,
                        PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PR_ResizeViewport
   Purpose:    Changes the size of a viewport 
   Parameters: viewport - pointer to the viewport
               x0,y0,x1,y1 - New rectangular region of viewport
   Return:     None
   ----------------------------------------------------------------------- */


void PR_SetViewport (PR_VIEWPORT *newview);
/* -----------------------------------------------------------------------
   Function:   PR_SetViewport
   Purpose:    Sets the active viewport 
   Parameters: newview - Pointer to the viewport
   Return:     None
   ----------------------------------------------------------------------- */


void PR_ShowViewport (PR_VIEWPORT *viewport, PR_DWORD x, PR_DWORD y);
/* -----------------------------------------------------------------------
   Function:   PR_ShowViewport
   Purpose:    Displays the viewport on the screen 
   Parameters: viewport - Pointer to the viewport
               x,y - Upper left corner of viewport on screen
   Return:     None
   ----------------------------------------------------------------------- */

#ifdef __cplusplus
}
#endif

#endif
