#include <stdlib.h>
#include <direct.h>
#include <string.h>

#include <pr.h>
#include <prgui.h>

#ifdef __3DFX__
#include <glide.h>
#include <pr3dfx.h>
#endif

#ifdef WIN32
#include <windows.h>
#endif


/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

Object Flag Setting Utility

Sets the flags for every face in the object.  Used for setting
front/back visibility.

 Revision History:
 October 6, 1996: Created

*/

char outfile[80];               /* Name of the output file */
PR_OBJECT *object1;
PR_DWORD device;


void InitializeDevices (void)
{
#ifdef __MYST__
  if ((device == DEVICE_MYSTIQUE) || (device == DEVICE_ANY))
    device = PR_DetectMystique ();
#endif

#ifdef __3DFX__
  if ((device == DEVICE_3DFX) || (device == DEVICE_ANY))
    device = PR_Detect3Dfx ();
#endif

#if !defined (MSGLIDE) && !defined (WTGLIDE)
  #if defined (MSDD) || defined (WTDD)
    if ((device == DEVICE_D3D) || (device == DEVICE_ANY))
      device = PR_DetectD3D ();   /* Attempt to find the device */
  #endif

  if ((device == DEVICE_SVGA) || (device == DEVICE_ANY))
    device = PR_DetectSVGA ();   /* Attempt to find the device */

  if ((device == DEVICE_VGA) || (device == DEVICE_ANY))
    device = PR_DetectVGA ();   /* Attempt to find the device */
#endif

#ifdef __MYST__
  if (device == DEVICE_MYSTIQUE)
    {
     PR_InitializeMystique ();
     atexit (PR_ShutdownMystique);
    }
#endif

#ifdef __3DFX__
  if (device == DEVICE_3DFX)
    {
     PR_Initialize3Dfx ();
     atexit (PR_Shutdown3Dfx);
    }
#endif

#if !defined (MSGLIDE) && !defined (WTGLIDE)
  #if defined (MSDD) || defined (WTDD)
  if (device == DEVICE_D3D)
    {
     PR_InitializeD3D ();
     atexit (PR_ShutdownD3D);
    }
  #endif
  if (device == DEVICE_SVGA)
    {
     PR_InitializeSVGA ();
     atexit (PR_ShutdownSVGA);
    }
  else if (device == DEVICE_VGA)
    {
     PR_InitializeVGA ();
     atexit (PR_ShutdownVGA);
    }
#endif
}


void main (int argc, char *argv[])
{
PR_DWORD flags;

  PRGUI_InitPath (argv[0]);


  if (argc < 3)
    {
     PR_FatalError (
                "Objflag Utility    version "
                PR_VERSION_NUMBER
                "\nCopyright 1997 Egerter Software\n\n"
		"Usage: \n"
        "Objflag file1.PRO file2.PRO\n", "OBJFLAG");
    }

  printf ("Objflag Utility    version ");
  printf (PR_VERSION_NUMBER);
  printf ("\nCopyright 1997 Egerter Software\n\n");

  flags = 0;
  #ifdef WIN32
     if (MessageBox(NULL, "Front Visible?",
                 "OBJFLAG", MB_YESNO) == IDYES)
		flags = 1;
	 if (MessageBox(NULL, "Back Visible?",
                 "OBJFLAG", MB_YESNO) == IDYES)
		flags += 2;
  #endif
  
  #ifndef WIN32
  printf ("Choose (1) Front visible\n"
          "       (2) Back visible\n"
          "       (3) Front and back visible\n"
          "           Any other number to abort\n");
  scanf ("%i", &flags);
  #endif

#if defined (MSGLIDE) || defined (WTGLIDE)
  device = DEVICE_3DFX;
#else
  device = DEVICE_SVGA;
#endif

  PR_Initialize (50);
  InitializeDevices ();


  PR_AllocMaterials (512);
  PR_AllocTextures (255);
  PR_AllocShadeTables (32);


  object1 = PR_LoadPRO (argv[1], LOAD_NORMAL);
  if (object1 == NULL)
     PR_FatalError ("An error has occurred when loading the file.\n", "OBJFLAG");

  if (flags == 1)
    {
     flags = FFLAG_FRONT_VISIBLE;
    }
  else if (flags == 2)
    {
     flags = FFLAG_BACK_VISIBLE;
    }
  else if (flags == 3)
    {
     flags = FFLAG_FRONT_VISIBLE | FFLAG_BACK_VISIBLE;
    }
  else
    {
     printf ("Invalid option.  Aborting...\n");
     exit (1);
    }

  PR_SetObjectFaceFlags (object1, flags,
                         FLAG_COPY);
  /* Sets the flags of all faces within an object */

  PR_SavePRO (argv[2], object1, SAVE_ALL_MATERIALS);
}



