/*

 Another TGA production.....			    Project Files :

 Project  	  :	RAWX_PM          		     VGAFRAME.ASM
Ķ  GFXRTS.ASM
 File		  : RAWX_PM.H				     FONTRTS.ASM
 Ver		  : (Pre-All) 0.15			     MOUSERTS.ASM
 Last Updated : 02.12.96                     INDRTS.ASM
 Code		  : Ghyll                      

*/


/*

  TYPEDEFS

  Some global typedefs and defines used by the rest of this header file.

  NOTE: Though not all of these defines are currently used, they probably
  will in future releases.

*/

typedef unsigned char uchar;
typedef unsigned long uint;

#define TRUE	1
#define FALSE 	0

/*

  DATA

  To avoid problems with including this header in multiple project-files,
  all data, including function pointer lie in the .LIB file(s).

*/

typedef struct {
	void *BufferPtr;
	uint XLen,YLen;
	uint bXLen;
	char ShiftConst;
	char Pad[3];
} X_BUFFER;

extern X_BUFFER x_CurBuffer;
extern X_BUFFER x_VGABuffer;
extern short x_mposx;
extern short x_mposy;

/*

  SVGA specifics

*/
uint x_setmode(int xres, int yres, int bpp);
uint x_setvesamode(int vmode);
void x_setbuffer(void *xbuffer);
void x_setdispstart(int x, int y);
void x_setscanlinelen(int xlen, int ylen);
void x_wait4vrt(void);

/*  Future renaming ???
void x_putpixel(int x, int y, int col);
void x_putbmp(int x, int y, int xlen, int ylen, void *bmp);
void x_getbmp(int x, int y, int xlen, int ylen, void *bmp);
//void x_vline(int x, int y, int ylen, int col);
//void x_hline(int x, int y, int xlen, int col);
void x_fillbox(int x, int y, int xlen, int ylen, int col);
void x_box(int x, int y, int xlen, int ylen, int col);
void x_hline_bmp(int x, int y, int xlen, void *bmp);
void x_vline_bmp(int x, int y, int ylen, void *bmp);
uint x_getpixel(int x, int y);
void x_putbmp_trns(int x, int y, int xlen, int ylen, void *bmp);
void x_putbmp_trns_add(int x, int y, int xlen, int ylen, int addcol, void *bmp);
void x_putbmp_area(int x, int y, int xlen, int ylen, int bx, int by, int bxlen, int bylen, void *bmp);
void x_putbmp_area_trns(int x, int y, int xlen, int ylen, int bx, int by, int bxlen, int bylen, void *bmp);
void x_putpal(int start, int len, void *pal);
void x_getpal(int start, int len, void *pal);
//void x_line(int sx, int sy, int ex, int ey, int col);
*/


/*

  GFX functions

  NOTE: Since some of these functions are actually function pointers,
  you will have to consider this when making a function pointer to an
  arbitrary function, like x_pixel!

*/

extern void (*x_pixel)(int x, int y, int col);
extern void (*x_vline)(int x, int y, int ylen, int col);
extern void (*x_hline)(int x, int y, int xlen, int col);
extern void (*x_rect_txt)(int x, int y, int xlen, int ylen, void *bmp);
extern void (*x_grect_txt)(int x, int y, int xlen, int ylen, void *bmp);
extern void (*x_rect_fill)(int x, int y, int xlen, int ylen, int col);
extern void (*x_hline_txt)(int x, int y, int xlen, void *bmp);
extern void (*x_vline_txt)(int x, int y, int ylen, void *bmp);
extern uint (*x_gpixel)(int x, int y);
extern void (*x_rect_trns_txt)(int x, int y, int xlen, int ylen, void *bmp);
extern void (*x_rect_trns_add_txt)(int x, int y, int xlen, int ylen, int addcol, void *bmp);
extern void (*x_rect_area_txt)(int x, int y, int xlen, int ylen, int bx, int by, int bxlen, int bylen, void *bmp);
extern void (*x_rect_area_trns_txt)(int x, int y, int xlen, int ylen, int bx, int by, int bxlen, int bylen, void *bmp);
extern void (*x_rect_add_txt)(int x, int y, int xlen, int ylen, int addcol, void *bmp);
extern void (*x_rect_scale_txt)(int x, int y, int xlen, int ylen, int bxlen, int bylen, void *bmp);
extern void (*x_line)(int sx, int sy, int ex, int ey, int col);
extern void (*x_clrbuffer)(int col);
extern void (*x_rect_area_map_txt)(int x, int y, int xlen, int ylen, int bx, int by, int bxlen, int bylen, void *bmp, void *alfa);
extern void (*x_rect_map_txt)(int x, int y, int xlen, int ylen, void *bmp, void *alfa);

/*
   These functions are not pointers, as they work the same way in all
   the VESA modes
*/

void x_circle(int x, int y, int rad, int col);
void x_pal(int start, int len, void *pal);
void x_gpal(int start, int len, void *pal);
void x_pal_clear(void);
void x_pal_fade2pal(int start, int len, void *pal);
void x_pal_fade2black(int start, int len);
void x_pal_col(int col, int red, int green, int blue);
void x_rect_area_bit_fill(int x, int y, int xlen, int ylen, int bxlen, int bylen, void *alfa, int col);
void x_rect(int x, int y, int xlen, int ylen, int col);


/*

  FONT definitions

*/

typedef struct {
	short int xlen;
	short int ylen;
	short int starty;
} CHARX;

typedef struct {
	char idstring[4];
	uint filesize;
	short int numletters;
	short int xspacing;
	short int yspacing;
	short int numptrs;
	short int startptr;
	CHARX *ptrtbl;
	short int fontheight;
	short int curcolor;
	short int spacewidth;
} XFN;


/*

  FONT functions

*/

XFN *f_loadfont(char *filename);
void f_setfont(XFN *font);
uint f_putch(int x, int y, char ch);
void f_setcol(int col);
void f_puts(int x, int y, char *str);
int  f_strlen(char *str);
int  f_chlen(int ch);
XFN *f_getfont(void);
void f_freefont(XFN *font);


/*

  FILE FORMAT functions

*/
void *g_decode_pcx(void *pcxhdr, void *destptr);
void *g_decode_tga(void *tgahdr, void *destptr);
uint g_decode_fli(void *flihdr);
uint g_decode_fli_frame(void *destptr);


/*

  MOUSE functions

*/
char m_sethotspot(int x,int y);
char m_setcursor(int xlen,int ylen, void *cursor,void *save);
void m_setpos(int x,int y);
void m_setbounds(int minx,int miny,int maxx,int maxy);
void m_setclipbounds(int minx, int miny, int maxx, int maxy);
void m_putcursor(void);
void m_updatecursor(void);
void m_putbackgrnd(void);
void m_getbackgrnd(void);
short m_checkbutton(void);
uint m_pollbuttons(void);
void m_updatepos(void);

