; 
;  -          Super Flat 3D Engine for RealFlatMode by Zjack of DCC          -
; 

; 1400 faces full screen linear texture torus 30 fps on 486/66Mhz...

.model small
.486P
.stack 1000h


BUCKET         segment dword public
db             65535 dup (0)
BUCKET         ends

BUFFER         segment dword public
db             65535 dup (0)
BUFFER         ends

TEXTURE        segment dword public
db             65535 dup (0)
TEXTURE        ends

;
; - macros -

nje            macro destination
               db 74h,destination-$-1
               endm

nja            macro destination
               db 77h,destination-$-1
               endm

njna           macro destination
               db 76h,destination-$-1
               endm

njbe           macro destination
               db 76h,destination-$-1
               endm

njb            macro destination
               db 72h,destination-$-1
               endm

njae           macro destination
               db 73h,destination-$-1
               endm

njnb           macro destination
               db 73h,destination-$-1
               endm

njg            macro destination
               db 7fh,destination-$-1
               endm

njng           macro destination
               db 7eh,destination-$-1
               endm

njle           macro destination
               db 7eh,destination-$-1
               endm

njo            macro destination
               db 70h,destination-$-1
               endm

njno           macro destination
               db 71h,destination-$-1
               endm

njs            macro destination
               db 78h,destination-$-1
               endm

njns           macro destination
               db 79h,destination-$-1
               endm

njc            macro destination
               db 72h,destination-$-1
               endm

njnc           macro destination
               db 73h,destination-$-1
               endm

njne           macro destination
               db 75h,destination-$-1
               endm

fje            macro destination
               db 0fh,84h
               dw destination-$-2
               endm

fja            macro destination
               db 0fh,87h
               dw destination-$-2
               endm

fjna           macro destination
               db 0fh,86h
               dw destination-$-2
               endm

fjbe           macro destination
               db 0fh,86h
               dw destination-$-2
               endm

fjb            macro destination
               db 0fh,82h
               dw destination-$-2
               endm

fjae           macro destination
               db 0fh,83h
               dw destination-$-2
               endm

fjnb           macro destination
               db 0fh,83h
               dw destination-$-2
               endm

fjg            macro destination
               db 0fh,8fh
               dw destination-$-2
               endm

fjng           macro destination
               db 0fh,8eh
               dw destination-$-2
               endm

fjle           macro destination
               db 0fh,8eh
               dw destination-$-2
               endm

fjo            macro destination
               db 0fh,80h
               dw destination-$-2
               endm

fjno           macro destination
               db 0fh,81h
               dw destination-$-2
               endm

fjs            macro destination
               db 0fh,88h
               dw destination-$-2
               endm

fjns           macro destination
               db 0fh,89h
               dw destination-$-2
               endm

fjc            macro destination
               db 0fh,82h
               dw destination-$-2
               endm

fjnc           macro destination
               db 0fh,83h
               dw destination-$-2
               endm

fjne           macro destination
               db 0fh,85h
               dw destination-$-2
               endm
;

maxz           equ 2500
minz           equ 600
div_table1     equ 512
div_table2     equ 512


assume         ds:ENGINE,cs:ENGINE
ENGINE	       segment para public 'code' use16
               call  init_engine
               call  make_table1
               call  make_table2
               call  init_vga
     main_loop:
               call  update_object
               call  animate
               call  wait_retrace
               call  flip_screen
               inc   dword ptr cs:[frame]
               cmp   dword ptr cs:[frame],1000
               jne   frames_left
               call  deinit_engine
               call  deinit_vga
               mov   dx,offset error_auto
               jmp   exit
   frames_left:
               in    al,60h
               cmp   al,1
               jne   main_loop
               call  deinit_engine
               call  deinit_vga
               mov   dx,offset error_esc
          exit:
               mov   ax,cs
               mov   ds,ax
               mov   ax,0900h
               int   21h
               mov   ax,4c00h
               int   21h
;
make_table1    proc near
               xor   ax,ax
               mov   ds,ax
               mov   ebx,dword ptr cs:[ptr_table1]
               mov   dword ptr cs:[div_1-4],ebx
               mov   dword ptr cs:[div_2-4],ebx
               mov   dword ptr cs:[bdiv_1-4],ebx
               mov   dword ptr cs:[bdiv_2-4],ebx
               mov   dword ptr cs:[cdiv_1-4],ebx
               mov   dword ptr cs:[cdiv_2-4],ebx
               mov   dword ptr cs:[uadd_d-4],ebx
               mov   dword ptr cs:[vadd_d-4],ebx
               mov   si,-256
      vertical:
               mov   di,-256
    horizontal:
               xor   ax,ax
               or    si,si
               je    zero_1
               movsx ecx,si
               add   ecx,256
               shl   ecx,10
               movsx eax,di
               add   eax,256
               shl   eax,1
               add   ecx,eax
               add   ecx,ebx
               movsx ebp,si
               movsx eax,di
               cdq
               shl   eax,8
               idiv  ebp
        zero_1:
               mov   ds:[ecx],ax
               inc   di
               cmp   di,256
               jne   horizontal
               inc   si
               cmp   si,256
               jne   vertical
               ret
make_table1    endp
;
make_table2    proc near
               xor   ax,ax
               mov   ds,ax
               mov   ebx,dword ptr cs:[ptr_table2]
               mov   dword ptr cs:[div2-4],ebx
               mov   dword ptr cs:[bdiv2-4],ebx
               mov   dword ptr cs:[cdiv2-4],ebx
               mov   si,-256
     vertical2:
               mov   di,-256
   horizontal2:
               xor   ax,ax
               or    si,si
               je    zero_2
               movsx ecx,si
               add   ecx,256
               shl   ecx,10
               movsx eax,di
               add   eax,256
               shl   eax,1
               add   ecx,eax
               add   ecx,ebx
               mov   ax,di
               cwd
               shl   ax,6
               idiv  si
        zero_2:
               mov   ds:[ecx],ax
               inc   di
               cmp   di,256
               jne   horizontal2
               inc   si
               cmp   si,256
               jne   vertical2
               ret
make_table2    endp
;
animate        proc near
               mov   ax,cs
               mov   ds,ax
               add   word ptr ds:[xan],8
               cmp   word ptr ds:[xan],1023
               jna   xan_ok
               mov   word ptr ds:[xan],0
        xan_ok:
               add   word ptr ds:[yan],4
               cmp   word ptr ds:[yan],1023
               jna   yan_ok
               mov   word ptr ds:[yan],0
        yan_ok:
               add   word ptr ds:[zan],2
               cmp   word ptr ds:[zan],1023
               jna   zan_ok
               mov   word ptr ds:[zan],0
        zan_ok:
               nop
               ret
animate        endp
;
update_object  proc near
               mov   ax,cs
               mov   ds,ax
               mov   bx,word ptr ds:[xan]
               mov   si,word ptr ds:[yan]
               mov   di,word ptr ds:[zan]
               add   bx,bx
               add   si,si
               add   di,di
               mov   bp,word ptr ds:[sine+bx]
               mov   bx,word ptr ds:[cose+bx]
               mov   ax,word ptr ds:[cose+si]
               mov   word ptr ds:[coy],ax
               mov   si,word ptr ds:[sine+si]
               mov   ax,word ptr ds:[sine+di]
               mov   word ptr ds:[siz],ax
               mov   di,word ptr ds:[cose+di]
               mov   ax,word ptr ds:[coy]
               imul  di
               mov   al,ah
               mov   ah,dl
               mov   word ptr ds:[mm1-2],ax
               mov   word ptr ds:[vmm1-2],ax
               mov   ax,si
               imul  di
               mov   al,ah
               mov   ah,dl
               imul  bp
               mov   cl,ah
               mov   ch,dl
               mov   ax,word ptr ds:[siz]
               imul  bx
               mov   al,ah
               mov   ah,dl
               add   ax,cx
               mov   word ptr ds:[mm2-2],ax
               mov   word ptr ds:[vmm2-2],ax
               mov   ax,si
               imul  di
               mov   al,ah
               mov   ah,dl
               imul  bx
               mov   cl,ah
               mov   ch,dl
               mov   ax,word ptr ds:[siz]
               imul  bp
               mov   al,ah
               mov   ah,dl
               sub   ax,cx
               mov   word ptr ds:[mm3-2],ax
               mov   word ptr ds:[vmm3-2],ax
               mov   ax,word ptr ds:[siz]
               neg   ax
               imul  word ptr ds:[coy]
               mov   al,ah
               mov   ah,dl
               mov   word ptr ds:[mm4-2],ax
               mov   word ptr ds:[vmm4-2],ax
               mov   ax,word ptr ds:[siz]
               imul  si
               mov   al,ah
               mov   ah,dl
               imul  bp
               mov   cl,ah
               mov   ch,dl
               mov   ax,bx
               imul  di
               mov   al,ah
               mov   ah,dl
               sub   ax,cx
               mov   word ptr ds:[mm5-2],ax
               mov   word ptr ds:[vmm5-2],ax
               mov   ax,word ptr ds:[siz]
               imul  si
               mov   al,ah
               mov   ah,dl
               imul  bx
               mov   al,ah
               mov   ah,dl
               mov   cx,ax
               mov   ax,bp
               imul  di
               mov   al,ah
               mov   ah,dl
               add   ax,cx
               mov   word ptr ds:[mm6-2],ax
               mov   word ptr ds:[vmm6-2],ax
               mov   word ptr ds:[mm7-2],si
               mov   ax,word ptr ds:[coy]
               neg   ax
               imul  bp
               mov   al,ah
               mov   ah,dl
               mov   word ptr ds:[mm8-2],ax
               mov   ax,word ptr ds:[coy]
               imul  bx
               mov   al,ah
               mov   ah,dl
               mov   word ptr ds:[mm9-2],ax
               mov   ax,word ptr ds:[mm1-2]
               imul  word ptr ds:[mm3-2]
               mov   al,ah
               mov   ah,dl
               mov   word ptr ds:[vtt1-2],ax
               sub   ax,word ptr ds:[x_pos]
               mov   word ptr ds:[tt1-2],ax
               mov   ax,word ptr ds:[mm4-2]
               imul  word ptr ds:[mm6-2]
               mov   al,ah
               mov   ah,dl
               mov   word ptr ds:[vtt2-2],ax
               sub   ax,word ptr ds:[y_pos]
               mov   word ptr ds:[tt2-2],ax
               mov   ax,word ptr ds:[mm7-2]
               imul  word ptr ds:[mm9-2]
               mov   al,ah
               mov   ah,dl
               sub   ax,word ptr ds:[z_pos]
               mov   word ptr ds:[tt3-2],ax
               xor   ax,ax
               mov   ds,ax
               mov   edi,dword ptr cs:[ptr_object]
               add   edi,4
               mov   ax,word ptr cs:[faces]
               and   eax,0ffffh
               shl   eax,4
               add   edi,eax
               mov   ax,word ptr cs:[vertexes]
               and   eax,0ffffh
               mov   ebx,24
               mul   ebx
               add   eax,edi
               mov   dword ptr cs:[last_vertex-4],eax
               align 2
        rotate:
               mov   ds:[0],di
               mov   si,word ptr ds:[edi]
               mov   cx,word ptr ds:[edi+2]
               mov   bp,word ptr ds:[edi+4]
               mov   di,word ptr ds:[edi+6]
               mov   ax,3333
          mm3: mov   dx,1111
          mm1: add   ax,si
               add   dx,bp
               imul  dx
               mov   bl,ah
               mov   bh,dl
               mov   ax,2222
          mm2: imul  cx
               mov   al,ah
               mov   ah,dl
               add   ax,bx
               sub   ax,1111
          tt1: sub   ax,di
               mov   word ptr cs:[xmod-2],ax
               mov   ax,6666
          mm6: mov   dx,4444
          mm4: add   ax,si
               add   dx,bp
               imul  dx
               mov   bl,ah
               mov   bh,dl
               mov   ax,5555
          mm5: imul  cx
               mov   al,ah
               mov   ah,dl
               add   ax,bx
               sub   ax,2222
          tt2: sub   ax,di
               mov   word ptr cs:[ymod-2],ax
               mov   ax,9999
          mm9: mov   dx,7777
          mm7: add   ax,si
               add   dx,bp
               imul  dx
               mov   bl,ah
               mov   bh,dl
               mov   ax,8888
          mm8: imul  cx
               mov   al,ah
               mov   ah,dl
               sub   ax,3333
         tt3:  add   bx,ax
               sub   bx,di
               mov   di,ds:[0]
               mov   ax,1122
         ymod: mov   ds:[edi+20],bx
               mov   dl,ah
               add   ah,128
               sbb   dh,dh
               mov   ah,al
               idiv  bx
               shl   eax,16
               mov   si,word ptr ds:[edi+8]
               mov   ax,1122
         xmod: mov   dl,ah
               mov   cx,word ptr ds:[edi+10]
               add   ah,128
               sbb   dh,dh
               mov   ah,al
               idiv  bx
               add   eax,00800080h
               mov   bp,word ptr ds:[edi+12]
               mov   ds:[edi+16],eax
               mov   di,word ptr ds:[edi+14]
               mov   ax,3333
         vmm3: mov   dx,1111
         vmm1: add   ax,si
               add   dx,bp
               imul  dx
               mov   bl,ah
               mov   bh,dl
               mov   ax,2222
         vmm2: imul  cx
               mov   al,ah
               mov   ah,dl
               add   ax,bx
               sub   ax,1111
         vtt1: sub   ax,di
               sar   ax,1
               mov   byte ptr cs:[t_u-1],al
               mov   ax,6666
         vmm6: mov   dx,4444
         vmm4: add   ax,si
               add   dx,bp
               imul  dx
               mov   bl,ah
               mov   bh,dl
               mov   ax,5555
         vmm5: imul  cx
               mov   al,ah
               mov   ah,dl
               add   ax,bx
               sub   ax,2222
         vtt2: sub   ax,di
               shl   ax,7
               mov   di,ds:[0]
               mov   al,0
          t_u: add   ax,8080h
               mov   word ptr ds:[edi+22],ax
               add   edi,24
               cmp   edi,1112233h
  last_vertex: jne   rotate

               mov   esi,dword ptr cs:[ptr_object]
               add   esi,4
               mov   ax,word ptr cs:[faces]
               and   eax,0ffffh
               shl   eax,4
               add   eax,esi
               mov   dword ptr cs:[last_face-4],eax
               mov   ax,seg BUCKET
               mov   fs,ax
               align 2
    more_faces:
               mov   ebx,ds:[esi]
               mov   ecx,ds:[esi+4]
               mov   edi,ds:[esi+8]
               mov   ax,ds:[ebx+16]
               mov   dx,ds:[edi+18]
               sub   ax,ds:[ecx+16]
               sub   dx,ds:[ecx+18]
               imul  dx
               mov   bp,ax
               mov   ax,ds:[ebx+18]
               mov   dx,ds:[edi+16]
               sub   ax,ds:[ecx+18]
               sub   dx,ds:[ecx+16]
               imul  dx
               sub   ax,bp
               njs   hidden_face
               mov   di,word ptr ds:[ebx+20]
               shl   di,2
               mov   eax,fs:[di]
               mov   fs:[di],esi
               mov   ds:[esi+12],eax
   hidden_face:
               add   esi,16
               cmp   esi,11223344h
    last_face: jne   more_faces

               mov   ax,seg BUFFER
               mov   es,ax
               xor   ax,ax
               mov   gs,ax
               mov   di,maxz*4
               xor   ebp,ebp
               align 2
     draw_face:
               mov   eax,fs:[di]
               or    eax,eax
               je    empty_bucket
               mov   dword ptr fs:[di],0
               align 2
     link_list:
               mov   esi,eax
               push  di
               push  esi
               mov   ebx,ds:[esi]
               mov   edx,ds:[esi+4]
               mov   edi,ds:[esi+8]
               mov   ax,ds:[edx+22]
               mov   word ptr cs:[poly_u1],ax
               mov   ax,ds:[ebx+22]
               mov   word ptr cs:[poly_u2],ax
               mov   ax,ds:[edi+22]
               mov   word ptr cs:[poly_u3],ax
               mov   si,word ptr ds:[ebx+18]
               mov   bx,word ptr ds:[ebx+16]
               mov   cx,word ptr ds:[edi+16]
               mov   di,word ptr ds:[edi+18]
               mov   bp,word ptr ds:[edx+16]
               mov   dx,word ptr ds:[edx+18]
               cmp   dx,si
               njne  nosame
               cmp   dx,di
               njne  nosame
               cmp   si,di
               fje   away
        nosame:
               mov   ax,bp
               and   ax,bx
               and   ax,cx
               fjs   away
               cmp   bp,255
               njng  bound1
               cmp   bx,255
               njng  bound1
               cmp   cx,255
               fjg   away
        bound1:
               mov   ax,dx
               and   ax,si
               and   ax,di
               fjs   away
               cmp   dx,255
               njng  bound2
               cmp   si,255
               njng  bound2
               cmp   di,255
               fjg   away
        bound2:
               mov   ax,cs
               mov   ds,ax
               cmp   dx,si
               njng  noswap1
               xchg  dx,si
               xchg  bp,bx
               mov   ax,word ptr ds:[poly_u2]
               xchg  ax,word ptr ds:[poly_u1]
               mov   word ptr ds:[poly_u2],ax
       noswap1:
               cmp   dx,di
               njng  noswap2
               xchg  dx,di
               xchg  bp,cx
               mov   ax,word ptr ds:[poly_u3]
               xchg  ax,word ptr ds:[poly_u1]
               mov   word ptr ds:[poly_u3],ax
       noswap2:
               cmp   si,di
               njng  noswap3
               xchg  si,di
               xchg  bx,cx
               mov   ax,word ptr ds:[poly_u3]
               xchg  ax,word ptr ds:[poly_u2]
               mov   word ptr ds:[poly_u3],ax
       noswap3:
               mov   word ptr ds:[xx1-2],  bp
               mov   al,dl
               mov   word ptr ds:[poly_x2],bx
               or    al,dh
               mov   word ptr ds:[poly_y3],di
               xor   al,dh
               xor   ebx,ebx
               mov   word ptr ds:[poly_y1],dx
               mov   byte ptr ds:[ys],al
               mov   word ptr ds:[poly_x3],cx
               mov   ax,di
               mov   word ptr ds:[poly_y2],si
               add   ah,255
               sbb   al,al
               mov   bx,dx
               or    ax,di
               sub   bx,di
               mov   byte ptr ds:[ye],al
               xor   eax,eax
               mov   ax,bp
               sub   ax,cx
               inc   ah
               inc   bh
               add   ax,ax
               xor   dx,dx
               shl   ebx,10
               mov   edi,ebx
               add   ebx,eax
               mov   dl,byte ptr ds:[poly_u3]
               mov   ax,word ptr ds:[poly_u1]
               mov   si,gs:[ebx+11223344h]
         div2: mov   cx,ax
               xor   ah,ah
               sub   ax,dx
               inc   ah
               mov   ebx,edi
               add   ax,ax
               add   ebx,eax
               mov   dl, byte ptr ds:[poly_v3]
               mov   ax,gs:[ebx+11223344h]
        div_2: mov   word ptr ds:[f0+2],ax
               xor   ax,ax
               mov   al, byte ptr ds:[poly_v1]
               mov   bh,cl
               sub   ax,dx
               xor   bl,bl
               inc   ah
               add   ax,ax
               add   edi,eax
               mov   ax,bp
               xor   cl,cl
               shl   ax,6
               mov   bp,gs:[edi+11223344h]
        div_1: cmp   word ptr ds:[poly_y1],-1
               njg   init_1
               mov   di,ax
               mov   ax,word ptr ds:[poly_y1]
               imul  si
               sub   di,ax
               mov   ax,word ptr ds:[poly_y1]
               imul  word ptr ds:[F0+2]
               sub   bx,ax
               mov   ax,word ptr ds:[poly_y1]
               imul  bp
               sub   cx,ax
               mov   ax,di
        init_1:
               mov   dx,word ptr ds:[ye]
               mov   di,word ptr ds:[ys]
               sub   dx,di
               shl   eax,16
               shl   di,3
               shl   esi,16
               add   di,offset scan_table
               align 2
         edge1:
               mov   ah,bh
               mov   al,ch
           f0: add   bx,1111
               mov   ds:[di],eax
               add   cx,bp
               add   di,8
               add   eax,esi
               sub   dx,1
               njnc  edge1

               xor   eax,eax
               xor   ebx,ebx
               mov   ax,2222
          xx1: mov   bx,word ptr ds:[poly_y1]
               mov   bp,ax
               mov   di,bx
               sub   ax,word ptr ds:[poly_x2]
               sub   bx,word ptr ds:[poly_y2]
               inc   ah
               inc   bh
               add   ax,ax
               xor   dx,dx
               shl   ebx,10
               mov   edi,ebx
               add   ebx,eax
               mov   dl,byte ptr ds:[poly_u2]
               mov   ax,word ptr ds:[poly_u1]
               mov   cx,ax
               mov   si,gs:[ebx+11223344h]
        bdiv2: xor   ah,ah
               sub   ax,dx
               inc   ah
               add   ax,ax
               mov   ebx,edi
               add   ebx,eax
               mov   dl,byte ptr ds:[poly_v2]
               mov   ax,gs:[ebx+11223344h]
       bdiv_2: mov   word ptr ds:[f2+2],ax
               xor   ax,ax
               mov   al,byte ptr ds:[poly_v1]
               sub   ax,dx
               inc   ah
               add   ax,ax
               add   edi,eax
               mov   bh,cl
               mov   ax,bp
               xor   bl,bl
               xor   cl,cl
               shl   ax,6
               mov   bp,gs:[edi+11223344h]
       bdiv_1: cmp   word ptr ds:[poly_y1],-1
               njg   init_2
               mov   di,ax
               mov   ax,word ptr ds:[poly_y1]
               imul  si
               sub   di,ax
               mov   ax,word ptr ds:[poly_y1]
               imul  word ptr ds:[F2+2]
               sub   bx,ax
               mov   ax,word ptr ds:[poly_y1]
               imul  bp
               sub   cx,ax
               mov   ax,di
        init_2:
               mov   dx,word ptr ds:[poly_y2]
               shl   eax,16
               add   dh,128
               sbb   al,al
               mov   di,word ptr ds:[ys]
               or    dl,al
               xor   dl,al
               add   dh,127
               sbb   al,al
               shl   esi,16
               or    dl,al
               xor   dh,dh
               mov   byte ptr ds:[ye2-2],dl
               sub   dx,di
               shl   di,3
               add   di,offset scan_table+4
               align 2
        edge12:
               mov   ah,bh
               mov   al,ch
           f2: add   bx,2222
               mov   ds:[di],eax
               add   cx,bp
               add   di,8
               add   eax,esi
               sub   dx,1
               njnc  edge12

               xor   eax,eax
               xor   ebx,ebx
               mov   ax,word ptr ds:[poly_x2]
               mov   bx,word ptr ds:[poly_y2]
               mov   bp,ax
               sub   bx,word ptr ds:[poly_y3]
               sub   ax,word ptr ds:[poly_x3]
               inc   bh
               inc   ah
               add   ax,ax
               xor   dx,dx
               shl   ebx,10
               mov   edi,ebx
               add   ebx,eax
               mov   dl,byte ptr ds:[poly_u3]
               mov   ax,word ptr ds:[poly_u2]
               mov   si,gs:[ebx+11223344h]
        cdiv2: mov   cx,ax
               xor   ah,ah
               sub   ax,dx
               inc   ah
               add   ax,ax
               mov   ebx,edi
               add   ebx,eax
               mov   dl,byte ptr ds:[poly_v3]
               mov   ax,gs:[ebx+11223344h]
       cdiv_2: mov   word ptr ds:[f3+2],ax
               xor   ax,ax
               mov   al,byte ptr ds:[poly_v2]
               sub   ax,dx
               inc   ah
               add   ax,ax
               add   edi,eax
               mov   bh,cl
               mov   ax,bp
               xor   bl,bl
               xor   cl,cl
               shl   ax,6
               mov   bp,gs:[edi+11223344h]
       cdiv_1: cmp   word ptr ds:[poly_y2],-1
               njg   init_3
               mov   di,ax
               mov   ax,word ptr ds:[poly_y2]
               imul  si
               sub   di,ax
               mov   ax,word ptr ds:[poly_y2]
               imul  word ptr ds:[F3+2]
               sub   bx,ax
               mov   ax,word ptr ds:[poly_y2]
               imul  bp
               sub   cx,ax
               mov   ax,di
        init_3:
               mov   di,0
          ye2: mov   dx,word ptr ds:[ye]
               shl   eax,16
               sub   dx,di
               shl   di,3
               shl   esi,16
               add   di,offset scan_table+4
               mov   word ptr ds:[widest-2],di
               align 2
       edge123:
               mov   ah,bh
               mov   al,ch
           f3: add   bx,3333
               mov   ds:[di],eax
               add   cx,bp
               add   di,8
               add   eax,esi
               sub   dx,1
               njnc  edge123

               xor   ecx,ecx
               xor   eax,eax
               mov   si,1111
       widest: mov   bp,word ptr ds:[si-4]
               mov   cx,word ptr ds:[si-2]
               mov   bx,word ptr ds:[si+2]
               mov   si,word ptr ds:[si]
               cmp   bx,cx
               njng  dont_change
               xchg  cx,bx
               xchg  bp,si
   dont_change:
               sar   cx,6
               sar   bx,6
               sub   cx,bx
               fje   away
               mov   ax,bp
               mov   dx,cx
               mov   al,ah
               mov   bx,si
               xor   ah,ah
               mov   bl,bh
               inc   ch
               xor   bh,bh
               and   bp,0ffh
               sub   ax,bx
               and   si,0ffh
               inc   ah
               sub   bp,si
               add   ax,ax
               add   bp,256
               shl   ecx,10
               mov   edi,ecx
               add   bp,bp
               add   ecx,eax
               add   edi,ebp
               mov   ax,gs:[ecx+11223344h]
       uadd_d: mov   word ptr ds:[uadder-2],ax
               mov   si,ax
               mov   ax,gs:[edi+11223344h]
       vadd_d: mov   word ptr ds:[vadder-2],ax
               mov   bp,ax
               mov   di,offset skip_line-8+3-1
               xor   cx,cx
               xor   bx,bx
               align 2
     make_look:
               mov   ah,bh
               mov   al,ch
               mov   word ptr ds:[di],ax
               add   bx,bp
               add   cx,si
               sub   di,8
               dec   dx
               njne  make_look

               mov   si,word ptr ds:[ys]
               mov   ax,word ptr ds:[ye]
               shl   si,3
               shl   ax,3
               mov   bx,seg TEXTURE
               mov   word ptr ds:[endline-2],ax
               mov   ds,bx
               align 2
      scanline:
               push  si
               mov   cx,word ptr cs:[si+scan_table+2]
               mov   di,si
               mov   ax,word ptr cs:[si+scan_table+6]
               add   si,offset scan_table+4
               cmp   ax,cx
               njng  nochange
               sub   si,4
               xchg  cx,ax
      nochange:
               mov   si,word ptr cs:[si]
               sar   cx,6
               fjs   skip_line
               mov   dx,si
               sar   ax,6
               xor   dl,dl
               cmp   ax,255
               fjg   skip_line
               shl   di,5
               mov   word ptr cs:[xs_add-2],ax
               add   ch,255
               sbb   bl,bl
               add   di,ax
               or    cl,bl
               shl   si,8
               xor   ch,ch
               sub   cx,ax
               fje   skip_line
               cmp   ax,-1
               njg   fill
               mov   bp,2222
       vadder: sub   di,ax
               mov   bx,dx
               add   cx,ax
               mov   dx,1111
        uadder:imul  dx
               sub   bx,ax
               mov   ax,1111
       xs_add: imul  bp
               sub   si,ax
               mov   dx,bx
               inc   cx
          fill:
               mov   bx,si
               shl   cx,3
               add   di,128
               neg   cx
               mov   bl,dh
               add   cx,offset skip_line
               jmp   cx
               align 2
               xoff=127
               rept  256
               mov   al,byte ptr ds:[bx+1000]
               mov   byte ptr es:[di+xoff],al
               xoff=xoff-1
               endm
     skip_line:
               pop   si
               add   si,8
               cmp   si,1111
      endline: fjb   scanline
          away:
               xor   ax,ax
               mov   ds,ax
               pop   esi
               pop   di
               mov   eax,ds:[esi+12]
               or    eax,eax
               fjne  link_list
  empty_bucket:
               sub   di,4
               cmp   di,minz*4
               ja    draw_face
               ret
update_object  endp
;
flip_screen    proc near
               mov   ax,seg BUFFER
               mov   ds,ax
               mov   ax,0a000h
               mov   es,ax
               mov   ax,seg TEXTURE
               mov   fs,ax
               mov   cx,16384-64
               mov   ebx,01010101h
               xor   di,di
               align 2
          flip:
               rept  64
               mov   eax,ds:[di]
               mov   es:[di],eax
               mov   eax,fs:[di]
               mov   ds:[di],eax
               add   di,4
               dec   cx
               endm
               jne   flip
               ret
flip_screen    endp
;
wait_retrace   proc near
          ;     mov   al,0
          ;     mov   dx,03c8h
          ;     out   dx,al
          ;     inc   dx
          ;     out   dx,al
          ;     out   dx,al
          ;     out   dx,al
               mov   dx,3dah
        again1:
               in    al,dx
               and   al,08h
               jne   again1
        again2:
               in    al,dx
               and   al,08h
               je    again2
         ;      mov   al,0
         ;      mov   dx,03c8h
         ;      out   dx,al
         ;      mov   al,63
         ;      inc   dx
         ;      out   dx,al
         ;      out   dx,al
         ;      out   dx,al
               ret
wait_retrace   endp
;
init_engine    proc near
               mov   ax,cs
               mov   ds,ax
               mov   dx,offset start_msg
               mov   ah,09h
               int   21h
               mov   ax,4300h
               int   2fh
               cmp   al,80h
               je    himem_sys_ok
               mov   dx,offset error_xms
               jmp   exit
  himem_sys_ok:
               smsw  ax
               test  ax,1
               je    set_flat_mode
               mov   dx,offset error_v86
               jmp   exit
 set_flat_mode:
               assume ds:MYGDT,cs:ENGINE
               mov   ax,MYGDT
               mov   ds,ax
               mov   ax,ENGINE
               movzx eax,ax
               shl   eax,4
               mov   word ptr gdt[gdt_code16+2],ax
               ror   eax,16
               mov   byte ptr gdt[gdt_code16+4],al
               mov   ax,MYGDT
               movzx eax,ax
               shl   eax,4
               add   dword ptr ptr_gdt+2,eax
               lgdt  fword ptr ptr_gdt
               cli
               in    al,70h
               mov   save_nmi,al
               mov   al,80h
               out   70h,al
               mov   eax,cr0
               or    al,1
               mov   cr0,eax
               db    0eah
               dw    offset pmode
               dw    gdt_code16
         pmode:
               mov   ax,gdt_data32
               mov   ds,ax
               mov   es,ax
               mov   fs,ax
               mov   gs,ax
               mov   eax,cr0
               and   al,0feh
               mov   cr0,eax
               db    0eah
               dw    offset rmode
               dw    ENGINE
         rmode:
               sti
               mov   al,save_NMI
               out   70h,al
     alloc_mem:
               assume ds:ENGINE,cs:ENGINE
               mov   ax,4310h
               int   2fh
               mov   word ptr cs:[ptr_himem],bx
               mov   word ptr cs:[ptr_himem+2],es
               mov   ax,cs
               mov   ds,ax
               mov   ax,3d00h
               mov   dx,offset name_object
               int   21h
               jnc   no_file_error1
               mov   dx,offset error_file
               jmp   exit
no_file_error1:
               mov   bx,ax
               mov   word ptr cs:[file_handle],ax
               mov   ah,42h
               mov   al,02h
               mov   cx,0
               mov   dx,0
               int   21h
               shl   edx,16
               mov   dx,ax
               shr   edx,10
               inc   edx
               mov   dword ptr cs:[file_size],edx
               mov   bx,word ptr cs:[file_handle]
               mov   ah,3eh
               int   21h
               mov   dx,word ptr cs:[file_size]
               add   dx,div_table1
               add   dx,div_table2
               mov   ah,09h
               call  cs:[ptr_himem]
               cmp   ax,1
               je    enough_free_xms
               mov   dx,offset error_xms
               jmp   exit
enough_free_xms:
               mov   word ptr cs:[xms_handle],dx
               mov   ah,0ch
               call  cs:[ptr_himem]
               mov   ax,dx
               shl   eax,16
               mov   ax,bx
               test  eax,3
               je    dword_aligned
               add   eax,3
               and   eax,0FFFFFFFCh
 dword_aligned:
               mov   dword ptr cs:[ptr_object],eax
               mov   ebx,dword ptr cs:[file_size]
               shl   ebx,10
               add   eax,ebx
               mov   dword ptr cs:[ptr_table1],eax
               add   eax,div_table1*1024
               mov   dword ptr cs:[ptr_table2],eax
   load_object:
               mov   ax,cs
               mov   ds,ax
               mov   ax,3d00h
               mov   dx,offset name_object
               int   21h
               mov   esi,dword ptr cs:[ptr_object]
               mov   word ptr cs:[file_handle],ax
               xor   ax,ax
               mov   es,ax
               mov   ax,seg BUFFER
               mov   ds,ax
     load_loop:
               mov   bx,word ptr cs:[file_handle]
               mov   ah,3fh
               mov   cx,65000
               xor   dx,dx
               int   21h
               mov   cx,ax
               or    ax,ax
               je    file_end
               xor   di,di
   copy_buffer:
               mov   al,byte ptr ds:[di]
               mov   byte ptr es:[esi],al
               inc   di
               inc   esi
               cmp   di,cx
               jne   copy_buffer
               jmp   load_loop
      file_end:
               mov   bx,word ptr cs:[file_handle]
               mov   ah,3eh
               int   21h
  load_texture:
               mov   ax,cs
               mov   ds,ax
               mov   ax,3d00h
               mov   dx,offset name_texture
               int   21h
               jnc   no_file_error2
               call  deinit_engine
               mov   dx,offset error_file
               jmp   exit
no_file_error2:
               mov   word ptr cs:[file_handle],ax
               mov   bx,ax
               mov   ah,3fh
               mov   cx,768+10
               mov   dx,offset palette
               int   21h
               mov   ax,seg TEXTURE
               mov   ds,ax
               xor   dx,dx
               mov   cx,65535
               mov   ah,3fh
               mov   bx,word ptr cs:[file_handle]
               int   21h
               mov   bx,word ptr cs:[file_handle]
               mov   ah,3eh
               int   21h
   init_bucket:
               mov   ax,seg BUCKET
               mov   es,ax
               mov   di,65535
               xor   al,al
  clear_bucket:
               mov   es:[di],al
               dec   di
               jne   clear_bucket
   init_object:
               xor   ax,ax
               mov   ds,ax
               mov   esi,dword ptr cs:[ptr_object]
               mov   ax,word ptr ds:[esi]
               mov   word ptr cs:[faces],ax
               mov   ax,word ptr ds:[esi+2]
               mov   word ptr cs:[vertexes],ax
               mov   cx,word ptr cs:[faces]
               add   esi,4
               mov   bx,cx
               and   ebx,0ffffh
               shl   ebx,4
               add   ebx,esi
 init_facedata:
               mov   eax,ds:[esi]
               mov   edx,24
               mul   edx
               add   eax,ebx
               mov   ds:[esi],eax
               mov   eax,ds:[esi+4]
               mov   edx,24
               mul   edx
               add   eax,ebx
               mov   ds:[esi+4],eax
               mov   eax,ds:[esi+8]
               mov   edx,24
               mul   edx
               add   eax,ebx
               mov   ds:[esi+8],eax
               add   esi,16
               dec   cx
               jne   init_facedata
               ret
init_engine    endp
;
init_vga       proc near                          ;50Hz mode-Q by Liket/Goto 10
               mov   ax,13h
               int   10h
               mov   ax,cs
               mov   ds,ax
               mov   cx,768
               mov   si,offset palette+10
               xor   al,al
               mov   dx,03c8h
               out   dx,al
               inc   dx
               rep   outsb
               mov   dx,03d4h
               mov   al,11h
               out   dx,al
               inc   dx
               in    al,dx
               and   al,07fh
               out   dx,al
               mov   dx,03c2h
               mov   al,0e3h
               out   dx,al
               mov   dx,03d4h
               mov   al,0
               out   dx,al
               inc   dx
               mov   al,05fh
               out   dx,al
               mov   dx,03d4h
               mov   al,1
               out   dx,al
               inc   dx
               mov   al,03fh
               out   dx,al
               mov   dx,03d4h
               mov   al,02h
               out   dx,al
               inc   dx
               mov   al,40h
               out   dx,al
               mov   dx,03d4h
               mov   al,03h
               out   dx,al
               inc   dx
               mov   al,82h
               out   dx,al
               mov   dx,03d4h
               mov   al,04h
               out   dx,al
               inc   dx
               mov   al,04ah
               out   dx,al
               mov   dx,03d4h
               mov   al,05h
               out   dx,al
               inc   dx
               mov   al,09ah
               out   dx,al
               mov   dx,03d4h
               mov   al,06h
               out   dx,al
               inc   dx
               mov   al,06fh
               out   dx,al
               mov   dx,03d4h
               mov   al,07h
               out   dx,al
               inc   dx
               mov   al,0b2h
               out   dx,al
               mov   dx,03d4h
               mov   al,08h
               out   dx,al
               inc   dx
               mov   al,0
               out   dx,al
               mov   dx,03d4h
               mov   al,09h
               out   dx,al
               inc   dx
               mov   al,61h
               out   dx,al
               mov   dx,03d4h
               mov   al,10h
               out   dx,al
               inc   dx
               mov   al,28h
               out   dx,al
               mov   dx,03d4h
               mov   al,11h
               out   dx,al
               inc   dx
               mov   al,8ah
               out   dx,al
               mov   dx,03d4h
               mov   al,12h
               out   dx,al
               inc   dx
               mov   al,0ffh
               out   dx,al
               mov   dx,03d4h
               mov   al,13h
               out   dx,al
               inc   dx
               mov   al,20h
               out   dx,al
               mov   dx,03d4h
               mov   al,14h
               out   dx,al
               inc   dx
               mov   al,40h
               out   dx,al
               mov   dx,03d4h
               mov   al,15h
               out   dx,al
               inc   dx
               mov   al,7h
               out   dx,al
               mov   dx,03d4h
               mov   al,16h
               out   dx,al
               inc   dx
               mov   al,1ah
               out   dx,al
               mov   dx,03d4h
               mov   al,17h
               out   dx,al
               inc   dx
               mov   al,0a3h
               out   dx,al
               mov   dx,03c4h
               mov   al,1
               out   dx,al
               inc   dx
               mov   al,1
               out   dx,al
               mov   dx,03c4h
               mov   al,3
               out   dx,al
               inc   dx
               mov   al,0
               out   dx,al
               mov   dx,03c4h
               mov   al,04h
               out   dx,al
               inc   dx
               mov   al,0eh
               out   dx,al
               mov   dx,03ceh
               mov   al,5
               out   dx,al
               inc   dx
               mov   al,40h
               out   dx,al
               mov   dx,03ceh
               mov   al,6
               out   dx,al
               inc   dx
               mov   al,5
               out   dx,al
               ret
init_vga       endp
;
deinit_vga     proc near
               mov   ax,03h
               int   10h
               ret
deinit_vga     endp
;
deinit_engine  proc near
               mov   ah,0dh
               mov   dx,word ptr cs:[xms_handle]
               call  cs:[ptr_himem]
               mov   ah,0ah
               mov   dx,word ptr cs:[xms_handle]
               call  cs:[ptr_himem]
               ret
deinit_engine  endp
;

; - variables and constants -
align 4
ptr_table1     dd 0
ptr_table2     dd 0
ptr_object     dd 0
ptr_bucket     dd 0
ptr_himem      dd 0
xms_handle     dw 0
file_handle    dw 0
file_size      dd 0
faces          dw 0
vertexes       dw 0
xan            dw 0
yan            dw 0
zan            dw 0
siz            dw 0
coy            dw 0
x_pos          dw 0
y_pos          dw 0
z_pos          dw 2000
frame          dd 0
include        88sincos.inc
ys             dw 0
ye             dw 0
poly_x1        dw 0
poly_x2        dw 0
poly_x3        dw 0
poly_y1        dw 0
poly_y2        dw 0
poly_y3        dw 0
poly_u1        db 0
poly_v1        db 0
poly_u2        db 0
poly_v2        db 0
poly_u3        db 0
poly_v3        db 0
align 4
scan_table     dd 512 dup (0)
name_object    db 'test.f3d',0
name_texture   db 'my1.scx' ,0
start_msg      db ' Initializing Super-Flat3D' ,0dh,0ah,'$'
error_xms      db '00: XMS-memory failure'      ,0dh,0ah,'$'
error_v86      db '01: V86 mode detected'       ,0dh,0ah,'$'
error_file     db '02: File error'              ,0dh,0ah,'$'
error_esc      db '03: Terminated by user'      ,0dh,0ah,'$'
error_auto     db '04: Auto termination '       ,0dh,0ah,'$'
palette        db 768+10 dup (0)

ENGINE         ends

;
MYGDT segment para public 'data' use16
gdt            dw 4 dup(0)
gdt_code16=8
               dw 0ffffh,0,9a00h,0
gdt_code32=16
               dw 0ffffh,0,9a00h,0cfh
gdt_data16=24
               dw 0ffffh,0,9200h,0
gdt_data32=32
               dw 0ffffh,0,9200h,8fh
ptr_gdt        label fword
               dw 40-1
               dd offset mygdt:gdt
               dw 0
save_nmi       db 0
MYGDT          ends
;

end
