/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 33                         
                                                                              
 Demonstrates the use of wbezier. Draws random curves until key pressed.     
                                                                              
 *** PROJECT ***                                                             
 This program requires the file WGT5_WC.LIB to be linked.                    
                                                                              
 *** DATA FILES ***                                                          
 NONE                                                                        
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <stdlib.h>
#include <wgt5.h>

#define NUM_IN 5       /* number of random points */
#define NUM_OUT 30     /* number of points of bezier curve */
/* Fewer points will make more chunky line */

void main (void)
{
  tpolypoint inpoint[NUM_IN];   /* Array with the normal curve points */
  tpolypoint outpoint[NUM_OUT]; /* Array with smooth curve points */
  block other;                  /* Pointer to our second screen */
  short i;                        /* Loop counter */
  short oldmode;                  /* Stores initial video mode */

  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }

  printf ("WGT Example #33\n\n");
  printf ("Random bezier curves are drawn until a key is pressed.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode ();         /* Gets the current mode */
  vga256 ();                     /* Initialize graphics mode */

  other = wnewblock (0, 0, 319, 199);    /* Allocate second screen */

  wsetcolor (15);                        /* Draw with white */

  do {
    wsetscreen (other);                  /* We'll draw on the hidden screen */
    wcls (0);                            /* Clear it with black */

    for (i = 0; i < NUM_IN; i++)         /* Randomize the BEZIER control pts */
    {
      inpoint[i].x = rand () % 320;
      inpoint[i].y = rand () % 200;
    }

    wbezier (inpoint, NUM_IN, outpoint, NUM_OUT);   /* Generate line */

    whollowpoly (outpoint, NUM_OUT, 0, 0, OPEN_POLY);
    /* draw the smooth curve */

    wnormscreen ();                 /* Reset drawing to visual screen */
    wputblock (0, 0, other, 0);     /* Show the screen */
  } while (!kbhit ());              /* Abort if key pressed */
  getch ();                         /* Get the key */

  wfreeblock (other);            /* Free our screen buffer */
  wsetmode (oldmode);            /* Restore initial video mode */
}
 
 
 

