/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 34                         
                                                                              
  This program shows how WGT for Watcom can create absolutley HUGE blocks.    
  It also demonstrates how to use wsetscreen to direct output to ANY block    
  regardless of dimensions. An image is created by allocating a large         
  block from whatever memory is available and then randomly scattering        
  200 "smaller" 64k images throughout the larger block.                       
                                                                              
  Once this is done, click and move the mouse to scroll the large block.      
                                                                              
  *** PROJECT ***                                                             
  This program requires the file WGT5_WC.LIB to be linked.                    
                                                                              
  *** DATA FILES ***                                                          
  WGT1.PCX must be in your executable directory.                 
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <wgt5.h>

block pic, bigpic;
color pal[256];

void main (void)
{
  int freeram;
  int dimension;
  short oldmode;
  short ctr;
  short ox, oy, sx, sy, vx, vy;

  printf ("WGT Example #34\n\n");
  printf ("A LARGE virtual screen is created using as much free ram as possible,\n");
  printf ("and then it may be viewed by clicking and dragging the mouse cursor to set a\n");
  printf ("new viewing location. Press a key to end the program at any time.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode ();

  pic = wloadpcx ("wgt1.pcx", pal);
  

  /* Find free ram and create a block using almost all memory available */
  freeram = getmemfree ();
  printf ("Free memory %d\n", freeram);
  dimension = sqrt (freeram - 100000);  
  printf ("Block dimensions %d by %d\n", dimension, dimension);  
  printf ("\n\n\nPress a key.\n");
  getch ();
  
  vga256 ();
  wsetpalette (0, 255, pal);

  bigpic = wallocblock (dimension, dimension);
  
  wtextcolor (200);
  wtexttransparent (TEXTFG);
  wouttextxy (0, 80, NULL, "HUGE block allocated");
  wouttextxy (0, 100, NULL, "Now shuffling blocks.....");
  
  /* Set all output to our huge block, then randomly paste 200 small blocks */
  wsetscreen (bigpic);
  for (ctr = 0; ctr < 200; ctr++)
    wputblock (rand () % dimension, rand () % dimension, pic, NORMAL);

  /* Return to normal viewing screen and allow user to view big block */
  wnormscreen ();
  wputblock (0, 0, bigpic, NORMAL);
  vx = 0;
  vy = 0;
  wouttextxy (0, 0, NULL, "Viewing (0, 0)");
  minit ();
  mon ();
  wtexttransparent (TEXTFGBG);
  while (!kbhit ())
  {
    if (mouse.but > 0)
    {
      sx = mouse.mx; 
      sy = mouse.my;
      ox = vx;
      oy = vy;
      moff ();
      while (mouse.but > 0)
      {
        if ((mouse.mx != sx) || (mouse.my != sy))
        {
          /* Shift image base on mouse coordinates */
          ox = vx - (sx - mouse.mx);
          oy = vy - (sy - mouse.my);

          /* Now check to make sure we didn't go past end of image */
          if (ox + dimension < 320)
            ox = 320 - dimension;
          if (oy + dimension < 200)
            oy = 200 - dimension;
          if (ox > 0)
            ox = 0;
          if (oy > 0)
            oy = 0;

          /* Now show the image*/
          wputblock (ox, oy, bigpic, NORMAL);
          
          /* TRY DELETING THE FOLLOWING TWO LINES AND RUNNING THE PROGRAM */
          sx = mouse.mx;
          sy = mouse.my;

          vx = ox;
          vy = oy;
          wgtprintf (0, 0, NULL, "Viewing (%d, %d)", -vx, -vy);
        }
      }
      mon ();
    }
  }
  getch ();
  moff ();
  mdeinit ();
  wfreeblock (bigpic);
  wfreeblock (pic);
  wsetmode (oldmode);
}

