/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 64                         
                                                                              
 This is a picture viewer for PCX, IFF and LBM images. All images
 are displayed using 320x200x256. Use the mouse to drag the image around
 if it is larger than the screen. Press any key to exit the viewer.

 The image filename must be passed on the command line.

 *** PROJECT ***                                                             
 This program needs the WGT5_WC.LIB file to be linked.   
                                                                              
 *** DATA FILES ***                                                          
 Any PCX, IFF or LBM format pictures.                                   
                                                           WATCOM C++ VERSION 
==============================================================================
*/
#include <wgt5.h>
#include <stdio.h>
#include <stdlib.h>

color pal[256];
block bigpic;

void main (int argc, char *argv[])
{
  short oldmode; 
  short vx, vy, sx, sy, ox, oy;
  short w, h;
  char *pathbuf;
  char drive[_MAX_DRIVE];
  char dir[_MAX_DIR];
  char fname[_MAX_FNAME];
  char ext[_MAX_EXT];

  oldmode = wgetmode ();
  if (argc < 2) 
  {
    printf ("WGT Example #64\n\n");
    printf ("This program displays a picture and allows you to slide\n");
    printf ("around with the mouse.\n");
    printf ("\nUsage: WGT64 filename\n\n");
    printf ("Where filename is a PCX, IFF or LBM image file format.\n");
    exit (0);
  }
  vga256 ();
  
  vx = vy = 0;
  
  pathbuf = argv[1];
  _splitpath (pathbuf, &drive, &dir, &fname, &ext);
  
  
  /* Find out what kind of picture it is and load the image */
  if (strcmp (ext, ".pcx") == 0)
    bigpic = wloadpcx (argv[1], pal);
  else if ((strcmp (ext, ".iff") == 0) || (strcmp (ext, ".lbm") == 0))
    bigpic = wloadiff (argv[1], pal);
  
  if (bigpic != NULL)
  {
    wsetmode (3);
    w = wgetblockwidth (bigpic);        /* Inform user of loaded data */
    h = wgetblockheight (bigpic);
    printf ("Image is %d by %d pixels.\n", w, h);
    printf ("%d kbytes.\n\n\n", w*h);
    getch ();
    vga256 ();
    wsetpalette (0, 255, pal);
    wputblock (vx, vy, bigpic, NORMAL);
    minit ();
    mon ();
    while (!kbhit ())                   /* Now let user scroll around */
    {
      if (mouse.but > 0)
      {
        sx = mouse.mx; 
        sy = mouse.my;
        ox = vx;
        oy = vy;
        moff ();
        while (mouse.but > 0)
        {
          ox = vx - (sx - mouse.mx);
          oy = vy - (sy - mouse.my);
          if (ox + w < 320)
            ox = 320 - w;
          if (oy + h < 200)
            oy = 200 - h;
          if (ox > 0)
            ox = 0;
          if (oy > 0)
            oy = 0;

          wputblock (ox, oy, bigpic, NORMAL);
        }
        vx = ox;
        vy = oy;
        mon ();
      }
    }
    getch ();
    wfreeblock (bigpic);
    moff ();
    mdeinit ();
    wfade_out (0, 255, 20, pal);
  }
  wsetmode (oldmode);
}
