#ifndef _WGT3D_
#define _WGT3D_

#include <wgt5.h>

/*
   WordUp Graphics Toolkit V5.0  3D Routines
   Copyright 1995 Egerter Software
*/

#ifdef __cplusplus
  extern "C" {
#endif

typedef struct
    {
    short x, y, z;
    short sx, sy;
    } point3d;

extern int xct, yct; /* Center of screen */
extern int sx, sy, sz; /* Scale Factors */
extern short move_x;
extern short origin_x;
extern short move_y;
extern short origin_y;
extern short move_z;
extern short origin_z;

extern int icos[360], isin[360]; /* Sin/cos tables */

extern int cos_1, cos_2, cos_3;
extern int sin_1, sin_2, sin_3;

void    winit3d (void);
void    wrotatepoints (point3d *orig_pointlist, point3d *rotated_pointlist,
                       short maxpoint);
void    wsetrotation (short rotate_x, short rotate_y, short rotate_z);

#ifdef __cplusplus
}
#endif

#endif
