#include <stdlib.h>
#include <conio.h>
#include "wgtsvga.h"

/* Drawing random lines on the front buffer */

int vesa_version;
int mode_number;


void ChooseMode (void)
{
int i;
int pagecount;

  i = 0;
  pagecount = 0;
  while (VESAmodes[i].mode_number != -1)
    {
     if (VESAmodes[i].available)
       {
        printf ("Mode:%i %ix%i Avail:%i Bits:%i Linear:%i Pages:%i\n",
                 i,
                 VESAmodes[i].width,
                 VESAmodes[i].height,
                 VESAmodes[i].available,
                 VESAmodes[i].bits,
                 VESAmodes[i].linear,
                 VESAmodes[i].pages);
        pagecount++;
        if (pagecount > 22)
          {
           pagecount = 0;
           printf ("Press any key for more\n");
           getch ();
           while (kbhit()) getch ();
          }
       }  /* Available */
     i++;
    }

  printf ("Choose the mode number:\n");
  scanf ("%i", &mode_number);
}





void main (int argc, char *argv[])
{
int res;
int width, height;

  vesa_version = wvesa_detect ();
  wvesa_findmodeinfo ();

  ChooseMode ();

  width  = VESAmodes[mode_number].width;
  height = VESAmodes[mode_number].height;

  res = wvesa_setmode (width, height,
                       VESAmodes[mode_number].bits,
                       VESAmodes[mode_number].linear);
  if (!res)
    {
     printf ("Cannot open the video mode\n");
     exit (1);
    }

  wvesa_setscreen (SVGA_FRONTBUFFER);

  while (!kbhit())
    {
     wsetcolor (rand () % 256);

     wvesa_line (rand () % width, rand () % height,
                 rand () % width, rand () % height);
    }


  getch ();
  wsetmode (3);
}
