p386
p387
ideal
locals
largestack

;

o equ offset
b equ byte
w equ word
d equ dword
s equ short
n equ near
f equ far

;

segment code32 page public use32
        assume cs:code32, ds:code32

include "\code\omn\include\macros.inc"  ;You'll have to supply you own
include "\code\omn\pmode\pmode.inc"     ;versions of these to assemble
include "\code\omn\video\video.inc"     ;this file.
include "\code\omn\include\strucs.inc"  ;You'll also have to choose
include "\code\omn\fmath\fmath.inc"     ;appropriate directories.

include "\code\omn\scan\scan.inc"
include "\code\omn\scan\scan_pgl.inc"

;

struc   edge_struc
X               dd ?
XStep           dd ?
Y               dd ?
Height          dd ?
OneOverZ        dd ?
OneOverZStep    dd ?
UOverZ          dd ?
UOverZStep      dd ?
VOverZ          dd ?
VOverZStep      dd ?
Intens          dd ?
IntensStep      dd ?
ends

;
;sort the vertices from top to bottom, get the texel coords

macro   sort_vertices  

        fld     [d ebx + 4]
        fcomp   [d ecx + 4]
        fnstsw  ax
        and     ah, 41h
        jz      @@0_not_top

        fld     [d ebx + 4]
        fcomp   [d edx + 4]
        fnstsw  ax
        and     ah, 41h
        jz      @@0_not_top

@@0_top:
        ;get texel coords
        mov     eax, [esi + polygon.u1]
        mov     ebp, [esi + polygon.u2]
        mov     edi, [esi + polygon.u3]
        mov     [d UOverZ], eax
        mov     [d UOverZ + 4], ebp
        mov     [d UOverZ + 8], edi
        mov     eax, [esi + polygon.v1]
        mov     ebp, [esi + polygon.v2]
        mov     edi, [esi + polygon.v3]
        mov     [d VOverZ], eax
        mov     [d VOverZ + 4], ebp
        mov     [d VOverZ + 8], edi

        jmp     @@sorted

@@0_not_top:
        fld     [d ecx + 4]
        fcomp   [d ebx + 4]
        fnstsw  ax
        and     ah, 41h
        jz      @@1_not_top

        fld     [d ecx + 4]
        fcomp   [d edx + 4]
        fnstsw  ax
        and     ah, 41h
        jz      @@1_not_top

@@1_top:
        mov     eax, ebx
        mov     ebx, ecx
        mov     ecx, edx
        mov     edx, eax

        ;get texel coords
        mov     eax, [esi + polygon.u2]
        mov     ebp, [esi + polygon.u3]
        mov     edi, [esi + polygon.u1]
        mov     [d UOverZ], eax
        mov     [d UOverZ + 4], ebp
        mov     [d UOverZ + 8], edi
        mov     eax, [esi + polygon.v2]
        mov     ebp, [esi + polygon.v3]
        mov     edi, [esi + polygon.v1]
        mov     [d VOverZ], eax
        mov     [d VOverZ + 4], ebp
        mov     [d VOverZ + 8], edi

        jmp     @@sorted

@@1_not_top:
@@2_top:
        mov     eax, ebx
        mov     ebx, edx
        mov     edx, ecx
        mov     ecx, eax

        ;get texel coords
        mov     eax, [esi + polygon.u3]
        mov     ebp, [esi + polygon.u1]
        mov     edi, [esi + polygon.u2]
        mov     [d UOverZ], eax
        mov     [d UOverZ + 4], ebp
        mov     [d UOverZ + 8], edi
        mov     eax, [esi + polygon.v3]
        mov     ebp, [esi + polygon.v1]
        mov     edi, [esi + polygon.v2]
        mov     [d VOverZ], eax
        mov     [d VOverZ + 4], ebp
        mov     [d VOverZ + 8], edi

@@sorted:

endm

;
;copy the vertices and convert u, v to u/z, v/z

macro   copy_vertices  

        mov     eax, [ebx]
        mov     ebp, [ebx + 4]
        fld     [d ebx + 8]         ;this should be a mov? no spare regs
        mov     edi, [ebx + 12]
        mov     [X], eax
        mov     [Y], ebp
        mov     [Intens], edi
        fstp    [OneOverZ]          ;hmmm... have a fiddle with this

        mov     eax, [ecx]
        mov     ebp, [ecx + 4]
        fld     [d ecx + 8]
        mov     edi, [ecx + 12]
        mov     [X + 4], eax
        mov     [Y + 4], ebp
        mov     [Intens + 4], edi
        fstp    [OneOverZ + 4]

        mov     eax, [edx]
        mov     ebp, [edx + 4]
        fld     [d edx + 8]
        mov     edi, [edx + 12]
        mov     [X + 8], eax
        mov     [Y + 8], ebp
        mov     [Intens + 8], edi
        fstp    [OneOverZ + 8]

        fld     [d UOverZ]                        ;1
        fmul    [OneOverZ]                      ;2-4
        fld     [d UOverZ + 4]                    ;3
        fmul    [OneOverZ + 4]                  ;4-6
        fld     [d UOverZ + 8]                    ;5
        fmul    [OneOverZ + 8]                  ;6-8
        fxch    st(2)                           ;6
        fstp    [d UOverZ]                        ;7
        fstp    [d UOverZ + 4]                    ;8
        fstp    [d UOverZ + 8]                    ;9

        fld     [d VOverZ]                        ;1
        fmul    [OneOverZ]                      ;2-4
        fld     [d VOverZ + 4]                    ;3
        fmul    [OneOverZ + 4]                  ;4-6
        fld     [d VOverZ + 8]                    ;5
        fmul    [OneOverZ + 8]                  ;6-8
        fxch    st(2)                           ;6
        fstp    [d VOverZ]                        ;7
        fstp    [d VOverZ + 4]                    ;8
        fstp    [d VOverZ + 8]                    ;9

endm

;
;calc the gradients for the whole polygon

macro   gradients  

        ;calculate common x-product terms
        fld     [X]
        fsub    [X + 8]                 
        fld     [X + 4]
        fsub    [X + 8]
        fld     [Y]
        fsub    [Y + 8]
        fld     [Y + 4]
        fsub    [Y + 8]
        fxch    st(3)
        fstp    [Ax_Cx]
        fxch    st(1)
        fstp    [Bx_Cx]
        fstp    [Ay_Cy]
        fstp    [By_Cy]

        fld     [OneOverZ]
        fsub    [OneOverZ + 8]
        fld     [OneOverZ + 4]
        fsub    [OneOverZ + 8]
        fld     [d UOverZ]
        fsub    [d UOverZ + 8]
        fld     [d UOverZ + 4]
        fsub    [d UOverZ + 8]
        fxch    st(3)
        fstp    [Az_Cz]
        fxch    st(1)
        fstp    [Bz_Cz]
        fstp    [Au_Cu]
        fstp    [Bu_Cu]

        fld     [d VOverZ]
        fsub    [d VOverZ + 8]
        fld     [d VOverZ + 4]
        fsub    [d VOverZ + 8]
        fld     [Intens]
        fsub    [Intens + 8]
        fld     [Intens + 4]
        fsub    [Intens + 8]
        fxch    st(3)
        fstp    [Av_Cv]
        fxch    st(1)
        fstp    [Bv_Cv]
        fstp    [Ai_Ci]
        fstp    [Bi_Ci]

        ;calculate x-products
        fld1
        fld     [Bx_Cx]
        fmul    [Ay_Cy]
        fld     [Ax_Cx]
        fmul    [By_Cy]
        fsub                                    ;aargh
        fdiv                                    ;aargh
        fst     [OneOverdX]
        fstp    [OneOverdY]
        xor     [OneOverdY], 80000000h

        fld     [Bz_Cz]
        fmul    [Ay_Cy]
        fld     [Az_Cz]
        fmul    [By_Cy]
        fld     [Az_Cz]
        fmul    [Bx_Cx]                 
        fld     [Bz_Cz]
        fmul    [Ax_Cx]                 ;ax, bx, by, ay
        fxch    st(2)                   ;by, bx, ax, ay
        fsubp   st(3), st               ;bx, ax, ay-by
        fsub                            ;ax-bx, ay-by
        fxch    st(1)
        fmul    [OneOverdX]
        fxch    st(1)
        fmul    [OneOverdY]
        fxch    st(1)
        fstp    [dOneOverZdX]
        fstp    [dOneOverZdY]

        fld     [Bu_Cu]
        fmul    [Ay_Cy]
        fld     [Au_Cu]
        fmul    [By_Cy]
        fld     [Au_Cu]
        fmul    [Bx_Cx]                 
        fld     [Bu_Cu]
        fmul    [Ax_Cx]                 ;ax, bx, by, ay
        fxch    st(2)                   ;by, bx, ax, ay
        fsubp   st(3), st               ;bx, ax, ay-by
        fsub                            ;ax-bx, ay-by
        fxch    st(1)
        fmul    [OneOverdX]
        fxch    st(1)
        fmul    [OneOverdY]
        fxch    st(1)
        fstp    [d dUOverZdX]
        fstp    [d dUOverZdY]

        fld     [Bv_Cv]
        fmul    [Ay_Cy]
        fld     [Av_Cv]
        fmul    [By_Cy]
        fld     [Av_Cv]
        fmul    [Bx_Cx]                 
        fld     [Bv_Cv]
        fmul    [Ax_Cx]                 ;ax, bx, by, ay
        fxch    st(2)                   ;by, bx, ax, ay
        fsubp   st(3), st               ;bx, ax, ay-by
        fsub                            ;ax-bx, ay-by
        fxch    st(1)
        fmul    [OneOverdX]
        fxch    st(1)
        fmul    [OneOverdY]
        fxch    st(1)
        fstp    [d dVOverZdX]
        fstp    [d dVOverZdY]

        fld     [Bi_Ci]
        fmul    [Ay_Cy]
        fld     [Ai_Ci]
        fmul    [By_Cy]
        fld     [Ai_Ci]
        fmul    [Bx_Cx]                 
        fld     [Bi_Ci]
        fmul    [Ax_Cx]                 ;ax, bx, by, ay
        fxch    st(2)                   ;by, bx, ax, ay
        fsubp   st(3), st               ;bx, ax, ay-by
        fsub                            ;ax-bx, ay-by
        fxch    st(1)
        fmul    [OneOverdX]
        fxch    st(1)
        fmul    [OneOverdY]
        fxch    st(1)
        fst     [dIdX]
        fistp   [dIdX_int]
        fstp    [dIdY]

        fld     [dOneOverZdX]
        fmul    [scan_16]
        fld     [d dUOverZdX]
        fmul    [scan_16]
        fld     [d dVOverZdX]
        fmul    [scan_16]
        fxch    st(2)
        fstp    [dOneOverZdX16]
        fstp    [d dUOverZdX16]
        fstp    [d dVOverZdX16]

endm

;
;calc the gradients for the edge

align 32
proc    edge n

        fld     [ebx + Y]                       ;1
        fadd    [scan_half]                     ;2-4
        fld     [esi + Y]                       ;3
        fadd    [scan_half]                     ;4-6
        fxch    st(1)                           ;4
        fistp   [edi + edge_struc.Y]            ;5-7
        fistp   [YEnd]                          ;6-8

        mov     eax, [YEnd]
        sub     eax, [edi + edge_struc.Y]
        mov     [edi + edge_struc.Height], eax

        fild    [edi + edge_struc.Y]
        fsub    [ebx + Y]
        fstp    [YPrestep]

        fld     [esi + X]
        fsub    [ebx + X]
        fld     [esi + Y]
        fsub    [ebx + Y]
        fdiv
        fst     [edi + edge_struc.XStep]
        fmul    [YPrestep]
        fst     [XPrestep]
        fadd    [ebx + X]
        fstp    [edi + edge_struc.X]

        fld     [YPrestep]
        fmul    [dOneOverZdY]
        fld     [XPrestep]
        fmul    [dOneOverZdX]
        fld     [edi + edge_struc.XStep]
        fmul    [dOneOverZdX]                          ;us, u2, u1
        fxch    st(1)                           ;u2, us, u1
        faddp   st(2), st                       ;us, u
        fadd    [dOneOverZdY]                          ;us, u
        fxch    st(1)                           ;u, us
        fadd    [ebx + OneOverZ]                       ;u, us
        fxch    st(1)                           ;us, u
        fstp    [edi + edge_struc.OneOverZStep]        ;u
        fstp    [edi + edge_struc.OneOverZ]

        fld     [YPrestep]
        fmul    [d dUOverZdY]
        fld     [XPrestep]
        fmul    [d dUOverZdX]
        fld     [edi + edge_struc.XStep]
        fmul    [d dUOverZdX]                          ;us, u2, u1
        fxch    st(1)                           ;u2, us, u1
        faddp   st(2), st                       ;us, u
        fadd    [d dUOverZdY]                          ;us, u
        fxch    st(1)                           ;u, us
        fadd    [d d ebx + UOverZ]                       ;u, us
        fxch    st(1)                           ;us, u
        fstp    [edi + edge_struc.UOverZStep]        ;u
        fstp    [edi + edge_struc.UOverZ]

        fld     [YPrestep]
        fmul    [d dVOverZdY]
        fld     [XPrestep]
        fmul    [d dVOverZdX]
        fld     [edi + edge_struc.XStep]
        fmul    [d dVOverZdX]                          ;us, u2, u1
        fxch    st(1)                           ;u2, us, u1
        faddp   st(2), st                       ;us, u
        fadd    [d dVOverZdY]                          ;us, u
        fxch    st(1)                           ;u, us
        fadd    [d d ebx + VOverZ]                       ;u, us
        fxch    st(1)                           ;us, u
        fstp    [edi + edge_struc.VOverZStep]        ;u
        fstp    [edi + edge_struc.VOverZ]

        fld     [YPrestep]
        fmul    [dIdY]
        fld     [XPrestep]
        fmul    [dIdX]
        fld     [edi + edge_struc.XStep]
        fmul    [dIdX]                          ;us, u2, u1
        fxch    st(1)                           ;u2, us, u1
        faddp   st(2), st                       ;us, u
        fadd    [dIdY]                          ;us, u
        fxch    st(1)                           ;u, us
        fadd    [ebx + Intens]                       ;u, us
        fxch    st(1)                           ;us, u
        fstp    [edi + edge_struc.IntensStep]        ;u
        fstp    [edi + edge_struc.Intens]
        ret

endp

;
;fill in the edge strucs

macro   get_toptomiddle
local   rightismiddle, done

        cmp     [leftismiddle], 1
        jne     rightismiddle

        mov     esi, o TopToMiddle
        mov     edi, o L_X
        mov     ecx, 12
        rep movsd
        mov     esi, o TopToBottom
        mov     edi, o R_X
        mov     ecx, 12
        rep movsd
        jmp     done

rightismiddle:
        mov     esi, o TopToMiddle
        mov     edi, o R_X
        mov     ecx, 12
        rep movsd
        mov     esi, o TopToBottom
        mov     edi, o L_X
        mov     ecx, 12
        rep movsd

done:

endm

;
;fill in the edge strucs

macro   get_middletobottom
local   rightismiddle, done

        mov     ecx, 12
        mov     esi, o MiddleToBottom
        push    edi

        cmp     [leftismiddle], 1
        jne     rightismiddle

        mov     edi, o L_X
        rep movsd
        jmp     done

rightismiddle:
        mov     edi, o R_X
        rep movsd
        mov     eax, [YPrestepL2]
        mov     ebx, [YPrestepR2]
        mov     [YPrestepR2], eax
        mov     [YPrestepL2], ebx

done:
        pop     edi

endm

;
;move down one scanline, update edges

align 32
proc    edge_step n

        fld     [L_X]                   
        fadd    [L_XStep]               
        fld     [L_OneOverZ]            
        fadd    [L_OneOverZStep]        
        fld     [L_UOverZ]              
        fadd    [L_UOverZStep]          
        fld     [L_VOverZ]              
        fadd    [L_VOverZStep]          
        fld     [L_Intens]              
        fadd    [L_IntensStep]          ;i, v, u, z, x
        fxch    st(4)                   ;x, v, u, z, i
        fstp    [L_X]                   ;v, u, z, i
        fxch    st(2)                   ;z, u, v, i
        fstp    [L_OneOverZ]            ;u, v, i
        fstp    [L_UOverZ]
        fstp    [L_VOverZ]
        fstp    [L_Intens]

        fld     [R_X]                   
        fadd    [R_XStep]               
        fld     [R_OneOverZ]            
        fadd    [R_OneOverZStep]        
        fld     [R_UOverZ]              
        fadd    [R_UOverZStep]          
        fld     [R_VOverZ]              
        fadd    [R_VOverZStep]          
        fld     [R_Intens]              
        fadd    [R_IntensStep]          ;i, v, u, z, x
        fxch    st(4)                   ;x, v, u, z, i
        fstp    [R_X]                   ;v, u, z, i
        fxch    st(2)                   ;z, u, v, i
        fstp    [R_OneOverZ]            ;u, v, i
        fstp    [R_UOverZ]
        fstp    [R_VOverZ]
        fstp    [R_Intens]
        ret

endp

;
;move down prestep scanlines, update edges, for clipping

align 32
proc    edge_multi_step n

        cmp     [YPrestepL1], 0
        je      @@done_l

        fild    [YPrestepL1]
        fld     [L_XStep]
        fmul    st, st(1)
        fld     [L_OneOverZStep]
        fmul    st, st(2)
        fld     [L_UOverZStep]
        fmul    st, st(3)
        fld     [L_VOverZStep]
        fmul    st, st(4)
        fld     [L_IntensStep]
        fmulp   st(5), st               ;v, u, z, x, i
        fxch    st(3)                   ;x, u, z, v, i
        fadd    [L_X]                   
        fxch    st(2)                   ;z, u, x, v, i
        fadd    [L_OneOverZ]            
        fxch    st(1)                   ;u, z, x, v, i
        fadd    [L_UOverZ]              
        fxch    st(3)                   ;v, z, x, u, i
        fadd    [L_VOverZ]              
        fxch    st(4)                   ;i, z, x, u, v
        fadd    [L_Intens]
        fxch    st(2)                   ;x, z, i, u, v
        fstp    [L_X]                   ;z, i, u, v 
        fstp    [L_OneOverZ]            ;i, u, v
        fxch    st(1)                   ;u, i, v
        fstp    [L_UOverZ]              ;i, v
        fxch    st(1)                   ;v, i
        fstp    [L_VOverZ]              ;i
        fstp    [L_Intens]

@@done_l:
        cmp     [YPrestepR1], 0
        je      @@done_r

        fild    [YPrestepR1]
        fld     [R_XStep]
        fmul    st, st(1)
        fld     [R_OneOverZStep]
        fmul    st, st(2)
        fld     [R_UOverZStep]
        fmul    st, st(3)
        fld     [R_VOverZStep]
        fmul    st, st(4)
        fld     [R_IntensStep]
        fmulp   st(5), st               ;v, u, z, x, i
        fxch    st(3)                   ;x, u, z, v, i
        fadd    [R_X]                   
        fxch    st(2)                   ;z, u, x, v, i
        fadd    [R_OneOverZ]            
        fxch    st(1)                   ;u, z, x, v, i
        fadd    [R_UOverZ]              
        fxch    st(3)                   ;v, z, x, u, i
        fadd    [R_VOverZ]              
        fxch    st(4)                   ;i, z, x, u, v
        fadd    [R_Intens]
        fxch    st(2)                   ;x, z, i, u, v
        fstp    [R_X]                   ;z, i, u, v 
        fstp    [R_OneOverZ]            ;i, u, v
        fxch    st(1)                   ;u, i, v
        fstp    [R_UOverZ]              ;i, v
        fxch    st(1)                   ;v, i
        fstp    [R_VOverZ]              ;i
        fstp    [R_Intens]

@@done_r:
        ret

endp

;
;update perspective u,v's along scanline subdivision

macro   step16

        fld     [@@OneOverZ]
        fadd    [dOneOverZdX16]
        fld     [@@UOverZ]
        fadd    [d dUOverZdX16]
        fld     [@@VOverZ]      
        fadd    [d dVOverZdX16]
        fxch    st(2)
        fstp    [@@OneOverZ]
        fstp    [@@UOverZ]      
        fstp    [@@VOverZ]      

endm

;
;calc perspective correct u,v & store

macro   calc0

        fld1
        fdiv    [@@OneOverZ]

        fld     [@@UOverZ]              ;1/z
        fmul    st, st(1)               ;u', 1/z  
        fld     [@@VOverZ]              ;v, u', 1/z
        fmulp   st(2), st               ;u', v'
        fistp   [@@U0]
        fistp   [@@V0]

        step16

endm

;
;calc perspective correct u,v

macro   calc1

        fld1
        fdiv    [@@OneOverZ]

endm

;
;store

macro   store1

        fld     [@@UOverZ]              ;1/z
        fmul    st, st(1)               ;u', 1/z  
        fld     [@@VOverZ]              ;v, u', 1/z
        fmulp   st(2), st               ;u', v'
        fistp   [@@U1]
        fistp   [@@V1]

        step16

endm

;

align 32
proc    draw_scanline n

        fld     [L_X]
        fadd    [scan_half]
        fld     [R_X]
        fadd    [scan_half]
        fxch    st(1)
        fistp   [@@XStart]
        fistp   [@@XEnd]

        fild    [@@XStart]
        fsub    [L_X]
        fstp    [@@XPrestep]

        mov     ebx, [@@XStart]
        mov     ebp, [@@XEnd]
        mov     esi, ebp

        add     edi, ebx
        sub     ebp, ebx
        jle     @@done

        cmp     ebx, [zed_right]
        jg      @@done
        sub     ebx, [zed_left]
        jge     @@leftok

        neg     ebx
        sub     ebp, ebx
        jle     @@done

        add     edi, ebx
        fld     [@@XPrestep]
        mov     [@@XPrestep], ebx
        fild    [@@XPrestep]
        fadd
        fstp    [@@XPrestep]

@@leftok:
        cmp     esi, [zed_left]
        jl      @@done
        sub     esi, [zed_right] 
        jle     @@rightok
        
        sub     ebp, esi
        jle     @@done

@@rightok:
        fld     [dOneOverZdX]           ;1
        fmul    [@@XPrestep]            ;2-4
        fld     [d dUOverZdX]             ;3
        fmul    [@@XPrestep]            ;4-6
        fld     [d dVOverZdX]             ;5
        fmul    [@@XPrestep]            ;6-8
        fld     [dIdX]             ;7
        fmul    [@@XPrestep]            ;8-10   ;i, v, u, z
        fxch    st(3)                   ;8      ;z, v, u, i
        fadd    [L_OneOverZ]            ;9-11
        fxch    st(2)                   ;9      ;u, v, z, i
        fadd    [L_UOverZ]              ;10-12
        fxch    st(1)                   ;10     ;v, u, z, i
        fadd    [L_VOverZ]              ;11-13
        fxch    st(3)                   ;11     ;i, u, z, v
        fadd    [L_Intens]              ;12-14
        fxch    st(2)                   ;12     ;z, u, i, v
        fstp    [@@OneOverZ]            ;13     ;u, i, v
        fstp    [@@UOverZ]              ;14     ;i, v
        fxch    st(1)                   ;14
        fstp    [@@VOverZ]              ;15     ;i
        fistp   [@@Intens]              ;16

        push    edi ebp
        mov     edi, o scanline_buffer
        shr     ebp, 4
        jz      @@no_16

        calc0
        calc1
        store1

        mov     [@@count16], ebp
        mov     ebp, [tex_ptr]

@@texture_16:
        calc1

        mov     edx, [@@U0]
        mov     eax, [@@V0]
        shl     edx, 16
        shl     eax, 16

        mov     ebx, [@@U1]
        sub     ebx, [@@U0]
        sar     ebx, 4
        mov     esi, ebx
        sar     ebx, 16
        shl     esi, 16
        mov     dl, bl

        mov     ebx, [@@V1]
        sub     ebx, [@@V0]
        sar     ebx, 4
        mov     ecx, ebx
        sar     ebx, 16
        shl     ecx, 16
        mov     dh, bl

        xor     ebx, ebx
        mov     bl, [b @@U0 + 2]
        mov     bh, [b @@V0 + 2]

        _16_texels
        
        mov     eax, [@@U1]
        mov     ebx, [@@V1]
        mov     [@@U0], eax
        mov     [@@V0], ebx

        store1

        add     edi, 16
        dec     [@@count16]
        jnz     @@texture_16

        fld     [@@OneOverZ]
        fsub    [dOneOverZdX16]
        fld     [@@UOverZ]
        fsub    [d dUOverZdX16]
        fld     [@@VOverZ]      
        fsub    [d dVOverZdX16]   ;v, u, z
        fxch    st(2)           ;z, u, v
        fsub    [dOneOverZdX16]
        fxch    st(1)           ;u, z, v
        fsub    [dUOverZdX16]
        fxch    st(2)           ;v, z, u
        fsub    [dVOverZdX16]
        fxch    st(1)           ;z, v, u
        fstp    [@@OneOverZ]
        fxch    st(1)           ;u, v
        fstp    [@@UOverZ]      
        fstp    [@@VOverZ]      

@@no_16:
        mov     ebp, [esp]
        and     ebp, 15
        jz      @@no_n

@@texture_n:
        fld1
        mov     [@@Len], ebp
        fild    [@@Len]
        fst     [@@Len]
        fdiv                            ;dX
        fld1
        fdiv    [@@OneOverZ]            ;z, dX

        fld     [@@UOverZ]              ;u/z, z, dX
        fmul    st, st(1)               ;u, z, dX
        fld     [@@VOverZ]              ;v/z, u, z, dX
        fmulp   st(2), st               ;u, v, dX
        fist    [@@U0]
        fxch    st(1)                   ;v, u, dX
        fist    [@@V0]
        fxch    st(1)                   ;u0, v0, dX

        fld     [dOneOverZdX]           
        fmul    [@@Len]                 
        fld     [d dUOverZdX]             
        fmul    [@@Len]                 
        fld     [d dVOverZdX]
        fmul    [@@Len]                 ;v/z, u/z, 1/z, u0, v0, dX
        fxch    st(2)                   ;1/z, u/z, v/z, u0, v0, dX
        fadd    [@@OneOverZ]
        fxch    st(1)                   ;u/z, 1/z, v/z, u0, v0, dX
        fadd    [@@UOverZ]
        fxch    st(2)                   ;v/z, 1/z, u/z, u0, v0, dX
        fadd    [@@VOverZ]

        fld1                            ;1, v/z, 1/z, u/z, u0, v0, dX
        fdivrp  st(2), st               ;v/z, z, u/z, u0, v0, dX
        fxch    st(2)                   ;u/z, z, v/z, u0, v0, dX
        fmul    st, st(1)               ;u, z, v/z, u0, v0, dX
        fxch    st(2)                   ;v/z, z, u, u0, v0, dX
        fmulp   st(1), st               ;v, u, u0, v0, dX
        fxch    st(1)                   ;u, v, u0, v0, dX
        fsubrp  st(2), st               ;v, du, v0, dX
        fsubrp  st(2), st               ;du, dv, dX
        fmul    st, st(2)               ;dudX, dv, dX
        fxch    st(1)                   ;dv, dudX, dX
        fmulp   st(2), st               ;dudX, dvdX
        fistp   [@@dUdX]                ;dvdX
        fistp   [@@dVdX]

        mov     eax, [tex_ptr]
        mov     [d @@texture_n_loop + 2], eax

        mov     edx, [@@U0]
        mov     eax, [@@V0]
        shl     edx, 16
        shl     eax, 16

        mov     ebx, [@@dUdX]
        mov     esi, ebx
        sar     ebx, 16
        shl     esi, 16
        mov     dl, bl

        mov     ebx, [@@dVdX]
        mov     ecx, ebx
        sar     ebx, 16
        shl     ecx, 16
        mov     dh, bl

        xor     ebx, ebx
        mov     bl, [b @@U0 + 2]
        mov     bh, [b @@V0 + 2]
        add     edi, ebp
        neg     ebp

@@texture_n_loop:
        mov     al, [ebx + 0ff00h]
        add     edx, esi

        adc     bl, dl
        add     eax, ecx

        adc     bh, dh
        mov     [edi + ebp], al

        inc     ebp
        jnz     @@texture_n_loop

@@no_n:
        pop     ebp edi

        mov     eax, [light_ptr]
        mov     al, [b @@Intens + 2]
        mov     bl, [b dIdX_int + 2]
        mov     ecx, [@@Intens]
        mov     edx, [dIdX_int]
        shl     ecx, 16
        shl     edx, 16

        lea     esi, [ebp + o scanline_buffer]
        neg     ebp

@@light:
        mov     ah, [esi + ebp]
        add     ecx, edx

        inc     edi
        mov     ah, [eax]

        adc     al, bl
        inc     ebp

        mov     [edi], ah
        jnz     @@light

@@done:
        ret

align 4
@@XStart        dd ?
@@XPrestep      dd ?
@@XEnd          dd ?
@@OneOverZ      dd ?
@@UOverZ        dd ?
@@VOverZ        dd ?
@@Intens        dd ?
@@U             dd ?
@@V             dd ?
@@I             dd ?

@@dUdX          dd ?
@@dVdX          dd ?
@@Len           dd ?

@@U0            dd ?
@@U1            dd ?
@@V0            dd ?
@@V1            dd ?

@@count16       dd ?

endp

;
;In:
;       esi: polygon
;       scan_dest: destination

align 32
proc    scan_pgl n

        mov     ebx, [esi + polygon.connect1]
        mov     ecx, [esi + polygon.connect2]
        mov     edx, [esi + polygon.connect3]
        add     ebx, [scan_pts]
        add     ecx, [scan_pts]
        add     edx, [scan_pts]

        sort_vertices
        copy_vertices

        gradients

        get_middle
        make_edges

        get_toptomiddle
        topbottom_clip
        mov     edi, [edi*4 + o scr_muls]
        add     edi, [scan_dest]
        dec     edi
        draw_toptomiddle

        get_middletobottom
        draw_middletobottom

done_scan:
        ret

endp

;

align 4
TopToBottom     edge_struc <>
TopToMiddle     edge_struc <>
MiddleToBottom  edge_struc <>

L_X               dd ?
L_XStep           dd ?
L_Y               dd ?
L_Height          dd ?
L_OneOverZ        dd ?
L_OneOverZStep    dd ?
L_UOverZ          dd ?
L_UOverZStep      dd ?
L_VOverZ          dd ?
L_VOverZStep      dd ?
L_Intens          dd ?
L_IntensStep      dd ?

R_X               dd ?
R_XStep           dd ?
R_Y               dd ?
R_Height          dd ?
R_OneOverZ        dd ?
R_OneOverZStep    dd ?
R_UOverZ          dd ?
R_UOverZStep      dd ?
R_VOverZ          dd ?
R_VOverZStep      dd ?
R_Intens          dd ?
R_IntensStep      dd ?

;

ends    code32

;
;

end
