#include "ftypes.h"

// PERIOD TABLE
extern UWORD periodtab[134];  // 11 octave period table.

// PATTERN AND SONG DATA VARIABLES
extern Song FM;               // the song header information
extern char *patbuff[256];    // pattern data pointers
extern SampleHDR *inst[99];   // Instrument pointers
extern Note *current;         // current - a global 'note'
extern char *SongMSG;         // Song text for things like MTM etc

// HARDWARE SPECIFIC VARIABLES
extern UWORD divisor;         // mixing rate, or GUS divisor

// PLAY TIME VARIABLES
extern UBYTE speed, bpm;      // speed, bpm, channels, figure it out.
extern UBYTE patdelay;        // # of notes to delay pattern for in EEx
extern  BYTE row, globalvol;  // current row being played, master volume
extern UBYTE defpan;          // default pan value, L=defpan, R=0x100-defpan
extern  WORD ord;             // current order being played

// INTERFACE VARIABLES
extern UDWORD fclock;          // counter for interface clock, for interface
extern UBYTE pause;           // pause flag
extern UDWORD filelen;         // size of file, for the interface

// CHANNEL SPECIFIC VARIABLES (mainly for LOADER.CPP)
extern  UBYTE     mute[32];   // toggle whether to mute channel or not
extern  BYTE    volume[32];   // current volume of each channel
extern  WORD      freq[32];   // amiga frequency of each channel
extern  WORD    panval[32];   // pan values for each channel
extern  BYTE   lastins[32];   // instrument # for each channel (to remember)
extern  UBYTE  lastnot[32];   // last note set in channel (to remember)
extern  UWORD  lastper[32];   // last period set in channel (to remember)
extern  UBYTE  restart[32];   // flag whether to play sample or not
extern  UDWORD    start[32];   // position in sample to start from

extern  UWORD  soffset[32];   // amount to sample offset by
extern  UBYTE  lastpor[32];   // last porta up or down value (XM + S3M)
extern  UBYTE  lastvsl[32];   // last volume slide value (XM + S3M)

extern  UBYTE  retrigx[32];   // last retrig volume slide used (XM + S3M)
extern  UBYTE  retrigy[32];   // last retrig tick count used (XM + S3M)

extern  WORD     porto[32];   // note to port to value (signed word)
extern  UBYTE   portsp[32];   // porta speed

extern  BYTE    vibpos[32];   // vibrato position
extern  UBYTE   vibspe[32];   // vibrato speed
extern  UBYTE   vibdep[32];   // vibrato depth

extern  BYTE   trempos[32];   // tremolo position
extern  UBYTE  tremspe[32];   // tremolo speed
extern  UBYTE  tremdep[32];   // tremolo depth

extern  UBYTE   tremor[32];   // tremor position (XM + S3M)
extern  UBYTE tremparm[32];   // rememered parameters for tremor

extern  UBYTE patlooprow[32];
extern  UBYTE patloopno[32];  // pattern loop variables for effect  E6x

extern  UBYTE  wavecon[32];   // waveform type for vibrato and tremolo (4bits)
extern  UBYTE  geffect[32];   // effect played at the time (for interface)

// GUS.CPP
extern UWORD Base;			  // Base address of GUS
extern UDWORD gusdram;		  // Amount of GUS DRAM available in bytes

// Function Prototypes

#ifdef __cplusplus
extern "C" {
#endif

// GUS.CPP
	UBYTE GUSPeek(UDWORD);
	void GUSPoke(UDWORD, UBYTE);
	void GUSUpload(UDWORD, char *, UWORD, UBYTE);
	void GUSReset(UBYTE);
	UDWORD GUSFindMem();
	void GUSSetVolume(UBYTE, UBYTE);
	void GUSSetBalance(UBYTE, UBYTE);
	void GUSSetFreq(UBYTE, UWORD);
	void GUSStopVoice(UBYTE);
	void GUSPlayVoice(UBYTE, UBYTE, UDWORD, UDWORD, UDWORD);
//	void GUSRamp(UBYTE, UWORD);

// PLAYER.CPP
	void SetTimerSpeed();
	int FinetoHz(UBYTE);
	void PlayMOD();
	void StopMOD();

// LOADER.CPP
	UBYTE LoadSong(char *, char *, UBYTE);

#ifdef __cplusplus
}
#endif
