;	crithand.asm - Critical error handler
;
;************************************************************************/
;*	Copyright (C) 1986-1993 Phar Lap Software, Inc.			*/
;*	Unpublished - rights reserved under the Copyright Laws of the	*/
;*	United States.  Use, duplication, or disclosure by the 		*/
;*	Government is subject to restrictions as set forth in 		*/
;*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 	*/
;*	Computer Software clause at 252.227-7013.			*/
;*	Phar Lap Software, Inc., 60 Aberdeen Ave., Cambridge, MA 02138	*/
;************************************************************************/

.twocase
include dosx.ah

_TEXT segment public byte use32 'CODE'
_TEXT ends

_DATA segment public dword 'DATA'
;
; valid segment registers
;
DSReg dw	?
ESReg dw	?
FSReg dw	?
GSReg dw	?

;
; addr of C routine to call
;
	align 4

_DATA ends

	assume	cs:_TEXT,ds:nothing
_TEXT segment

;
; void SaveSegRegs()
;
; Save segment registers
;
	assume	cs:_TEXT,ds:_DATA
	public SaveSegRegs,_SaveSegRegs,SaveSegRegs_
_SaveSegRegs label near
SaveSegRegs_ label near
SaveSegRegs proc near
	mov	DSReg,ds
	mov	ESReg,es
	mov	FSReg,fs
	mov	GSReg,gs
	ret
SaveSegRegs endp

;
; void GetSegRegs()
;
; Get segment registers, for use by interrupt handler
;
	assume	cs:_TEXT,ds:_DATA
	public GetSegRegs,_GetSegRegs,GetSegRegs_
_GetSegRegs label near
GetSegRegs_ label near
GetSegRegs proc near
	mov	ds,cs:DSReg
	mov	es,cs:ESReg
	mov	fs,cs:FSReg
	mov	gs,cs:GSReg
	ret
GetSegRegs endp

_TEXT ends

end
