//***************************************************************************
//
// this file is (c) '94-'96 Niklas Beisert
//
// this file is part of the cubic player development kit.
// you may only use/modify/spread this file under the terms stated
// in the cubic player development kit accompanying documentation.
//
//***************************************************************************

#ifndef __STDINST_H
#define __STDINST_H

enum
{
  mpEnvLoop=1, mpEnvBiDi=2, mpEnvSLoop=4, mpEnvSBiDi=8,
};

struct envelope
{
  unsigned char *env;
  unsigned short len;
  unsigned short loops, loope;
  unsigned short sloops, sloope;
  unsigned char type;
  unsigned char speed;
};

struct sample
{
  char name[32];
  unsigned short handle;
  signed short normnote;
  signed short stdvol;
  signed short stdpan;
  unsigned short opt;
#define MP_OFFSETDIV2 1
  unsigned short volfade;
  unsigned char pchint;
  unsigned short volenv;
  unsigned short panenv;
  unsigned short pchenv;
  unsigned char vibspeed;
  unsigned char vibtype;
  unsigned short vibrate;
  unsigned short vibdepth;
  unsigned short vibsweep;
};

struct instrument
{
  char name[32];
  unsigned short samples[128];
};

void gmdInstSetup(const instrument *ins, int nins, const sample *smp, int nsmp, const sampleinfo *smpi, int nsmpi, int type, void (*MarkyBoy)(char *, char *));
void gmdInstClear();

#endif
