//***************************************************************************
//
// this file is (c) '94-'96 Niklas Beisert
//
// this file is part of the cubic player development kit.
// you may only use/modify/spread this file under the terms stated
// in the cubic player development kit accompanying documentation.
//
//***************************************************************************

#ifndef __MP_H
#define __MP_H

#include "gmdinst.h"

#define MP_MAXCHANNELS 32

struct track
{
  unsigned char *ptr;
  unsigned char *end;
};

struct pattern
{
  char name[32];
  unsigned short patlen;
  unsigned short gtrack;
  unsigned short tracks[MP_MAXCHANNELS];
};


#define MOD_TICK0 1
#define MOD_EXPOFREQ 2
#define MOD_S3M 4
#define MOD_GUSVOL 8
#define MOD_EXPOPITCHENV 16
#define MOD_S3M30 32
#define MOD_MODPAN 0x10000

struct module
{
  char name[32];
  char composer[32];
  unsigned long options;
  int channum;
  int instnum;
  int patnum;
  int ordnum;
  int endord;
  int loopord;
  int tracknum;
  int sampnum;
  int modsampnum;
  int envnum;
  instrument *instruments;
  track *tracks;
  envelope *envelopes;
  sampleinfo *samples;
  sample *modsamples;
  pattern *patterns;
  char **message;
  unsigned short *orders;
  void reset();
  void free();
  char allocinstruments();
  char allocsamples();
  char allocmodsamples();
  char alloctracks();
  char allocpatterns();
  char allocenvelopes();
  char allocorders();
  void optimizepatlens();
  void reduceinstruments();
  void reducemessage();
  char reducesamples();
  char loadsamples();
  void removetext();
};

struct globinfo
{
  unsigned char speed;
  unsigned char curtick;
  unsigned char tempo;
  unsigned char currow;
  unsigned short patlen;
  unsigned short curpat;
  unsigned short patnum;
  unsigned char globvol;
  unsigned char globvolslide;
};

struct chaninfo
{
  unsigned char ins;
  unsigned short smp;
  unsigned char note;
  unsigned char vol;
  unsigned char pan;
  unsigned char notehit;
  unsigned char volslide;
  unsigned char pitchslide;
  unsigned char panslide;
  unsigned char volfx;
  unsigned char pitchfx;
  unsigned char notefx;
  unsigned char fx;
};

class binfile;

extern "C"
{
  int mpLoadMOD(module &, binfile &);
  int mpLoadMODt(module &, binfile &);
  int mpLoadMODd(module &, binfile &);
  int mpLoadM15(module &, binfile &);
  int mpLoadM15t(module &, binfile &);
  int mpLoadM31(module &, binfile &);
  int mpLoadWOW(module &, binfile &);
  int mpLoadMTM(module &, binfile &);
  int mpLoadS3M(module &, binfile &);
  int mpLoadXM (module &, binfile &);
  int mpLoad669(module &, binfile &);
  int mpLoadULT(module &, binfile &);
  int mpLoadDMF(module &, binfile &);
  int mpLoadOKT(module &, binfile &);
  int mpLoadPTM(module &, binfile &);
  int mpLoadAMS(module &, binfile &);
  int mpLoadMDL(module &, binfile &);
  int mpLoadIT (module &, binfile &);
}
char mpPlayModule(const module &);
void mpStopModule();
void mpSetPosition(signed short pat, signed short row);
void mpGetPosition(unsigned short &pat, unsigned char &row);
void mpGetChanInfo(unsigned char ch, chaninfo &ci);
unsigned short mpGetRealNote(unsigned char ch);
void mpGetGlobInfo(globinfo &gi);
char mpLooped();
void mpSetLoop(unsigned char s);
void mpLockPat(int st);
int mpGetChanSample(int ch, short *buf, int len, int rate);
void mpMute(int ch, int m);
void mpGetRealVolume(int ch, int &l, int &r);
int mpGetChanStatus(int ch);
int mpGetMute(int ch);

enum
{
  cmdTempo, cmdSpeed, cmdBreak, cmdGoto, cmdPatLoop, cmdPatDelay, cmdGlobVol, cmdGlobVolSlide, cmdSetChan, cmdFineSpeed
};

enum
{
  cmdVolSlideUp, cmdVolSlideDown, cmdRowVolSlideUp, cmdRowVolSlideDown,
  cmdPitchSlideUp, cmdPitchSlideDown, cmdPitchSlideToNote,
  cmdRowPitchSlideUp, cmdRowPitchSlideDown,
  cmdPanSlide, cmdRowPanSlide,
  cmdDelay,
  cmdVolVibrato, cmdVolVibratoSetWave, cmdTremor,
  cmdPitchVibrato, cmdPitchVibratoSetSpeed, cmdPitchVibratoFine,
  cmdPitchVibratoSetWave, cmdArpeggio,
  cmdNoteCut, cmdRetrig,
  cmdOffset,
  cmdPanSurround,
  cmdKeyOff,
  cmdSetEnvPos,

  cmdVolSlideUDMF, cmdVolSlideDDMF,
  cmdPanSlideLDMF, cmdPanSlideRDMF,
  cmdPitchSlideUDMF, cmdPitchSlideDDMF, cmdPitchSlideNDMF, cmdRowPitchSlideDMF,
  cmdVolVibratoSinDMF, cmdVolVibratoTrgDMF, cmdVolVibratoRecDMF,
  cmdPanVibratoSinDMF,
  cmdPitchVibratoSinDMF, cmdPitchVibratoTrgDMF, cmdPitchVibratoRecDMF,

  cmdLeaveLoop,

  cmdPanDepth,
  cmdPanHeight,

  cmdChannelVol,

  cmdSpecial,
  cmdOffsetHigh,

  cmdPlayNote=0x80, cmdPlayIns=0x01, cmdPlayNte=0x02, cmdPlayVol=0x04, cmdPlayPan=0x08, cmdPlayDelay=0x10
};

enum
{
  cmdContVolSlide,
  cmdContRowVolSlide,
  cmdContMixVolSlide,
  cmdContMixVolSlideUp,
  cmdContMixVolSlideDown,
  cmdContMixPitchSlideUp,
  cmdContMixPitchSlideDown,
  cmdGlissOn,
  cmdGlissOff
};

enum
{
  fxGVSUp=1, fxGVSDown,
  fxVSUp=1, fxVSDown, fxVSUDMF, fxVSDDMF,
  fxPSUp=1, fxPSDown, fxPSToNote, fxPSUDMF, fxPSDDMF, fxPSNDMF,
  fxPnSRight=1, fxPnSLeft, fxPnSLDMF, fxPnSRDMF,
  fxVXVibrato=1, fxVXTremor,
  fxPXVibrato=1, fxPXArpeggio,
  fxPnXVibrato=1,
  fxNXNoteCut=1, fxNXRetrig,

  fxVolSlideUp=1, fxVolSlideDown,
  fxRowVolSlideUp, fxRowVolSlideDown,
  fxPitchSlideUp, fxPitchSlideDown, fxPitchSlideToNote,
  fxRowPitchSlideUp, fxRowPitchSlideDown,
  fxPanSlideRight, fxPanSlideLeft,
  fxVolVibrato, fxTremor,
  fxPitchVibrato, fxArpeggio,
  fxNoteCut, fxRetrig,
  fxOffset,
  fxDelay,
  fxPanVibrato
};

#endif
