#ifndef __SAMPLER_H
#define __SAMPLER_H

#define SMP_BIGBUF 4
#define SMP_FULLBUF 8

#define SMP_STEREO 1
#define SMP_16BIT 2
#define SMP_SIGNEDOUT 4
#define SMP_REVERSESTEREO 8

#define SMP_MIC 0
#define SMP_LINEIN 1
#define SMP_CD 2

extern int smpRate;
extern int smpOpt;
extern int smpBufSize;
extern int (*smpSample)(void *buf, int &len);
extern void (*smpStop)();
extern void (*smpSetOptions)(int rate, int opt);
extern void (*smpSetSource)(int src);
extern int (*smpGetBufPos)();

int smpOpenSampler(void *&buf, int &len);
void smpCloseSampler();
void smpGetRealMasterVolume(int &l, int &r);
void smpGetMasterSample(short *s, int len, int rate, int opt);

#endif
