struct envelope;
struct instrument;
struct sample;
struct sampleinfo;

struct xmodule
{
  char name[21];
  int linearfreq;
  int nchan;
  int ninst;
  int nenv;
  int npat;
  int nord;
  int nsamp;
  int nsampi;
  int loopord;
  unsigned char initempo;
  unsigned char inibpm;

  envelope *envelopes;
  sample *samples;
  instrument *instruments;
  sampleinfo *sampleinfos;
  unsigned short *patlens;
  unsigned char (**patterns)[5];
  unsigned short *orders;
};

enum
{
  xmpFXIns=0,
  xmpFXNote=1,
  xmpFXVol=2,
  xmpFXCmd=3,
  xmpFXData=4
};

int xmpLoadModule(xmodule &m, binfile &f);
int xmpLoadMOD(xmodule &m, binfile &f);
void xmpFreeModule(xmodule &m);

int xmpPlayModule(xmodule &m);
void xmpStopModule();
void xmpSetPos(int ord, int row);

void xmpGetRealVolume(int i, int &l, int &r);
void xmpMute(int i, int m);
int xmpGetLChanSample(int ch, short *b, int len, int rate);
unsigned short xmpGetPos();
int xmpGetDotsData(int ch, int &smp, int &frq, int &l, int &r, int &sus);
int xmpLoop();
void xmpSetLoop(int);
int xmpGetChanIns(int);
int xmpGetChanSamp(int);
int xmpChanActive(int);
