//***************************************************************************
//
// this file is (c) '94-'96 Niklas Beisert
//
// this file is part of the cubic player development kit.
// you may only use/modify/spread this file under the terms stated
// in the cubic player development kit accompanying documentation.
//
//***************************************************************************


// fileselector detection example

#include <string.h>
#include <stdlib.h>
#include "pfilesel.h"
#include "binfile.h"

static unsigned char wavGetModuleType(const unsigned char *buf)
{
  if ((*(unsigned long*)buf==0x46464952)&&(*(unsigned long*)(buf+8)==0x45564157))
    return mtWAV;

  return 0xFF;
}


static int wavReadMemInfo(moduleinfostruct &m, const unsigned char *buf, int len)
{
  int type=wavGetModuleType(buf);
  m.modtype=type;
  int i,j;

  switch (type)
  {
  case mtWAV:
  {
    i=20;
    while (i<800)
    {
      if (*(unsigned long*)(buf+i-8)==0x20746D66)
        break;
      i+=8+*(unsigned long*)(buf+i-4);
    }
    if (i>=800)
      return 1;

    char rate[10];
    *m.modname=0;
    ultoa(*(unsigned long*)(buf+i+4), rate, 10);
    for (j=strlen(rate); j<5; j++)
      strcat(m.modname, " ");
    strcat(m.modname, rate);
    if (*(unsigned short*)(buf+i+14)==8)
      strcat(m.modname, "Hz,  8 bit, ");
    else
      strcat(m.modname, "Hz, 16 bit, ");
    if (*(unsigned short*)(buf+i+2)==1)
      strcat(m.modname, "mono");
    else
      strcat(m.modname, "stereo");
    m.channels=*(unsigned short*)(buf+i+2);
    if (*(unsigned long*)(buf+i+16)==61746164)
      m.playtime=*(unsigned long*)(buf+i+20)/ *(unsigned long*)(buf+i+8);
    return 1;
  }
  }
  m.modtype=0xFF;
  return 0;
}

static int wavReadInfo(moduleinfostruct &m, binfile &f, const unsigned char *buf, int len)
{
  return 0;
}

extern "C"
{
  mdbreadnforegstruct wavReadInfoReg = {wavReadMemInfo, wavReadInfo};
};
