{GDM Kit Player V1.0             }
{(!) 1997, RaPHiuS / ANuBiS      }
{henrraph@skynet.be              }
{Http://users.skynet.be/henrraph/}

{Notes : -I am not the creator of the GDM file format. The real author is }
{         Edward Shlunder. I'm just here to show you how to implement the }
{         GDM file format in any of your productions.                     }
{        -Use this GDM Kit at your own risk. I cannot be responsible of   }
{         any damage this GDM Kit could do.                               }
{        -You can use this GDM Kit for any of your productions as long    }
{         your productions are Freeware also please refer to Edward       }
{         Shlunder original license for more informations about GDM So.&Eg}

{If you implement this unit let me know !! Please email me :              }
{                                                 henrraph@skynet.be      }

Unit GdmKit;

Interface

Var
 ModName : String;

Procedure Init_All;
Procedure GDM_Begin_Play;
Procedure GDM_Shut_Down;
Function SynchroMusic(patnum : Byte) : Boolean;

Implementation

Uses Crt, Mse_Tp;

Var
 SoundCardName : String;
 DMA, IRQ : Byte;
 BaseIO : Word;
 SampleRate : Word;
 DMABuffer : Word;
 Handle : File;
 Header : GDMHeader;
 EMSFlag : Word;
 MusicChannels : Word;
 ChannelCount : Word;

{
 Internal Subroutines
}

{Return all errors. If Graphic mode ON, set automatically Text mode again}
{before printing the error on the screen.                                }
Procedure EndProg(ErrorString : String);
Begin
  Asm
   mov ax,03h
   int 10h
  End;
  Writeln;
  Writeln(ErrorString);
  If IOResult <> 0 then Close(Handle);
  Halt(0);
End;

{Get the desired soundcard and apply the driver for it}
Function GetSoundCardName : String;
Begin
  Writeln;
  Writeln(' ------------------');
  Writeln(' Choose Soundcard : ');
  Writeln(' ------------------');
  Writeln;
  Writeln('  1. Gravis Ultrasound');
  Writeln('  2. Sound Blaster 1.0');
  Writeln('  3. Sound Blaster 2.0');
  Writeln('  4. Sound Blaster Pro');
  Writeln('  5. Sound Blaster 16');
  Writeln('  6. Pro Audio Spectrum');
  Case ReadKey of
    '1' : GetSoundCardName := 'GUS.MSE';
    '2' : GetSoundCardName := 'SB1X.MSE';
    '3' : GetSoundCardName := 'SB2X.MSE';
    '4' : GetSoundCardName := 'SBPRO.MSE';
    '5' : GetSoundCardName := 'SB16.MSE';
    '6' : GetSoundCardName := 'PAS.MSE';
  End;
End;

{Get the IRQ number of the soudcard}
Function GetIRQNumber : Byte;
Begin
  Writeln;
  Writeln(' IRQ Number : ');
  Writeln;
  Writeln('  1 : IRQ 2');
  Writeln('  2 : IRQ 3');
  Writeln('  3 : IRQ 5');
  Writeln('  4 : IRQ 7');
  Writeln('  5 : IRQ 11');
  Writeln('  6 : IRQ 12');
  Writeln('  Press a key for Autodetect...');
  Case ReadKey of
    '1' : GetIRQNumber := 2;
    '2' : GetIRQNumber := 3;
    '3' : GetIRQNumber := 5;
    '4' : GetIRQNumber := 7;
    '5' : GetIRQNumber := 11;
    '6' : GetIRQNumber := 12;
    Else GetIRQNumber := $FF;
  End;
End;

{Get the DMA channel of the Soundcard}
Function GetDMAChannel : Byte;
Begin
  Writeln;
  Writeln(' DMA Channel : ');
  Writeln;
  Writeln('  1 : DMA Channel 1');
  Writeln('  2 : DMA Channel 2');
  Writeln('  3 : DMA Channel 3');
  Writeln('  4 : DMA Channel 5');
  Writeln('  Press a key for Autodetect...');
  Case ReadKey of
    '1' : GetDMAChannel := 1;
    '2' : GetDMAChannel := 2;
    '3' : GetDMAChannel := 3;
    '4' : GetDMAChannel := 5;
    Else GetDMAChannel := $FF;
  End;
End;

{Get the IO address for the Soundcard}
Function GetBaseIO : Word;
Begin
  Writeln;
  Writeln(' I/O Address : ');
  Writeln;
  Writeln('  1 : 210h');
  Writeln('  2 : 220h');
  Writeln('  3 : 230h');
  Writeln('  4 : 240h');
  Writeln('  5 : 250h');
  Writeln('  6 : 260h');
  Writeln('  Press a key for Autodetect...');
  Case ReadKey of
    '1' : GetBaseIO := $210;
    '2' : GetBaseIO := $220;
    '3' : GetBaseIO := $230;
    '4' : GetBaseIO := $240;
    '5' : GetBaseIO := $250;
    '6' : GetBaseIO := $260;
    Else GetBaseIO := $FFFF;
  End;
End;

{
 Public GDMKit Routines
}

Procedure Init_All;
Begin
 SoundCardName := GetSoundCardName;
 BaseIO := GetBaseIO;
 IRQ := GetIRQNumber;
 DMA := GetDMAChannel;
 SampleRate := 45;
 DMABuffer := 4096;
 Case LoadMSE(SoundCardName, 0, SampleRate, DMABuffer, BaseIO, IRQ, DMA) of
  1 : EndProg('Base I/O address autodetection failure');
  2 : EndProg('IRQ level autodetection failure');
  3 : EndProg('DMA channel autodetection failure');
  4 : EndProg('DMA channel not supported');
  6 : EndProg('Sound device does not respond');
  7 : EndProg('Memory control blocks destroyed');
  8 : EndProg('Insufficient memory for mixing buffers');
  9 : EndProg('Insufficient memory for MSE file');
  10: EndProg('MSE has invalid identification string');
  11: EndProg('MSE disk read failure');
  12: EndProg('MVSOUND.SYS not loaded');
 End;
  ExitProc := @FreeMSE;
  If EMSExist
    Then EMSFlag := 1
    Else EMSFlag := 0;
{$I-}
  Assign(Handle, Modname);
  Reset(Handle);
{$I+}
  If IOResult <> 0 Then
     EndProg('Module does not exist');
  Case LoadGDM(Handle, 0, EMSFlag, Header) of
    1 : EndProg('Module is corrupt');
    2 : EndProg('Could not autodetect module type (N/A)');
    3 : EndProg('Bad file format ID string');
    4 : EndProg('Insufficient memory to load module');
    5 : EndProg('Can not unpack samples');
    6 : EndProg('AdLib instruments not supported');
  End;
  Close(Handle);
  MusicChannels := 0;
  For ChannelCount := 1 to 32 do
    Begin
      If Header.PanMap[ChannelCount] <> $FF
        Then MusicChannels := MusicChannels + 1;
    End;
  SampleRate := StartOutput(MusicChannels, 0);
End;

Procedure GDM_Begin_Play;
Begin
 StartMusic;
End;

Procedure GDM_Shut_Down;
Begin
 StopMusic;
 StopOutput;
 UnloadModule;
 FreeMse;
End;

{Synchro the video with the sound. Cannot use with peoples who don't have a}
{soundcard coz it's synchronize with the music pattern being played !      }
{This procedure is from me ;)                                              }
Function SynchroMusic(patnum : Byte) : Boolean;
Begin
 if musicpattern($FF) <> patnum then begin
  synchromusic := false;
  end
 else
  synchromusic := true;
End;

End.
