/******************************************************/
/* Asks the user about his sounddevice and replayrate */
/* input        : XXX                                 */
/* output       : XXX                                 */
/******************************************************/
void	far	askinit (void);

/***********************************/
/* Initializes the playing-routine */
/* input        : XXX              */
/* output       : XXX              */
/***********************************/
void	far	initialize (void);

/********************************/
/* Loads a modules into memory  */
/* input        : Module Name   */
/* output       : XXX           */
/********************************/
void	far	loadmodule (char mfile[]);

/**********************/
/* Starts the music   */
/* input	: XXX */
/* output	: XXX */
/**********************/
void	far	startplaying (void);

/**********************/
/* Stops the music    */
/* input	: XXX */
/* output	: XXX */
/**********************/
void	far	stopplaying (void);

/**********************/
/* Deallocates memory */
/* input	: XXX */
/* output	: XXX */
/**********************/
void	far	dealloc (void);

/*********************************************/
/* Loads the playing-routine into memory     */
/* input        : string/pointer to filename */
/* output       : XXX                        */
/*********************************************/
void	far	loadovl (char fnamn[]);

/**********************************/
/* Removes the playing-routine    */
/* input	: XXX		  */
/* output	: XXX		  */
/**********************************/
void	far	removeovl (void);

/*****************************************/
/* Sets the master-volume                */
/* input        : word = new volume      */
/* output	. XXX			 */
/*****************************************/
void	far	mastervolume (unsigned int mastvol);

/*****************************************************************/
/* Returns the fake-VU-meter-value for given channel.            */
/* input        : word = Channel (0-3) to be tested              */
/* output       : word = Value of "VU"-Meter. (0-64)             */
/*****************************************************************/
unsigned int far	bopbar (unsigned int barno);

/********************************************************************/
/* Lets the programmer configure the player without using 'askinit' */
/* input        : word = device, speed. SB dma, SB port, SB port    */
/* output       : XXX                                               */
/********************************************************************/
void	far	setsys (unsigned int sdev,
			unsigned int tspeed,
			unsigned int sbdma,
			unsigned int sbirq,
			unsigned int sbport);
