; DS:SI  -- String to search for
; ES:DI  -- Place to put
; CX     -- Maximum size to copy
; AX     -- PspAddress

proc            sl_EnvString near
                cld                             ;work upward
                push    es di cx
                mov     es, ax
                mov     es,[es:2Ch]             ;ES:DI points at environment
                xor     di,di                   ;which is paragraph-aligned
                lodsb                           ;look at length
                or      al,al                   ;is it zero?
                je      @@RetNul                ;if so, return
                mov     ah,al                   ;otherwise, save in AH
                mov     dx,si                   ;DS:DX contains pointer to first parm char
                xor     al,al                   ;make a zero
@@Compare:      mov     ch,al                   ;we want ch=0 for next count, if any
                mov     si,dx                   ;get back pointer to string sought
                mov     cl,ah                   ;get length
                mov     si,dx                   ;get pointer to string sought
                repe    cmpsb                   ;compare bytes
                jne     @@Skip                  ;if compare fails, try next string
                cmp     [Byte es:di],'='        ;compare succeeded. Is next char '='?
                jne     @@NoEqual               ;if not, still no match
@@Found:        mov     ax,es                   ;make DS:SI point to string we found
                mov     ds,ax
                mov     si,di
                inc     si                      ;get past the equal (=) sign
                pop     cx bx es
                mov     di,bx                   ;put it in ES:DI
CopyLoop:       lodsb                           ;get a byte
                or      al,al                   ;zero test
                je      @@Done                    ;if zero, we're done
                stosb                           ;put it in the result
                loop    CopyLoop                ;move up to 255 bytes
@@Done:         not     cl                      ;we've been decrementing CL from
                                                ; 255 during save
                mov     al,0
                stosb
                ret
@@Skip:         dec     di                      ;check for null from this char on
@@NoEqual:      mov     cx,7FFFh                ;search a long way if necessary
                sub     cx,di                   ;environment never >32K
                jbe     @@RetNul                ;if we're past end, leave
                repne   scasb                   ;look for the next null
                jcxz    @@RetNul                ;exit if not found
                cmp     [Byte es:di],al         ;second null in a row?
                jne     @@Compare               ;if not, try again
@@RetNul:       pop     cx di es
                stosb                           ;store a zero there
                ret
endp            sl_EnvString

GUSPort 	dw	2
GUSIRQ		dw	5
GUSMIDI 	dw	3
DMAIn		dw	1
DMAOut		dw	1
TerminateFlag	dw	1
GUSIRQList      db      0,2,3,5,7,11,12,15

proc		SetEnv
		mov	cx,80
                mov     ax,MyData
                mov     ds,ax
                mov     es,ax
                mov     ax,[cs:PspAddress]
                mov     si,offset GEnv
                mov     di,offset GDirectory
                call    sl_EnvString
                mov     ax,MyData
                mov     ds,ax
                mov     es,ax
                mov     di,offset GDirectory
                cmp     [Byte di],0
                je      @@NoEnvironment
                mov     cx,80
@@LookLoop:     cmp     [Byte di],0
                je      @@FoundIt
                inc     di
                loop    @@LookLoop
@@FoundIt:      cmp     [Byte di-01h],'\'
		je	@@OKEn
                mov     [Byte di],'\'
                mov     [Byte di+01h],0
                inc     di
@@OKEn: 	mov	[PutFilename],di
                jmp     @@OKEnv
@@NoEnvironment:
                mov     dx,offset NoEnvFound
                call    Error
@@OKEnv:	ret
endp            SetEnv
