;				GTSR v1.10
;	     By Joshua C. Jensen (CyberStrike of Renaissance)
;			 Copyright (C) 1992,1993
;

ideal
P286
model	Huge
jumps

stack	1024

include "gusmod.inc"

segment MyCode

		assume	cs:MyCode,ds:MyData

MMus		SMus	<>
P               PM      <>
MusBuf		dw	0
Music           dw      0,BlankMusicSeg
Mode		db	0		; 0 - Text
					; 1 - Graphics
PanPos		db	3,12,12,3
MaxVol		db	100
ChanVol 	db	100,100,100,100
PlayStat	db	0

ConfigFile	db	'GTSR.INF',0
GConfigFile	db	'GSETUP.CFG',0

include         "sd.asm"
include 	"env.asm"
include 	"cmdline.asm"
include 	"modload.asm"

proc		GetInfo near
                mov     bx,9
                mov     cx,1
                mov     si,seg MMus
                mov     di,offset MMus
                call    [dword cs:Music]
                ret
endp            GetInfo

proc            SetInfo near
                mov     bx,0Ah
                mov     si,seg MMus
                mov     di,offset MMus
                call    [dword cs:Music]
                ret
endp            SetInfo

proc		Terminate far
		mov	bx,5
		call	[dword ptr cs:Music]
		mov	bx,1		; Close down player.
		call	[dword ptr cs:Music]
		ret
endp            Terminate

proc		Error near
                mov     ax,MyData
		mov	ds,ax
		mov	ah,9
                int     21h
		call	Terminate
		mov	ax,4C00h
		int	21h
endp            Error

; si - Filename offset
proc            PutName
		push	ds es
		mov	ax,MyData
                mov     es,ax
		mov	di,[es:PutFilename]
		mov	ax,cs
                mov     ds,ax
                mov     cx,12
		rep	movsb
		mov	al,0
		stosb
		pop	es ds
		ret
endp            PutName

proc		ReadGConfig
		push	ds
		mov	ax,MyData
		mov	ds,ax
		mov	si,offset GConfigFile
		call	PutName
		mov	dx,offset GDirectory
                mov     cx,seg GDirectory
		mov	ds,cx
		mov	ax,3D00h
		int	21h
		jb	@@NoFind
		mov	bx,ax
		mov	cx,11
		mov	ax,cs
		mov	ds,ax
		mov	dx,offset GUSPort
		mov	ah,3Fh
                int     21h
		mov	ah,3Eh
                int     21h
		pop	ds
		ret
@@NoFind:	mov	dx,offset NoGCFound
		call	Error
		pop	ds
		ret
endp		ReadGConfig

proc            ReadConfig
		push	ds
		mov	ax,MyData
		mov	ds,ax
		mov	si,offset ConfigFile
		call	PutName
		mov	dx,offset GDirectory
                mov     cx,seg GDirectory
		mov	ds,cx
		mov	ax,3D00h
		int	21h
		jb	@@SetInfo
		mov	bx,ax
		mov	cx,11
		mov	ax,cs
		mov	ds,ax
		mov	dx,offset Mode
		mov	ah,3Fh
                int     21h
		mov	ah,3Eh
                int     21h
@@SetInfo:	call	GetInfo
		mov	al,[cs:MaxVol]
                mov     [cs:offset MMus+(offset (SMus).MaxVolume)],al
		mov	al,[cs:PlayStat]
		mov	[cs:offset MMus+(offset (SMus).PlayStatus)],al
@@Setit:        mov     cx,00000011b
		call	SetInfo
                cli
		les	di,[cs:offset MMus+(offset (SMus).ChannelLoc)]
		mov	bx,0
@@CopyLoop:	mov	al,[cs:bx+PanPos]
		mov	[es:di+MS.sc_PanPosition],al
		mov	al,[cs:bx+ChanVol]
		mov	[es:di+MS.MasterVolume],al
		add	di,size MS
		inc	bx
		cmp	bx,4
		jnz	@@CopyLoop
		sti
@@NoFind:       pop     ds
		ret
endp            ReadConfig

proc            InstallProg
		push	ds
		mov	ax,GUSSeg
		mov	es,ax
		xor	di,di
		mov	ax,0000h
		mov	ds,ax
		mov	si,80*4
		add	di,uOldInt
		cli
		mov	bx,[ds:si]
		mov	cx,[ds:si+2]
		mov	[es:di],bx
		mov	[es:di+2],cx
		sti
		sub	di,uOldInt
		add	di,uTerm
		mov	bx,offset Terminate
		mov	cx,cs
		mov	[es:di],bx
                mov     [es:di+2],cx
		sub	di,uTerm
		add	di,uPsp
		mov	bx,[cs:PspAddress]
		mov	[es:di],bx
		mov	bx,0
		mov	cx,GUSSeg
		cli
		mov	[ds:si],bx
		mov	[ds:si+2],cx
		sti
		mov	ds,[cs:PspAddress]
		mov	bx,2Ch
		mov	es,[bx]
		mov	ah,49h
                int     21h
                pop     ds
		ret
endp            InstallProg

proc            DetectOld
		mov	ax,0000h
		mov	es,ax
		mov	di,80*4
		cli
		mov	ax,[es:di]
		mov	es,[es:di+2]
		mov	di,ax
		sti
		add	di,uDetect
		cmp	[Word es:di],'TG'
		jnz	@@NotThere
		cmp	[Word es:di+2],'RS'
		jnz	@@NotThere
		sub	di,uDetect
		add	di,uTerm
		push	ds es di
                call    [dword ptr es:di]       ; Call the terminate function.
		pop	di es ds
                mov     ah,49h                  ; Should have cleared it.
		mov	es,[Word es:di+4]
		int	21h
		sub	di,uTerm
		add	di,uOldInt
		mov	bx,[es:di]
		mov	cx,[es:di+2]
		mov	ax,0000h
		mov	es,ax
		mov	di,80*4
		cli
		mov	[es:di],bx
		mov	[es:di+2],cx
                sti
@@NotThere:	ret
endp            DetectOld

assume          ds:MyData

PspAddress	dw	?
SizeOfProg      dw      ?
TopOfData	dw	?

proc		Main
Start:          mov     [cs:PspAddress],es
                mov     ax,zzzzzseg
                inc     ax
                mov     [cs:TopOfData],ax
;		 mov	 [cs:PspAddress],es
;		 mov	 ax,es
;		 mov	 bx,zzzzzseg
;		 sub	 bx,ax
;		 add	 bx,2
;		 mov	 [cs:SizeOfProg],bx
;		 mov	 ah, 4ah
;		 int	 21h

		mov	ax,MyData
		mov	ds,ax
		mov	ah,9
		mov	dx,offset GTSRTitle
                int     21h

		call	DetectOld
		call	SetEnv
@@LoadDriver:	mov	si,offset SoundFile
		call	PutName
		mov	dx,offset GDirectory
		mov	cx,seg GDirectory
                call    LoadSoundDriver
		jnb	@@DriverLoaded
		mov	dx,offset NoDriverFound
                call    Error
@@DriverLoaded: call	ReadGConfig
		mov	ax,[cs:GUSIRQ]
                mov     bx,0
		mov	cx,[cs:GUSMIDI]
		mov	dx,[cs:GUSPort]
		mov	si,[cs:DMAIn]
                mov     di,[cs:DMAOut]
                call    [dword ptr cs:Music]
                jnb     @@FoundCard
		mov	dx,offset NoGUS
		call	Error
@@FoundCard:	mov	[cs:GUSIRQ],si
                mov     [cs:GUSPort],di
		call	LoadCommandLine
		jnb	@@ThereWasOne
		mov	dx,offset UninstalledMsg
		call	Error

@@ThereWasOne:	mov	ax,[cs:TopOfData]
		mov	[cs:MusBuf],ax
                add     [Word cs:TopOfData],4096/16
                ; Load the module.
		mov	cx,ds
		mov	dx,130
		call	MUS_LoadModule
                jb      @@nofile
		jmp	@@BeginPlay

@@noargv:	mov	dx,offset NoFileName
		call	Error
@@nofile:	mov	dx,offset NoFileFound
		call	Error
@@BeginPlay:	mov	si,offset ConfigFile
		call	ReadConfig

		mov	[Word cs:offset P+(offset (PM).MusBuf)],0
		mov	ax,[cs:MusBuf]
                mov     [Word cs:offset P+(offset (PM).MusBuf)+2],ax
		mov	[Word cs:offset P+(offset (PM).Header)],offset PS16Header
		mov	[Word cs:offset P+(offset (PM).Header)+2],cs
		mov	[Word cs:offset P+(offset (PM).PatternLoc)],offset PatternLoc
		mov	[Word cs:offset P+(offset (PM).PatternLoc)+2],cs
		mov	[Word cs:offset P+(offset (PM).InsLoc)],offset InsLoc
		mov	[Word cs:offset P+(offset (PM).InsLoc)+2],cs
		mov	[Word cs:offset P+(offset (PM).mt_speed)],6
		mov	[Word cs:offset P+(offset (PM).mt_counter)],5
		mov	[Word cs:offset P+(offset (PM).mt_PatternPos)],0
                mov     [Word cs:offset P+(offset (PM).mt_SongPos)],0
		mov	cx,cs
		mov	si,offset P
		mov	bx,4
                call    [dword cs:Music]

@@Exit: 	call	InstallProg
		mov	ax,[cs:PspAddress]
		mov	es,ax
		mov	dx,[cs:TopOfData]
		sub	dx,ax
		add	dx,2
		mov	ah,31h
		int	21h
endp		Main

ends		MyCode

segment 	GUSSeg
GStart		= $
		jmp	[dword cs:OldInt]
uDetect 	= $-GStart
GUSDetect       db      'GTSR'
uOldInt 	= $-GStart
OldInt          dd      0
uTerm		= $-GStart
TerminateProc   dd      0
uPsp		= $-GStart
PspAddr 	dw	0
ends            GUSSeg

segment 	BlankMusicSeg
		stc
		retf
ends		BlankMusicSeg

segment MyData
GTSRTitle	db	'GTSR v1.11 By Joshua C. Jensen (CyberStrike of Renaissance)',13,10,'$'
NoGUS           db      '1: Could not detect a Gravis UltraSound card.',13,10,'$'
NoFileName      db      '2: Usage: GTSR filename<.mod>',13,10,'$'
NoFileFound     db      '3: Module not found.',13,10,'$'
NoGCFound	db	'4: GSETUP.CFG not found.  Run SETUP.',13,10,'$'
NoEnvFound      db      '5: The environment variable GUSMOD was not found.',13,10,'$'
IllegalEnv      db      '6: Illegal environment variable.',13,10,'$'
NoDriverFound   db      '7: Sound driver not found.',13,10,'$'
UninstalledMsg  db      'Uninstalled from memory.',13,10,'$'

GDirectory	db	120 dup (0)
GEnv		db	6,"GUSMOD"
PutFilename	dw	0
ends	MyData

segment zzzzzseg
	db	16 dup (?)
ends	zzzzzseg

        end     Start

