Unit MXMPTMT;

     -------------------------------------------------------
     -- Pascal's tiny MXM GUS Player. Unit for TMT Pascal --
     --   (Re)written by K!O (Konrad Olejnik) (c) 1997    --
     -- First module for TMT (ver. 0.31) pascal was      --
     -- written by __tim/fiction.h (Tamas Banka) but his  --
     -- unit didn't work with ver. 1.01 of TMT. I give    --
     -- him credit anyway, because he was the first.      --
     --                                                   --
     -- Some info:                                        --
     -------------                                        --
     -- To compile this unit,                             --
     -- You need mxmplay.obj file from mxm16.zip pack     --
     -- released by Niklas Beisert (Pascal).              --
     -- You can find it at Hornet Archive.                --
     --                                                   --
     -- You don't have to change ANYTHING in main player  --
     -- file called mxmplay.asm. I set DOS32CODE=0 only,  --
     -- because I know that my player doesn't run under   --
     -- this extender. I HAVEN'T to set flat model of mem --
     -- however it works too (eg: .model flat,pascal), but--
     -- increase size of *.obj file.                      --
     --                                                   --
     -- Copyrights:                                       --
     --------------                                       --
     -- Cubic Tiny GUS Player is written by Niklas Beisert--
     -- (Pascal) and he is the owner of all copyrights to --
     -- this product. Please read mxmplay.doc file for    --
     -- more information.                                 --
     -------------------------------------------------------

INTERFACE

function xmpInit( module, mxmdata, gusport, maxtimerrate : dword ) : dword;
procedure xmpPlay( startord : dword );
procedure xmpStop;
procedure xmpSetVolume( vol : byte );
function xmpGetSync : byte;
function xmpGetPos : word;
function xmpGetTimer : dword;
function xmpGetGusPort : dword;

IMPLEMENTATION

{$L mxmplay.obj}

procedure xmpinit_; external;
procedure xmpplay_; external;
procedure xmpstop_; external;
procedure xmpsetvolume_; external;
procedure xmpgetsync_; external;
procedure xmpgetpos_; external;
procedure xmpgettimer_; external;
procedure xmpgetgusport_; external;
procedure xmpgetenvptrdpmi_; external;

function xmpInit( module, mxmdata, gusport, maxtimerrate : dword ) : dword; assembler;
asm
   mov  ESI, [module]         -- offset for memory with song module
   mov  EAX, [gusport]        -- gus port or 0 for no sound
   mov  EBX, [mxmdata]        -- 16k buffer for internal use
   mov  ECX, [maxtimerrate]   -- max. timer rate between two IRQ 0 calls
   mov  EDX, 0                -- 0: DPMI, 1:DOS, 2:EOS
  call  xmpinit_
   mov  result, EAX           -- 1: ok., 0: failed.
end;

procedure xmpPlay( startord : dword ); assembler;
asm
   mov  EAX, [startord]
  call  xmpplay_
end;

procedure xmpStop; assembler;
asm
  call  xmpstop_
end;

procedure xmpSetVolume( vol : byte ); assembler;
asm
   mov  AL, [vol]
  call  xmpsetvolume_
end;

function xmpGetSync : byte; assembler;
asm
  call  xmpgetsync_
   mov  result, AL
end;

function xmpGetPos : word; assembler;
asm
  call  xmpgetpos_
   mov  result, AX
end;

function xmpGetTimer : dword; assembler;
asm
  call  xmpgettimer_
   mov  result, EAX
end;

function xmpGetGusPort : dword; assembler;
asm
   mov  EDI, _environ
  call  xmpgetgusport_
   mov  result, EAX
end;

END.