{$R-}
Program TMTPlay; Uses CRT, MXMPTMT;
 -----------------------------------------------------------------
 --- This is simple example how to use Cubic Tiny GUS MXM      ---
 --- Player with TMT (ver. 1.01) Pascal. It works under Tran's ---
 --- PMODE extender. Example is written by K!O (Konrad Olejnik)---
 ---                                                           ---
 --- BIG thanks must fly to Pascal (Niklas Beisert) who is the ---
 --- author and owner of all rights to this great (sorry, not  ---
 --- great, TINY! :-)) GUS player                              ---
 ---                                                           ---
 --- 23.08.1997                                  K!O           ---
 --- e-mail: kolejnik@ck-sg.p.lodz.pl                          ---
 -----------------------------------------------------------------
var
    SongModule : array[ 0..700000 ] of byte;  -- memory for song module
        Buffer : array[ 0..16384 ] of byte;  -- 16k buffer for internal use
BufMem, BufScr : array[ 0..64000 ] of byte;  -- screen buffers
        paleta : array[ 1..768 ] of byte;    -- palette buffer
      PhongBuf : array[ 0..4095 ] of byte;
     GusDevice,
          i, j : word;
      loudness : byte;
           cnt : ShortInt;
   sign, Fsize,
         phong,
SngAdr, BufAdr,
VirMem, VirScr : Dword;
          plik : file;     -- "plik" in Polish = "file" in English   :-)
            ch : char;
          name : string;
const
         sfont : array[ 0..1519 ] of byte =
 ---------------------------------------------
 -- bold font. Sorry for this BIG shit, but --
 -- I want to keep whole player in one file --
 ---------------------------------------------
( $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1C,$1C,$1C,
  $1C,$1C,$1C,$1C,$1C,$00,$00,$1C,$1C,$00,$00,$00,$00,$E7,$E7,$66,$24,$00,$00,
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$E7,$E7,$E7,$FF,$FF,$66,$66,$FF,$FF,
  $E7,$E7,$E7,$00,$00,$00,$00,$00,$0C,$7F,$CC,$CC,$CC,$7E,$33,$33,$33,$FE,$30,
  $00,$00,$00,$00,$60,$F1,$F3,$67,$0E,$1C,$38,$70,$E6,$CF,$8F,$06,$00,$00,$00,
  $00,$00,$70,$D8,$D8,$D8,$70,$70,$D9,$CF,$C6,$6F,$39,$00,$00,$00,$00,$1C,$1C,
  $1C,$38,$30,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1E,$3C,$78,$F0,$E0,
  $E0,$E0,$E0,$F0,$78,$3C,$1E,$00,$00,$00,$00,$78,$3C,$1E,$0F,$07,$07,$07,$07,
  $0F,$1E,$3C,$78,$00,$00,$00,$00,$00,$00,$BA,$FE,$7C,$FE,$FE,$7C,$FE,$BA,$00,
  $00,$00,$00,$00,$00,$00,$00,$1C,$1C,$1C,$7F,$7F,$1C,$1C,$1C,$00,$00,$00,$00,
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$1C,$1C,$1C,$38,$30,$00,$00,$00,
  $00,$00,$00,$00,$7F,$7F,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
  $00,$00,$00,$00,$00,$1C,$1C,$1C,$00,$00,$00,$00,$00,$01,$03,$07,$0E,$1C,$38,
  $70,$E0,$C0,$80,$00,$00,$00,$00,$00,$3C,$7E,$E7,$E7,$E7,$EF,$FF,$F7,$E7,$E7,
  $7E,$3C,$00,$00,$00,$00,$1C,$3C,$7C,$1C,$1C,$1C,$1C,$1C,$1C,$7F,$7F,$7F,$00,
  $00,$00,$00,$FE,$FF,$07,$07,$07,$7F,$FE,$E0,$E0,$E0,$FF,$7F,$00,$00,$00,$00,
  $FE,$FF,$07,$07,$07,$7F,$7F,$07,$07,$07,$FF,$FE,$00,$00,$00,$00,$07,$0E,$1C,
  $38,$70,$E7,$E7,$FF,$FF,$07,$07,$07,$00,$00,$00,$00,$7F,$FF,$E0,$E0,$E0,$FE,
  $7F,$07,$07,$07,$FF,$FE,$00,$00,$00,$00,$7E,$FE,$E0,$E0,$FE,$FF,$E7,$E7,$E7,
  $E7,$FF,$7E,$00,$00,$00,$00,$FE,$FF,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,
  $00,$00,$00,$00,$7E,$FF,$E7,$E7,$E7,$FF,$FF,$E7,$E7,$E7,$FF,$7E,$00,$00,$00,
  $00,$7E,$FF,$E7,$E7,$E7,$FF,$7F,$07,$07,$07,$07,$07,$00,$00,$00,$00,$00,$00,
  $00,$00,$1C,$1C,$1C,$00,$00,$1C,$1C,$1C,$00,$00,$00,$00,$00,$00,$00,$00,$1C,
  $1C,$1C,$00,$00,$1C,$1C,$1C,$38,$30,$00,$00,$07,$0E,$1C,$38,$70,$E0,$E0,$70,
  $38,$1C,$0E,$07,$00,$00,$00,$00,$00,$00,$00,$FE,$FE,$00,$00,$FE,$FE,$00,$00,
  $00,$00,$00,$00,$00,$E0,$70,$38,$1C,$0E,$07,$07,$0E,$1C,$38,$70,$E0,$00,$00,
  $00,$00,$7E,$FF,$E7,$07,$07,$0E,$1C,$1C,$00,$00,$1C,$1C,$00,$00,$00,$00,$3E,
  $7E,$E7,$E7,$E7,$EF,$EF,$EF,$E0,$E0,$7F,$3F,$00,$00,$00,$00,$3C,$7E,$E7,$E7,
  $E7,$FF,$FF,$E7,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$FE,$FF,$E7,$E7,$EF,$FE,$FF,
  $E7,$E7,$E7,$FF,$FE,$00,$00,$00,$00,$3C,$7E,$E7,$E7,$E0,$E0,$E0,$E0,$E7,$E7,
  $7E,$3C,$00,$00,$00,$00,$FC,$FE,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$FE,$FC,$00,
  $00,$00,$00,$FF,$FF,$E0,$E0,$E0,$FC,$FC,$E0,$E0,$E0,$FF,$FF,$00,$00,$00,$00,
  $FF,$FF,$E0,$E0,$E0,$FC,$FC,$E0,$E0,$E0,$E0,$E0,$00,$00,$00,$00,$3C,$7E,$E7,
  $E7,$E0,$EF,$EF,$E7,$E7,$E7,$7E,$3C,$00,$00,$00,$00,$E7,$E7,$E7,$E7,$E7,$FF,
  $FF,$E7,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$3E,$3E,$1C,$1C,$1C,$1C,$1C,$1C,$1C,
  $1C,$3E,$3E,$00,$00,$00,$00,$0F,$0F,$07,$07,$07,$07,$07,$07,$E7,$E7,$7E,$3C,
  $00,$00,$00,$00,$E7,$E7,$EE,$FC,$F8,$F0,$F8,$FC,$FE,$EF,$E7,$E7,$00,$00,$00,
  $00,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0,$FF,$FF,$00,$00,$00,$00,$C3,$E7,
  $FF,$FF,$FF,$FF,$E7,$E7,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$C7,$E7,$F7,$FF,$FF,
  $EF,$E7,$E7,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$3C,$7E,$E7,$E7,$E7,$E7,$E7,$E7,
  $E7,$E7,$7E,$3C,$00,$00,$00,$00,$FE,$FF,$E7,$E7,$E7,$FF,$FE,$E0,$E0,$E0,$E0,
  $E0,$00,$00,$00,$00,$3C,$7E,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$7E,$3F,$07,$03,
  $00,$00,$FE,$FF,$E7,$E7,$E7,$FE,$FE,$EF,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$7E,
  $FF,$E7,$E7,$E0,$FE,$7F,$07,$E7,$E7,$FF,$7E,$00,$00,$00,$00,$FE,$FE,$38,$38,
  $38,$38,$38,$38,$38,$38,$38,$38,$00,$00,$00,$00,$E7,$E7,$E7,$E7,$E7,$E7,$E7,
  $E7,$E7,$E7,$FF,$7E,$00,$00,$00,$00,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$E7,$7E,
  $3C,$18,$00,$00,$00,$00,$E7,$E7,$E7,$E7,$E7,$E7,$FF,$FF,$FF,$FF,$66,$66,$00,
  $00,$00,$00,$E7,$E7,$E7,$E7,$7E,$3C,$3C,$7E,$E7,$E7,$E7,$E7,$00,$00,$00,$00,
  $EE,$EE,$EE,$EE,$FE,$FE,$7C,$38,$38,$38,$38,$38,$00,$00,$00,$00,$FF,$FF,$07,
  $07,$0E,$1C,$38,$70,$E0,$E0,$FF,$FF,$00,$00,$00,$00,$7E,$7E,$70,$70,$70,$70,
  $70,$70,$70,$70,$7E,$7E,$00,$00,$00,$00,$00,$80,$C0,$E0,$70,$38,$1C,$0E,$07,
  $03,$01,$00,$00,$00,$00,$00,$7E,$7E,$0E,$0E,$0E,$0E,$0E,$0E,$0E,$0E,$7E,$7E,
  $00,$00,$00,$00,$18,$3C,$7E,$E7,$C3,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$FF,$00,$00,$00,$00,$38,$38,
  $38,$1C,$0C,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$7C,
  $7E,$0E,$7E,$FE,$EE,$FF,$7F,$00,$00,$00,$00,$E0,$E0,$E0,$E0,$FE,$FF,$E7,$E7,
  $E7,$E7,$FF,$FE,$00,$00,$00,$00,$00,$00,$00,$00,$3E,$7F,$E7,$E0,$E0,$E7,$7F,
  $3E,$00,$00,$00,$00,$07,$07,$07,$07,$7F,$FF,$E7,$E7,$E7,$E7,$FF,$7F,$00,$00,
  $00,$00,$00,$00,$00,$00,$3C,$7E,$E7,$FF,$FF,$E0,$7E,$3E,$00,$00,$00,$00,$3E,
  $7F,$77,$70,$FE,$FE,$70,$70,$70,$70,$70,$70,$00,$00,$00,$00,$00,$00,$00,$00,
  $3C,$7E,$E7,$E7,$E7,$7F,$3F,$07,$7E,$7C,$00,$00,$E0,$E0,$E0,$E0,$FE,$FF,$E7,
  $E7,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$00,$38,$38,$00,$78,$78,$38,$38,$38,$38,
  $7C,$7C,$00,$00,$00,$00,$00,$07,$07,$00,$0F,$0F,$07,$07,$07,$07,$07,$E7,$FF,
  $7E,$00,$00,$E0,$E0,$E0,$E3,$E7,$EF,$FE,$FC,$EE,$E7,$E7,$E7,$00,$00,$00,$00,
  $78,$78,$38,$38,$38,$38,$38,$38,$38,$38,$7C,$7C,$00,$00,$00,$00,$00,$00,$00,
  $00,$EE,$FF,$FF,$DB,$DB,$DB,$DB,$DB,$00,$00,$00,$00,$00,$00,$00,$00,$FC,$FE,
  $E7,$E7,$E7,$E7,$E7,$E7,$00,$00,$00,$00,$00,$00,$00,$00,$3C,$7E,$E7,$E7,$E7,
  $E7,$7E,$3C,$00,$00,$00,$00,$00,$00,$00,$00,$FC,$FE,$E7,$E7,$E7,$FE,$FC,$E0,
  $E0,$E0,$00,$00,$00,$00,$00,$00,$3F,$7F,$E7,$E7,$E7,$7F,$3F,$07,$07,$07,$00,
  $00,$00,$00,$00,$00,$FE,$FF,$E7,$E0,$E0,$E0,$E0,$E0,$00,$00,$00,$00,$00,$00,
  $00,$00,$7F,$FF,$E0,$FE,$7F,$07,$FF,$FE,$00,$00,$00,$00,$00,$38,$38,$38,$FE,
  $FE,$38,$38,$38,$38,$3F,$1F,$00,$00,$00,$00,$00,$00,$00,$00,$E7,$E7,$E7,$E7,
  $E7,$E7,$7F,$3F,$00,$00,$00,$00,$00,$00,$00,$00,$E7,$E7,$E7,$E7,$E7,$7E,$3C,
  $18,$00,$00,$00,$00,$00,$00,$00,$00,$C3,$C3,$DB,$DB,$FF,$FF,$E7,$C3,$00,$00,
  $00,$00,$00,$00,$00,$00,$C3,$E7,$7E,$3C,$3C,$7E,$E7,$C3,$00,$00,$00,$00,$00,
  $00,$00,$00,$E7,$E7,$E7,$E7,$E7,$FF,$7F,$07,$7F,$7E,$00,$00,$00,$00,$00,$00,
  $FF,$FF,$0E,$1C,$38,$70,$FF,$FF,$00,$00,$00,$00,$1C,$3C,$30,$70,$70,$E0,$E0,
  $70,$70,$30,$3C,$1C,$00,$00,$00,$00,$00,$1C,$1C,$1C,$1C,$00,$00,$1C,$1C,$1C,
  $1C,$00,$00,$00,$00,$00,$38,$3C,$0C,$0E,$0E,$07,$07,$0E,$0E,$0C,$3C,$38,$00,
  $00,$00,$00,$70,$F9,$FF,$9F,$0E,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 );

-------------------------------------------------------------
----- Begin of procedures & functions for "demo" part  ------
----- If you are interested in playing routines only,  ------
----- you can skip them all.                           ------
-------------------------------------------------------------

procedure MoveD( src, dest, size : Dword ); assembler;
asm ------- shot into memory - four bytes at once
  cld
  mov  ESI, [src]
  mov  EDI, [dest]
  mov  ECX, [size]
  rep  movsd
end;

procedure SetMode( tryb : word ); assembler;
asm
  mov  AX, [tryb]
  int  $10
end;

procedure FlipScreen( adres : dword ); assembler;
asm
    mov  DX, $3DA
@l1:               -- 0 - display mode, 1 - vertical retrace
     in  AL, DX
    and  AL, $08
    jnz  @l1
@l2: in  AL, DX
    and  AL, $08
     jz  @l2       -- wait for vertical retrace
    mov  ESI, [adres]
    mov  EDI, $A0000
    mov  ECX, 16000
    rep  movsd     -- flip screen
end;

procedure FillDWord( src, size, what : Dword ); assembler;
asm ------- Fill memory by four bytes at once
  mov  EDI, [src]
  mov  ECX, [size]
  mov  EAX, [what]
  rep  stosd
end;

procedure SetPal; assembler;
asm
  xor  AL, AL
  mov  DX, $3C8
  out  DX, AL
  mov  ESI, offset paleta
  mov  CX, 768
  mov  DX, $3C9
  rep  outsb
end;

procedure MakePalette;
var i : byte;
begin
  for i:=0 to 255 do
    begin
      paleta[ 3*i+1 ]:=i SHR 2;
      paleta[ 3*i+2 ]:=i SHR 2;
      paleta[ 3*i+3 ]:=i SHR 4;
    end;
  SetPal;
end;

procedure SpotLight( x1, y1 : word ); assembler;
---  for i:=0 to 64 do
---    for j:=0 to 64 do
---      mem[ VirScr+i+x1+( y1+j )*320 ]:=( mem[ VirScr+i+x1+( y1+j )*320 ]+
---        mem[ Phong+i+j*64 ] );
asm
         xor  EDX, EDX
         xor  EBX, EBX
         mov  EDI, [Phong]          -- mem[ Phong+y*64 ]
         mov  BX, [y1]
         shl  BX, 6
         mov  ESI, EBX
         shl  BX, 2
         add  BX, [x1]
         add  ESI, EBX              -- ESI = ( y1+y )*320
         add  ESI, [VirScr]         -- mem[ VirScr+x1+( y1+y )*320 ]
  @blp:
         mov  ECX, 63               -- X counter
  @llp:
         mov  AL, [EDI]             -- PhongBuf - ofs:phong
         mov  AH, [ESI]
         add  [ESI], AL
         inc  EDI                   -- mem[ Phong+y*64 + X ]
         inc  ESI                   -- mem[ VirScr+x1+( y1+y )*320 + X ]
         dec  ECX
         jnz  @llp
         inc  EDI
         add  ESI, 320-63
         inc  EDX                   -- Y counter
         and  EDX, $BF
         jnz  @blp
end;

procedure Phonguj( n : word; L : real; sredn : word; adres : dword );
var
   rx, ry, dr : integer;
begin
  rx:=-( sredn DIV 2 ); --- ustalanie wspolrzednych poczatk.
  ry:=-( sredn DIV 2 );
  FillChar( mem[ adres ], sredn*sredn, 0 );
  for i:=2 to sredn-2 do
    begin
      for j:=2 to sredn-2 do
        begin
          dr:=sqr( i-( sredn DIV 2 )-2 )+sqr( j-( sredn DIV 2 )-2 );
          if dr < sqr(( sredn DIV 2 )-4 ) then
            mem[ adres+j*sredn+i-1 ]:=round( 195*exp( n*ln(( L )/( sqrt( L*L + rx*rx + ry*ry )))));
          inc( rx );
        end;
     rx:=-( sredn DIV 2 );
     inc( ry );
    end
end;

procedure TextXY( where : dword; x, y : word; tekst : string; clr : byte );
var
  a, b, znak, zn : byte;
             adr : dword;
begin
  znak:=1;
  repeat
    a:=0;
    zn:=Ord( tekst[ znak ] )-32;
    repeat
      b:=0;
      repeat                              -- prepare text start & end x, y
        adr:=(( y+a ) SHL 6 )+(( y+a ) SHL 8 )+b+x+where;
        if (( sfont[ ( zn SHL 4 )+a ] SHL b ) AND $80 ) = $80
          then mem[ adr ]:=clr
          else mem[ adr ]:=0;
        inc( b );
      until b = 8;
      inc( a );
    until a = 16;
    inc( x, 9 );
    inc( znak );
  until znak = Ord( tekst[ 0 ] ) + 1;
end;

-----------------------------------------------------------
----- End of procedures & functions for "demo" part  ------
-----------------------------------------------------------

function HexW( dig : word ) : string;
const hx : array[ 0..15 ] of char = '0123456789ABCDEF';
begin
  HexW:='$'+hx[ dig SHR 12 ]+hx[ ( dig SHR 8 ) AND $0F ]+
            hx[ ( dig SHR 4 ) AND $0F ]+hx[ dig AND $0F ];
end;

BEGIN                                      -- program starts here
  --------------------------------------
  ----- Set Up Variables and datas -----
  --------------------------------------
   Phong:=Ofs( PhongBuf );
  VirScr:=Ofs( BufScr );
  VirMem:=Ofs( BufMem );
  SngAdr:=ofs( SongModule );   -- get offset of memory for song module
  BufAdr:=ofs( Buffer );       -- get offset of memory for internal buffer
  FillDWord( VirScr, 16000, 0 );
  FillDWord( VirMem, 16000, 0 );
  FillDWord( Phong, 1024, 0 ); -- clear buffers
  Phonguj( 2, 12, 64, Phong ); -- make light  :-)
  name:='atomic.mxm';          -- default module name
  if ParamCount <> 1
    then writeLn('Syntax: TMTPLAY <modulename.mxm>')
    else name:=ParamStr( 1 );
  writeLn;
  assign( plik, name );                    -- load song module
  {$I-}
  reset( plik, 1 );
  {$I+}
  if IOResult <> 0
    then begin
           writeLn('Where is your song module, man ?!');
           halt( 1 );
         end;
  FSize:=FileSize( plik );
  if FSize > 700000
    then begin
           writeLn('File size too big!!! (max. 680 kb).');
           halt( 1 );
         end;
  BlockRead( plik, SongModule, Fsize );
  close( plik );
  GusDevice:=xmpGetGusPort;                            -- look for gus port
  writeLn('GUS found at address: ',HexW( GusDevice ));
  sign:=xmpInit( SngAdr, BufAdr, GusDevice, 16384 );   -- init gus device
  writeLn('Init status: ',sign );
  writeLn;
  writeLn('Press any key...');
  ch:=ReadKey;
  -----------------------------------
  ------- Start DEMOnstration -------
  -----------------------------------
  SetMode( $0013 );
  MakePalette;
  TextXY( VirMem, 80, 20, 'Current Position:', 60 );
  TextXY( VirMem, 45, 80, 'CUBIC Tiny GUS MXM Player', 60 );
  TextXY( VirMem, 25, 95, 'TMT Pascal example (c) by K!O', 60 );
  loudness:=64;
  if sign = 1                          -- If all gone OK, let's play
    then begin
           xmpSetVolume( loudness );
           xmpPlay( 0 );               -- start playing module from pos. 0
         end;
  i:=4;  cnt:=4;
  repeat
    TextXY( VirMem, 130, 35, HexW( xmpGetPos ), 60 );
    moveD( VirMem, VirScr, 16000 );
    SpotLight( i, 60 );
    SpotLight( 185-( i DIV 2 ), 3 );
    FlipScreen( VirScr );
    inc( i, cnt );
    if ( i = 256 ) OR ( i = 0 ) then cnt:=-cnt;
  until KeyPressed;
  xmpStop;          -- stop play
  ch:=ReadKey;
  SetMode( $0003 );
END.