/*-*-c++-*-*/
#ifndef _DSPFUNK_H_
#define _DSPFUNK_H_
#include "types.h"

#define DEFAULT_BUFFER_SIZE 4096
//#define DEFAULT_BUFFER_SIZE 512
#define DEV_DSP "/dev/dsp"

class DSP {
public:
  DSP(int rate = 44100, int stereo = 1, int bits = 16);  // open  the dsp
  ~DSP();                                                // close the dsp

  void reset (void);
  void sync  (void);

  int  get_blksize (void);
  int  get_bufsize (void);
  int  get_bits    (void);
  int  get_rate    (void);
  int  is_stereo   (void);

  void set_bufsize(int bufsize);
  
  // play a buffer
  int play     (const ubyte  *&buffer, const int length);
  int play16_8 (const sword  *&buffer, const int length);
  int play32_8 (const sdword *&buffer, const int length);
  int play32_16(const sdword *&buffer, const int length);

  int   error;
private:
  int   fd;
  int   rate;
  int   bits;
  int   stereo; // 0 - mono, 1 - stereo
  int   blksize;
  int   bufsize;
  ubyte *audio_buffer;
};

inline int DSP::get_rate(void)
{
  return rate;
}

#endif
