/*-*-c++-*-*/
#ifndef _PLAYER_H_
#define _PLAYER_H_
#include "dsp.h"
#include "module.h"
#include "types.h"

struct ParamStatus
{
  sword Position;     /* used in processing the Envelope */
  sword Last_Point;
  sword Next_Point;
};


struct channel 
{
  ubyte  InstMode : 1;
  ubyte  Number : 7;
  ubyte  NoteNum;
  bool   key_off;
  ubyte  reverse; // this should be 1 when a BIDI loop is reversing

  sdword period;  
  sdword port_speed;
  sdword port_period; 

  udword fadeout;
  udword fadevol;

  ubyte  glissando; // toggle smooth slide or slide in junps of semitones
  ubyte  slide_speed;
  ubyte  retrig;

  sbyte  volume; // 0 - 64  -- amiga had only 6 bits for volume
  ubyte  vol_slide; // remember the EffParam for volume slide
  ubyte  vol_slide_fine;
  ubyte  gv_slide;

  //  int   panning;
  //  int   pan_spd;
  
  sbyte  vib_pos;  // -32 -> 31
  ubyte  vib_spd;  // 0->0x80
  ubyte  vib_dpth; // 0->0x80
  ubyte  vib_wave;
  sdword vib_delta; // -128 -> 127 

  ubyte  trem_pos;
  ubyte  trem_spd;
  ubyte  trem_dpth;
  ubyte  trem_wave;

  ubyte  tremor;
  ubyte  tremor_count;
  ubyte  tremor_vol;

  sbyte  ploop_start; //
  sbyte  ploop_count; //
  // 11 bits for fractional part
  // that restricts the sample size to 2M but who needs that?
  udword position;  
  Sample *smp;
  Instrument *In;
  //volume envelope
  ubyte EV;
  ParamStatus EV_Status; // remeber the position in the envelope
  //panning envelope
  //  Parameters *Panning;
  void reset_channel(void);
  ubyte process_parameters(Parameters *p, ParamStatus *t);
  void reset_parameters(ParamStatus *t);
};

class player: public DSP
{
public:  
  player();
  virtual ~player();

  void    play_tick(void);
  void    update_row(void);
  void    update_effects(void);

  void    play_pattern(int pattern, uword row = 0);
  void    play(void);

  void    stop(void);
  void    pause(void);

  void    release_mod(void);
  void    set_mod(Module *new_mod);
  void    set_bpm(const int bpm);
  void    set_speed(const int speed);
  void    set_gv(const int gv);    

  ubyte   get_bpm(void);
  ubyte   get_speed(void);
  Module  *get_mod(void);  

  // these functions are for the user interface
  virtual void callback_order(void); 
  virtual void callback_bpm  (void);
  virtual void callback_speed(void);
  virtual void callback_gv   (void);
  virtual void callback_end  (void);


  // channel callbacks -- called when something changes in the chan structure
  // these should really be in the channel class but 
  // then we couldn't redefine them
  virtual void callback_ch_volume(const int ch);
  virtual void callback_ch_note(const int ch);
  virtual void callback_ch_smp(const int ch);
  virtual void callback_ch_inst(const int ch);  

  // error stuff
  virtual void callback_error(const char *s);
  ubyte error; 

  // should mix be virtual ?
  void mix_channels(void);

  ubyte forked_player;
  ubyte paused;
  int child;
protected:
  ubyte bpm;
  ubyte speed;
  ubyte NumChan;
  udword order;
  udword pattern; 
  uword row; // what the heck -- allow really long patterns
  ubyte gv; // global volume -- 0-64 
  Module *mod;
private:  
  void do_volume_slide(const int ch);
  void do_portamento(const int ch);
  void do_vibrato(const int ch, const ubyte vib_type);
  void do_tremolo(const int ch);
  void do_tremor(const byte ch);

  void vol_up(const byte ch, const byte x);
  void vol_dn(const byte ch, const byte y);

  sdword note_to_period(const byte ch, const byte NoteNum);

  inline void update_position(int ch, udword scale, udword loop_start);
  inline void check_for_end(int ch, udword end, udword looplength,ubyte flags);

  sdword period_most;
  sdword period_least;

  // flags for Bxx and Dxx
  ubyte pattern_break; 
  ubyte pattern_jump;
  ubyte pattern_delay;
  ubyte pattern_loop;

  // these are valid if pattern_break or pattern_jump are set
  uword next_row;
  udword next_order;
    
  ubyte tick;

  void create_volume_table(void);
  int  create_linear_freq_table(void);

  sbyte volume_table[64][256];
  udword *linear_freq; // linear frequency table

  sdword *mix_buf;
  udword buf_length;       // length of buffer allocated
  udword mix_length;       // length to play
  channel *chan;         // should be NumChan of them
};
#endif
