#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <termios.h>
#include <sys/ioctl.h>

#include "dsp.h"
#include "module.h"
#include "player.h"

int vga_getkey();
char *note_to_string(byte note);

int main(int argc, char **argv)
{
  int j;
  Module *mod = 0;  
  
  if (argc <= 1) 
    {
      printf("usage : %s sample_file\n", argv[0]);
      exit(-1);
    }

  for (j = 0; j < argc; j++) 
    {
      mod = new Module;
      if (!mod->is_module(argv[j]))
	continue;
      printf("\n==== File : [%s] ====\n", argv[j]);
      if (!mod->load(argv[j])) 
	{
	  printf("error: %s\n", mod->error_message);
	  continue;
	}
      player p;
      p.set_mod(mod);
      printf("Channels %X SongLength %X\n", mod->channels, mod->SongLength);
      if (p.error)
	{
	  printf("player error\n");
	  return 0;
	}      
      p.play();      
      while (!vga_getkey()) 
	sleep(1);      
      p.stop();
    }
  printf("\n");
  exit(0);
}

int vga_getkey() 
{
  struct termio zap, original;
  char c;
  int e;

  ioctl(fileno(stdin), TCGETA, &original);	/* Get termio */
  zap = original;
  zap.c_cc[VMIN] = 0;				/* Modify termio  */
  zap.c_cc[VTIME] = 0;
  zap.c_lflag = 0;
  ioctl(fileno(stdin), TCSETA, &zap);		/* Set new termio */
  e = read(fileno(stdin), &c, 1);			/* Read one char */
  ioctl(fileno(stdin), TCSETA, &original);	/* Restore termio */
  if (e != 1)
    return 0;				/* No key pressed. */
  return c;					/* Return key. */
}

char *note_to_string(byte note)
{
  char *str = (char *)malloc(4);
  if (!note)
    return "---";
  if (note == 254)
    return "^^^";
  switch ((note-1) % 12)
    {
    case 0: 
      str[0] = 'C'; str[1] = '-';
      break;
    case 1:
      str[0] = 'C'; str[1] = '#';
      break;
    case 2:
      str[0] = 'D'; str[1] = '-';
      break;
    case 3:
      str[0] = 'D'; str[1] = '#';
      break;
    case 4:
      str[0] = 'E'; str[1] = '-';
      break;
    case 5:
      str[0] = 'F'; str[1] = '-';
      break;
    case 6:
      str[0] = 'F'; str[1] = '#';
      break;
    case 7:
      str[0] = 'G'; str[1] = '-';
      break;
    case 8:
      str[0] = 'G'; str[1] = '#';
      break;
    case 9:
      str[0] = 'A'; str[1] = '-';
      break;
    case 10:
      str[0] = 'A'; str[1] = '#';
      break;
    case 11:
      str[0] = 'B'; str[1] = '-';
      break;
    default:      
      return "---";
    }   
  str[2] = (char)((note / 12) + '0');
  str[3] = 0;
  return str;
}
