#ifndef _TYPES_H_
#define _TYPES_H_

#define LOW_BYTE(x)  ((x) & 0x00FF)
#define HIGH_BYTE(x) (((x) & 0xFF00) >> 8)

/* MACROS FOR ENDIANISM */

#define CONVERT_32(x) (((x & 0xff000000) >> 24) | ((x & 0x00ff0000) >>  8) | \
		       ((x & 0x0000ff00) <<  8) | ((x & 0x000000ff) << 24))

#define CONVERT_16(x) (((x & 0x00ff) << 8) | ((x & 0xff00) >> 8))

#ifdef LITTLE_ENDIAN
#define  L_ENDIAN_16(x) (x)
#define  L_ENDIAN_32(x) (x)
#define  B_ENDIAN_16(x) CONVERT_16(x)
#define  B_ENDIAN_32(x) CONVERT_32(x)
#else
#define  L_ENDIAN_16(x) CONVERT_16(x)
#define  L_ENDIAN_32(x) CONVERT_32(x)
#define  B_ENDIAN_16(x) (x)
#define  B_ENDIAN_32(x) (x)
#endif

  /* TYPES for specific sizes */

typedef unsigned char  byte;  /* 8 bits */
typedef unsigned short word;  /* 16 bits */
typedef unsigned long  dword; /* 32 bits */

typedef byte           BYTE;
typedef word           WORD;
typedef dword          DWORD;

typedef word           UWORD;
typedef byte           UBYTE;
typedef dword          UDWORD;

typedef unsigned char  ubyte;
typedef unsigned short uword;
typedef unsigned long  udword;

typedef signed char    sbyte;
typedef signed short   sword;
typedef signed long    sdword;

#endif
