'
' SDS interface for Turbo Basic ... sounds really weird...
'
' If you have troubles in understanding the cryptic code below, don't worry,
' it's not your fault. I DON'T recommend you to start learning TBASIC...
' and btw... only some of the API services are implemented here, not all of'em.
'

$INCLUDE "CONSTANT.INC"

'
' SDSDetectSession%
' Detects whether SDS is active or not
'   returns:   %True if SDS has been found
'              %False otherwise
'

DEF FNSDSDetectSession%

  LOCAL magic%

  REG %AX, %SDSAPIfunc               ' AH=0a0h
  REG %DX, &H1700                    ' DH=17h
  CALL INTERRUPT %MultiplexCall      ' INT 2Fh

  magic% = REG(%AX)                  ' read value returned in AX

  if magic% = &H4453 then
    FNSDSDetectSession% = %True
  else
    FNSDSDetectSession% = %False
  end if

END DEF

'
' SDSGetESBbyte% (Offset%)
' Returns the ESB byte at the given relative offset (see docs and pascal impl)
'   returns:   the byte at the specified offset in ESB
'

DEF FNSDSGetESBbyte% (Offset%)

  LOCAL esbSEG%, esbOFS%, value%

  DEF SEG   = 0
  esbOFS%   = PEEK(&H4FC) + (256 * PEEK(&H4FD))    ' get ESB's offset
  esbSEG%   = PEEK(&H4FE) + (256 * PEEK(&H4FF))    ' get ESB's segment

  DEF SEG   = esbSEG%                              ' make DS=ESB's seg
  value%    = PEEK(esbOFS% + Offset%)              ' get the desired byte

  DEF SEG                                          ' back to good ol' TBASIC...

  FNSDSGetESBbyte% = value%

END DEF

'
' SDSGetESBword% (Offset%)
' Returns the ESB word at the given relative offset (see docs and pascal impl)
'   returns:   the word at the specified offset in ESB
'

DEF FNSDSGetESBword% (Offset%)

  LOCAL esbSEG%, esbOFS%, value%

  DEF SEG   = 0
  esbOFS%   = PEEK(&H4FC) + (256 * PEEK(&H4FD))    ' get ESB's offset
  esbSEG%   = PEEK(&H4FE) + (256 * PEEK(&H4FF))    ' get ESB's segment

  DEF SEG   = esbSEG%                              ' make DS=ESB's seg
  value%    = PEEK(esbOFS% + Offset%)              ' get lower byte
  value%    = value% + (256 * PEEK(esbOFS% + Offset% + 1)) ' get the upper byte

  DEF SEG                                          ' back to good ol' TBASIC...

  FNSDSGetESBword% = value%

END DEF

'
' SDSPoll
' Mixes a bit of sound
'

SUB SDSPoll

  REG %AX, %SDSAPIfunc               ' AH=0a0h
  REG %DX, &H1800                    ' DH=18h
  CALL INTERRUPT %MultiplexCall      ' INT 2Fh

END SUB

'
' SDSSetTimer
' Switches SDS to TIMER mode
'

SUB SDSSetTimer

  REG %AX, (%SDSAPIfunc OR 0)        ' AH=0a0h, AL=0
  REG %DX, &H0500                    ' DH=05h
  CALL INTERRUPT %MultiplexCall      ' INT 2Fh

END SUB

'
' SDSSetPoll
' Switches SDS to POLL mode
'

SUB SDSSetPoll

  REG %AX, (%SDSAPIfunc OR 1)        ' AH=0a0h, AL=1
  REG %DX, &H0500                    ' DH=05h
  CALL INTERRUPT %MultiplexCall      ' INT 2Fh

END SUB

'
' SDSJump (Order%)
' Jumps to a specified order in the song
'

SUB SDSJump (Order%)

  REG %AX, (%SDSAPIfunc OR Order%)   ' AH=0a0h, AL=order
  REG %DX, &H1000                    ' DH=10h
  CALL INTERRUPT %MultiplexCall      ' INT 2Fh

END SUB

'
' SDSSetVolume (Volume%)
' Sets the desired global volume (valid values are between 0-40h)
'

SUB SDSSetVolume (Volume%)

  REG %AX, (%SDSAPIfunc OR Volume%)  ' AH=0a0h, AL=volume
  REG %DX, &H0100                    ' DH=01h
  CALL INTERRUPT %MultiplexCall      ' INT 2Fh

END SUB

'
' SDSSlideVolumeUp
' Increases the global volume by one unit
'

SUB SDSSlideVolumeUp

  REG %AX, %SDSAPIfunc               ' AH=0a0h
  REG %DX, &H0600                    ' DH=06h
  CALL INTERRUPT %MultiplexCall      ' INT 2Fh

END SUB

'
' SDSSlideVolumeDn
' Decreases the global volume by one unit
'

SUB SDSSlideVolumeDn

  REG %AX, %SDSAPIfunc               ' AH=0a0h
  REG %DX, &H0700                    ' DH=07h
  CALL INTERRUPT %MultiplexCall      ' INT 2Fh

END SUB

' oohhh , shiiit...