//****************************************************************************
// Sound Deluxe System 5, a Maple Leaf production, 1997
//****************************************************************************
// SDS5 interface for WATCOM C++ 10.0 (decl/defs)
// give creditz if ya use this shit... or I'll kick your butt from here! :)
//****************************************************************************
// Man, I love Watcom C !!!  :)
//****************************************************************************

#ifndef _SDS_INTERFACE_
#define _SDS_INTERFACE_

#ifndef boolean
#define boolean int
#define true 1
#define false 0
#endif

typedef char* flatptr;

flatptr ESB_address;        // 32bit linear External Sync Block's address
flatptr POLL_address;       // real seg:offs POLL routine address
flatptr API_address;        // real seg:offs API#1 entry point

//***************************************************************************
// boolean sds_DetectSession()
//   In: nothing
//   Out: false  SDS not found
//        true   SDS found
//   Note: this routine detects whether a SDS session is active or not, using
//         API #2 method (see SERVICES.DOC)
//***************************************************************************

boolean sds_DetectSession();
#pragma aux sds_DetectSession =          \
        "mov     ah,0a0h                "\   
        "mov     dh,17h                 "\   
        "int     2Fh                    "\   
        "cmp     eax,35534453h          "\   
        "je      getinfo                "\   
        "xor     eax,eax                "\   
        "jmp     outta                  "\
        "getinfo:                       "\
        "mov     edi,4FCh               "\
        "mov     eax,[edi]              "\   
        "mov     edi,eax                "\
        "shr     edi,12                 "\
        "and     edi,0FFFF0h            "\  
        "movzx   eax,ax                 "\
        "add     edi,eax                "\
        "mov     ESB_address,edi        "\   
        "mov     eax,[edi]              "\   
        "mov     POLL_address,eax       "\
        "mov     eax,[edi+2Ch]          "\   
        "mov     API_address,eax        "\
        "mov     eax,1                  "\  
        "outta:                         "\
        value [eax] \
        modify exact [edx edi];

//***************************************************************************
// void sds_Poll()
//   In: nothing
//   Out: nothing
//   Note: this routine performs a bit of mixing-ahead, in order to keep up
//         the music (sds internal vars and dma sound if needed)
//   Obs:  you can do this operation in two ways, using either API #2 or
//         a direct real-mode far call. THE FIRST MODE IS PREFERRED!
//***************************************************************************

void sds_Poll();
#pragma aux sds_Poll =                   \
        "mov     dh,18h                 "\  
        "mov     ah,0a0h                "\
        "int     2Fh                    "\  
        modify [eax edx];

//***************************************************************************
// void sds_SetTimer()
//   In: nothing
//   Out: nothing
//   Note: this routine switches SDS into TIMER mode
//***************************************************************************

void sds_SetTimer();
#pragma aux sds_SetTimer =               \
        "mov     dh,05h                 "\  
        "mov     eax,0a000h             "\  
        "int     2Fh                    "\  
        modify [eax edx];

//***************************************************************************
// void sds_SetPoll()
//   In: nothing
//   Out: nothing
//   Note: this routine switches SDS into POLL mode. From now on your
//         application has to perform succesive calls of SDS_Poll to keep up
//         the music
//***************************************************************************

void sds_SetPoll();
#pragma aux sds_SetPoll =                \
        "mov     dh,05h                 "\  
        "mov     eax,0a001h             "\  
        "int     2Fh                    "\  
        modify [eax edx];

//***************************************************************************
// int sds_GetUsrCounter()
//   In: nothing
//   Out: user counter (incremented BPM*2/5 times per second)
//   Note: this routine returns the value of the so called "user counter"
//***************************************************************************

int sds_GetUsrCounter();
#pragma aux sds_GetUsrCounter =          \
        "mov     edi,ESB_address        "\  
        "mov     eax,[edi+35h]          "\  
        value [eax]                      \
        modify exact [edi];

//***************************************************************************
// void sds_Jump (int order)
//   In: order
//   Out: nothing
//   Note: this routine performs an immediate jump to the order specified
//***************************************************************************

void sds_Jump(int);
#pragma aux sds_Jump =                   \
        "mov     ah,0a0h                "\  
        "mov     edx,1000h              "\  
        "int     2Fh                    "\  
        parm [eax]                       \
        modify [eax edx];

//***************************************************************************
// sds_SetVolume(int volume)
//   In: volume
//   Out: nothing
//   Note: this routine changes the global volume of the replayed sound to
//         the value specified. Valid values are the standard ones: 0-40h
//***************************************************************************

void sds_SetVolume(int);
#pragma aux sds_SetVolume =              \
        "mov     ah,0a0h                "\  
        "mov     edx,0100h              "\  
        "int     2Fh                    "\
        parm [eax]                       \
        modify [eax edx];

//***************************************************************************
// void sds_SlideVolumeDn()
//   In: nothing
//   Out: nothing
//   Note: this routine decreases the global volume by one
//***************************************************************************

void sds_SlideVolumeDn();
#pragma aux sds_SlideVolumeDn =          \
        "mov     ah,0a0h                "\  
        "mov     dh,7                   "\  
        "int     2Fh                    "\  
        modify [eax edx];

//***************************************************************************
// void sds_SlideVolumeUp()
//   In: nothing
//   Out: nothing
//   Note: this routine increases the global volume by one
//***************************************************************************

void sds_SlideVolumeUp();
#pragma aux sds_SlideVolumeUp =          \
        "mov     ah,0a0h                "\  
        "mov     dh,6                   "\  
        "int     2Fh                    "\  
        modify [eax edx];

//***************************************************************************
// void sds_SetMasterVolume(int volume)
//   In: master volume
//   Out: nothing
//   Note: this routine changes the master volume of the replayed sound to
//         the value specified. Valid values are between 0-0FFh
//   Remark: no effect on GUS
//***************************************************************************

void sds_SetMasterVolume(int);
#pragma aux sds_SetMasterVolume =        \
        "mov     ah,0a0h                "\  
        "mov     dh,2                   "\  
        "int     2Fh                    "\
        parm [eax]                       \
        modify [eax edx];

//***************************************************************************
// void sds_SetAmplification(int amplification)
//   In: gain percent (0=quiet...100=normal...200=double intensity...)
//   Out: nothing
//   Note: this routine changes the internal amplification level.
//   Remark: no effect on GUS
//***************************************************************************

void sds_SetAmplification(int);
#pragma aux sds_SetAmplification =       \
        "mov     ah,0a0h                "\  
        "mov     dh,3                   "\   
        "int     2Fh                    "\
        parm [ebx]                       \
        modify [eax edx];

//***************************************************************************
// void sds_SetSurroundMode(int mode)
//   In: mode (0=no surround, 1=surround)
//   Out: nothing
//   Note: this routine switches between surround/normal modes
//   Remark: no effect on GUS
//***************************************************************************

void sds_SetSurroundMode(int);
#pragma aux sds_SetSurroundMode =        \
        "mov     ah,0a0h                "\   
        "mov     dh,4                   "\   
        "int     2Fh                    "\
        parm [eax]                       \
        modify [eax edx];

//***************************************************************************
// void sds_ChannelOn(int channel)
//   In: channel number
//   Out: nothing
//   Note: this routine opens a channel which was previously shut down (unmute)
//***************************************************************************

void sds_ChannelOn(int);
#pragma aux sds_ChannelOn =              \
        "mov     ah,0a0h                "\   
        "mov     dh,9                   "\   
        "int     2Fh                    "\
        parm [eax]                       \
        modify [eax edx];

//***************************************************************************
// void sds_ChannelOff(int channel)
//   In: channel number
//   Out: nothing
//   Note: this routine shuts down a channel (mute it)
//***************************************************************************

void sds_ChannelOff(int);
#pragma aux sds_ChannelOff =             \
        "mov     ah,0a0h                "\   
        "mov     dh,0ah                 "\   
        "int     2Fh                    "\
        parm [eax]                       \
        modify [eax edx];

//***************************************************************************
// void sds_SkipPattern()
//   In: nothing
//   Out: nothing
//   Note: this routine cancels the currently playing pattern (jumps to next)
//***************************************************************************

void sds_SkipPattern();
#pragma aux sds_SkipPattern =            \
        "mov     ah,0a0h                "\   
        "mov     dh,11h                 "\   
        "int     2Fh                    "\
        modify [eax edx];

//***************************************************************************
// void sds_Pause()
//   In: nothing
//   Out: nothing
//   Note: this routine switches SDS to "waiting" state (PAUSE)
//***************************************************************************

void sds_Pause();
#pragma aux sds_Pause =                  \
        "mov     ah,0a0h                "\   
        "mov     dh,14h                 "\   
        "int     2Fh                    "\
        modify [eax edx];

//***************************************************************************
// void sds_Resume()
//   In: nothing
//   Out: nothing
//   Note: this routine restarts SDS after a "PAUSE" command
//***************************************************************************

void sds_Resume();
#pragma aux sds_Resume =                 \
        "mov     ah,0a0h                "\   
        "mov     dh,15h                 "\   
        "int     2Fh                    "\
        modify [eax edx];

//***************************************************************************
// char sds_GetESBByte(int offset)
//   In: offset in ESB
//   Out: nothing
//   Note: this routine returns the specified byte in ESB
//***************************************************************************

char sds_GetESBByte(int);
#pragma aux sds_GetESBByte =             \
        "add     eax,ESB_address        "\
        "mov     al,[eax]               "\
        parm [eax]                       \
        value [al];

//***************************************************************************
// short sds_GetESBWord(int offset)
//   In: offset in ESB
//   Out: nothing
//   Note: this routine returns the specified word in ESB
//***************************************************************************

short sds_GetESBWord(int);
#pragma aux sds_GetESBWord =             \
        "add     eax,ESB_address        "\
        "mov     ax,[eax]               "\
        parm [eax]                       \
        value [ax];

//***************************************************************************
// int sds_GetESBDWord(int offset)
//   In: offset in ESB
//   Out: nothing
//   Note: this routine returns the specified double-word in ESB
//***************************************************************************

int sds_GetESBDWord(int);
#pragma aux sds_GetESBDWord =            \
        "add     eax,ESB_address        "\
        "mov     eax,[eax]              "\
        parm [eax]                       \
        value [eax];

// and that's quite all...  well, there are a few more services in SDS,
// but you don't _really_ need them, and besides, I'm toooo lazy to
// code them now. implement them by yourself and feel happy about that... :)

#endif
