;     Ŀ
;        Sound Deluxe System 5, a Maple Leaf production               
;        1996-1997                                                    
;           
;        EMS functions (only those used by SDS...)                    
;     

emsFrameSeg      dw       0C800h         ; default Frame Page segment
emsFirst         db       1              ; first time here

emsHandle        dw       0              ; Handle
emsLogicalPage   dw       0              ; Logical page number (set by user)
emsPhysicalPage  db       0              ; Physical page number (set by user)

emsError         db       0              ; hope not ... !


;
; In: handle in emsHandle
;     logical page in emsLogicalPage
;     physical page in emsPhysicalPage
; Out: error code in emsError (0 if success)
;
nproc   emsMap
        cmp      cs:emsFirst,1    ; first time here ?
        jne      short emsok1
        call     emsGetFrameSeg   ; get the Frame Page segment
        mov      cs:emsFirst,0
emsok1: push     ax bx dx
        mov      dx,cs:emsHandle         ; handle
        mov      bx,cs:emsLogicalPage    ; ...
        mov      al,cs:emsPhysicalPage   ; ...
        mov      ah,44h                  ; Map function
        int      67h                     ; do it !
        mov      cs:emsError,ah
        pop      dx bx ax
        retn
nendp   emsMap

;
; Out: segment in emsFrameSeg
;
nproc   emsGetFrameSeg
        push     ax bx
        mov      ah,41h
        int      67h
        mov      cs:emsFrameSeg,bx
        pop      bx ax
        retn
nendp   emsGetFrameSeg


;
; In: Handle in AX
; Out: error code in emsError
;
nproc   emsSaveMapping
        push     ax dx
        mov      dx,ax
        mov      ah,47h  ; save mapping
        int      67h     ; do it
        mov      cs:emsError,ah
        pop      dx ax
        retn
nendp   emsSaveMapping

;
; In: Handle in AX
; Out: error code in emsError
;
nproc   emsRestoreMapping
        push     ax dx
        mov      dx,ax
        mov      ah,48h  ; restore mapping
        int      67h     ; do it
        mov      cs:emsError,ah
        pop      dx ax
        retn
nendp   emsRestoreMapping
