{
  Copyright (c) 1998 Erland Van Olmen (erlandvo@hotmail.com)
  Protected Mode Ready
}
Unit Shitty2;


interface

{}

Uses
  Crt;

Const
  MaxTopics = 16;

Type
  MenuTopicType = String[80];
  MenuType = Record
    Title: MenuTopicType;                           { Title of menu          }
    Topics: Array[0..MaxTopics-1] of MenuTopicType; { topic strings          }
    TAvail: Array[0..MaxTopics-1] of Boolean;       { topic avail? -=> True! }
    X1, Y1, X2, Y2: Byte;                           { physical Menu-coords   }
    NAvailC, TopicC, TopicBC: Byte;                 { colors                 }
    DefaultT: Byte;                                 { Default Topic          }
    BarPos  : Byte;                                 { Actual MenuBar Pos.    }
  End;

  Boxtype = Array[1..8] Of Byte;

Const
  DefNAvailC = DarkGray;
  DefTopicC  = Black;
  DefTopicBC = LightGray;

  NoTopic = 255;

  Box1: Boxtype = (ord(''), ord(''), ord(''), ord(''), ord(''), ord(''), ord(''), ord(''));
  Box7: Boxtype = (ord(''), ord(''), ord(''), ord(''), ord(''), ord(''), ord(''), ord(''));


Function  GetChoice(Menu: MenuType): Byte; { Returns NoTopic if user aborted }
Procedure DrawNiceBox(Menu: MenuType; BackGroundC: Byte);
Procedure DrawMenu(Menu: MenuType);
Procedure InitMenu(var Menu: MenuType);
Procedure ShowMenuBar(Menu: MenuType; Topic: Byte);
Procedure HideMenuBar(Menu: MenuType; Topic: Byte);
Procedure MoveMenuBar(Menu: MenuType; TopicStart, TopicEnd: Byte);
Function  TopicAbove (Menu: MenuType; Topic: Byte): Byte;  { These fn return }
Function  TopicBelow (Menu: MenuType; Topic: Byte): Byte;  { a topic if suc- }
                                                     { cessful or 255 if not }

{}
{}

implementation


Procedure WriteSP(x, y: Word; Msg: String; Len: Word);
VAR
  I: Byte;
BEGIN
  gotoxy(x, y); For I:=1 to Len do Write(' '); gotoxy(x, y); Write(Msg);
END;

{}

Procedure ClearXY(X1, Y1, X2, Y2: byte); {maxwaarde voor color: 7}
Var
   I, I2: Word;
BEGIN
  Window(X1+1, Y1+1, X2+1, Y2+1); ClrScr; Window(1, 1, 80, 25);
END; {Procedure Clearit}

{}

Procedure HBox(X1, Y1, X2, Y2: byte; BType: Boxtype; Filled: Boolean);
CONST
  BColor = DARKGRAY;
VAR
   X, Y: Word;
   dum1, _TextAttr: Byte;
BEGIN
  Inc(X1); Inc(X2); Inc(Y1); Inc(Y2);
  If Filled then clearXY(X1, Y1, X2-2, Y2-2);
  dum1:=TextAttr AND $70;
  _TextAttr:=dum1+WHITE;
  For X:=X1 to X2 do
    begin
      TextAttr:=dum1+WHITE;  gotoxy(X, Y1); Write(Chr(BType[5])); {''}
      TextAttr:=dum1+BColor; gotoxy(X, Y2); Write(Chr(BType[7]));
    end;
  For Y:=Y1 to Y2 do
    begin
      TextAttr:=dum1+WHITE;  gotoxy(X1, Y); Write(Chr(BType[6])); {''}
      TextAttr:=dum1+BColor; gotoxy(X2, Y); Write(Chr(BType[8]));
    end;
  GotoXY(X2, Y1); Write(Chr(BType[2])); {''}
  GotoXY(X2, Y2); Write(Chr(BType[4])); {''}
  TextAttr:=dum1+WHITE;
  GotoXY(X1, Y1); Write(Chr(BType[1])); {''}
  GotoXY(X1, Y2); Write(Chr(BType[3])); {''}
END;

{}

Procedure LBox(X1, Y1, X2, Y2: byte; BType: Boxtype; Filled: Boolean);
CONST
  BColor = DARKGRAY;
VAR
   X, Y: Word;
   dum1, _TextAttr: Byte;
BEGIN
  Inc(X1); Inc(X2); Inc(Y1); Inc(Y2);
  If Filled then clearXY(X1, Y1, X2-2, Y2-2);
  dum1:=TextAttr AND $70;
  _TextAttr:=dum1+WHITE;
  For X:=X1 to X2 do
    begin
      TextAttr:=dum1+BColor; gotoxy(X, Y1); Write(Chr(BType[5])); {''}
      TextAttr:=dum1+WHITE;  gotoxy(X, Y2); Write(Chr(BType[7]));
    end;
  For Y:=Y1 to Y2 do
    begin
      TextAttr:=dum1+BColor; gotoxy(X1, Y); Write(Chr(BType[6])); {''}
      TextAttr:=dum1+WHITE;  gotoxy(X2, Y); Write(Chr(BType[8]));
    end;
  GotoXY(X2, Y1); Write(Chr(BType[2])); {''}
  GotoXY(X2, Y2); Write(Chr(BType[4])); {''}
  TextAttr:=dum1+BColor;
  GotoXY(X1, Y1); Write(Chr(BType[1])); {''}
  GotoXY(X1, Y2); Write(Chr(BType[3])); {''}
END;

{}

Procedure DrawNiceBox(Menu: MenuType; BackGroundC: Byte);
VAR
  X1, Y1, X2, Y2, OldAttr, I: Byte;
BEGIN
  OldAttr:=TextAttr;
  X1:=Menu.X1;
  Y1:=Menu.Y1;
  X2:=Menu.X2;
  Y2:=Menu.Y2;
  TextBackGround(LightGray);
  HBox(X1, Y1, X2, Y2, Box7, True);
  TextColor(White); TextBackGround(LightGray);
  GotoXY(X1+2, Y1+1); For I:=1 to X2-X1-1 do Write(Chr(Box7[5]));
  LBox(X1+2, Y1+2, X2-2, Y2-1, Box1, False);
  TextBackGround(BackGroundC); TextColor(DarkGray);
  GotoXY(X1+2, Y2+1); For I:=1 to X2-X1 do Write(Chr(Box7[7]));
  TextColor(White);
  GotoXY(X1+1, Y2+1); Write(Chr(Box7[3]));
  TextAttr:=OldAttr;
END;

{}

Procedure DrawMenu(Menu: MenuType);
VAR
   OldAttr, I, Max: Byte;
BEGIN
  OldAttr:=TextAttr;
  With Menu do
  Begin
    TextColor(TopicC); TextBackGround(TopicBC); ClearXY(X1+3, Y1+3, X2-3, Y2-2);
    Gotoxy(X1+2, Y1+2); For I:=X1+1 to X2-1 do Write(' ');
    Gotoxy(X1+(X2-X1-Length(Title)) shr 1+1, Y1+2); Write(Title);
    If (Y2-Y1)>=MaxTopics then Max:=MaxTopics Else Max:=(Y2-Y1);
    For I:=0 to Max-1 do
    Begin
      If TAvail[I] then TextColor(TopicC) Else TextColor(NAvailC);
      Gotoxy(X1+5, Y1+4+I);
      Write(Topics[I]);
    End;
    If TAvail[DefaultT] then ShowMenuBar(Menu, DefaultT)
    Else
    Begin
      I:=TopicBelow(Menu, 0);
      If I<>NoTopic then Begin BarPos:=I; ShowMenuBar(Menu, BarPos); End;
    End;
  End;
  TextAttr:=OldAttr;
END;

{}

Procedure InitMenu(var Menu: MenuType);
VAR
   I: Byte;
BEGIN
  With Menu do Begin
    NAvailC:=DefNAvailC; TopicC:=DefTopicC; TopicBC:=DefTopicBC; DefaultT:=0;
    BarPos:=DefaultT;
    For I:=0 to MaxTopics-1 do Begin TAvail[I]:=False; Topics[I]:=''; End;
  End;
END;

{}

Procedure ShowMenuBar(Menu: MenuType; Topic: Byte);
VAR
   OldAttr: Byte;
BEGIN
  If Topic>MaxTopics then exit;
  OldAttr:=TextAttr;
  TextColor(Menu.TopicBC); TextBackGround(Menu.TopicC);
  WriteSP(Menu.X1+4, Menu.Y1+4+Topic, ' '+Menu.Topics[Topic], Menu.X2-Menu.X1-5);
  TextAttr:=OldAttr;
END;

{}

Procedure HideMenuBar(Menu: MenuType; Topic: Byte);
VAR
   OldAttr: Byte;
BEGIN
  If Topic>MaxTopics then exit;
  OldAttr:=TextAttr;
  TextColor(Menu.TopicC); TextBackGround(Menu.TopicBC);
  WriteSP(Menu.X1+4, Menu.Y1+4+Topic, ' '+Menu.Topics[Topic], Menu.X2-Menu.X1-5);
  TextAttr:=OldAttr;
END;

{}

Procedure MoveMenuBar(Menu: MenuType; TopicStart, TopicEnd: Byte);
BEGIN
  If Menu.TAvail[TopicEnd] then
    HideMenuBar(Menu, TopicStart); ShowMenuBar(Menu, TopicEnd);
END;

{}

Function TopicAbove (Menu: MenuType; Topic: Byte): Byte;
VAR
  I: Byte;
BEGIN
  If (Topic = 0) or (Topic>MaxTopics-1) then Begin TopicAbove:=NoTopic; exit; End;
  I:=Topic; Repeat Dec(I); Until (I=0) or (Menu.TAvail[I]);
  If Menu.TAvail[I] then TopicAbove:=I Else TopicAbove:=NoTopic;
END;

{}

Function  TopicBelow (Menu: MenuType; Topic: Byte): Byte;
VAR
  I: Byte;
BEGIN
  If (Topic>=MaxTopics-1) then Begin TopicBelow:=NoTopic; exit; End;
  I:=Topic; Repeat Inc(I); Until (I>=MaxTopics-1) or (Menu.TAvail[I]);
  If Menu.TAvail[I] then TopicBelow:=I Else TopicBelow:=NoTopic;
END;

{}

Function GetChoice(Menu: MenuType): Byte;  { Returns NoTopic if user aborted }
Const
  Enter     = chr(13);
  Escape    = chr(27);
  ArrowUp   = 'H';
  ArrowDown = 'P';

VAR
  Finished: Boolean;
  InsKey: Char;
  I: Byte;
BEGIN
  Finished:=False;
  InsKey  :='?';
  With Menu do
  Begin
    Repeat
      InsKey:=Crt.ReadKey;
      Case InsKey of
        Enter    : Begin Finished:=True; GetChoice:=BarPos;  Exit; End;
        Escape   : Begin Finished:=True; GetChoice:=NoTopic; Exit; End;
        ArrowUp  : Begin
                     I:=TopicAbove(Menu, BarPos);
                     If I<>NoTopic then
                       Begin MoveMenuBar(Menu, BarPos, I); BarPos:=I; End;
                   End;

        ArrowDown: Begin
                     I:=TopicBelow(Menu, BarPos);
                     If I<>NoTopic then
                       Begin MoveMenuBar(Menu, BarPos, I); BarPos:=I; End;
                   End;
      End;
    Until Finished;
    GetChoice:=BarPos;
  End;
END;

{}
{}

END.
