;            ͻ
;                   PLAY.ASM        
;                                                               
;                             Useless Player                    
;                              (EOS Version)                    
;            ĺ
;               by Freddy Vtel (FreddyV/Useless)              
;                                                               
;               Code Starts .................. 13/03/1996       
;               Last Update .................. 31/08/1997       
;            ͼ
.386p
INCLUDE OS.INC

CODE32 SEGMENT PUBLIC USE32 'CODE'
ASSUME  CS:CODE32,DS:CODE32,ES:CODE32

Use_Parameter EQU 1

INCLUDE ERR_CODE.INC
INCLUDE HARDWARE.INC

;** Files Loaders **

INCLUDE USMLOAD.INC
INCLUDE XMLOAD.INC
INCLUDE MODLOAD.INC
INCLUDE STMLOAD.INC
INCLUDE S3MLOAD.INC
INCLUDE ITLOAD.INC

INCLUDE USMPLAY.INC ; USM Player
INCLUDE USS.INC     ; Useless Sound System
INCLUDE USSVAR.INC
INCLUDE USM.INC

INCLUDE MEMORY.INC  ; For the maxavail function
INCLUDE UTILS.INC   ; Display macros (write, writeln)

;=============================================================================

FileNameOffset DD 0

Ampli DW 1000/5

USMOffset DD 0

StartMSG DB 'Useless Player v',USMP_Version,' (STM/S3M/MOD/XM/IT/USM).',13,10
	 DB 'By FreddyV/Useless',13,10,DOSStrEnd

;=============================================================================

; ********************
; *** Player Start ***
; ********************

Start32:

; ** "Hardware" Init **

	call HardwareInit

; ** get program parameter **

if Use_Parameter eq 1

	mov esi,PSPOffset       ; defined in HARDWARE.INC
	add esi,80h
	movzx eax,byte Ptr [esi]
	cmp eax,0
	je _USMPHelp
	inc esi
	mov byte ptr [esi+eax],0
	inc esi
	mov FileNameOffset,esi
endif

; ** Sound system Setup **

;       call USS_AutoSetup      ; Auto setup
;       jc _USMPEnd

       call USS_Setup           ; Menu setup
       jc _USMPEnd


; ** Player Start

        Cls

	mov edx,Offset StartMSG
        writeDOS

	U_Maxavail

        write 'Free memory: '
        shr eax,10
        call print_dec
        writeln 'Kb'

        write 'Device: '

        mov edx,_DEV_Name
        writeDOS

        writeln

; ** Load the file **

if Use_Parameter Eq 1
	mov esi,FileNameOffset
else
	mov esi,Offset Module
endif

	call LoadFile
	jc _USMPError

	mov USMOffset,esi

	write 'Song Name: '
	add esi,MName
	mov ecx,32
	call print_str
	writeln

; ** Start the output **

	mov esi,USMOffset
	call USMP_StartPlay
	jc _USMPError

        writeln
        writeln 'Speed:     Tempo:       Global Volume:      Ampli:'
	writeln 'Order:     Pattern:     Row:'

        writeln
        writeln 'Left  : Previous pattern.'
        writeln 'Right : Next pattern.'
        writeln 'O     : Oversampling On/Off.    (On mixed devices)'
        writeln '+/-   : Increase/Decrease Ampli (On mixed devices)'

        writeln 'Press Escape to stop.'

        mov ah,Use_Int_09
        mov bx,On
        Int_EOS

Wait_Key:
        cmp Key_Map[Escape],On
        je Key_Esc
        cmp Key_Map[Left],On
        je Key_Left
        cmp Key_Map[Right],On
        je Key_Right
        cmp Key_Map[Key_O],On
        je Switch_Oversampling
        cmp Key_Map[Plus],On
        je IncreaseAmpli
        cmp Key_Map[Moins],On
        je DecreaseAmpli

; Order
	mov al,7
	mov bl,8
	call GotoXY
	movzx eax,_Order
        call _dprint_dec
        dwrite ' '

; Pattern
	mov al,20
	mov bl,8
	call GotoXY
	movzx eax,_Pattern
        call _dprint_dec
	dwrite ' '

; Row
	mov al,29
	mov bl,8
	call GotoXY
	movzx eax,_Row
        call _dprint_dec
	dwrite ' '

; Tempo
	mov al,7
	mov bl,7
	call GotoXY
	movzx eax,_Speed
        call _dprint_dec
        dwrite ' '

; BPM
	mov al,18
	mov bl,7
	call GotoXY
	movzx eax,_BPM
        call _dprint_dec
        dwrite ' '

; Volume
	mov al,39
	mov bl,7
	call GotoXY
	movzx eax,SSGlobalVol
        call _dprint_dec
	dwrite '  '

; Ampli
	mov al,51
	mov bl,7
	call GotoXY
	movzx eax,Ampli
        call _dprint_dec
	dwrite '  '


        jmp Wait_Key

Key_Left:
        mov Key_Map[Left],Off
        call USMP_PrevOrder
        jmp Wait_Key

Key_Right:
        mov Key_Map[Right],Off
        call USMP_NextOrder
        jmp Wait_Key

Switch_Oversampling:
        mov Key_Map[Key_O],Off
        xor _DEV_Mode,DM_Interp
        jmp Wait_Key

IncreaseAmpli:
        mov Key_Map[Plus],Off
	movzx eax,Ampli
	cmp Ampli,65000
	jae NoIncreaseAmpli
NoIncreaseAmpli:
	add eax,10
	mov Ampli,ax
	call USS_SetAmpli
NoIncreadeAmpli:	
        jmp Wait_Key

DecreaseAmpli:
        mov Key_Map[Moins],Off
	movzx eax,Ampli
	cmp Ampli,0
	je NoIncreaseAmpli
NoDecreaseAmpli:
	sub eax,10
	mov Ampli,ax
	call USS_SetAmpli
NoDecreadeAmpli:	
        jmp Wait_Key

Key_Esc:
        mov Key_Map[Escape],Off

        mov ah,Use_Int_09
        mov bx,Off
        Int_EOS

; ** Stop the output **

        call USMP_StopPlay

; ** Free the memory **
        mov esi,USMOffset
        call USMP_FreeModule

        jmp _USMPEnd

_USMPError:
        call Display_Error_
        jmp _USMPEnd

_USMPHelp:
        writeln

        mov edx,Offset StartMSG
        writeDOS

	write 'Usage:  PLAY filename'

_USMPEnd:

	mov   ax,4C00h
	int   21h

;͸
; LoadFile: Load a music file.                                            
;                                                                         
; Input: ESI File Name.                                                   
;                                                                         
; Output: ESI Pointer to the loaded file.                                 
;         CF Set => Error number in EAX.                                  
;                                                                         
;

LoadFile Proc
	
        call DetectFileExtention
        jc _USMPHelp

        push esi
        write 'Loading '
        mov ecx,80
        call print_str
        writeln
        pop esi

        mov ecx,eax
        dec ecx
        mov ebx,LM_File                 ; Load from a file
        mov eax,DefPanning[4*ecx]       ; Default panning
        call LoadersOffset[4*ecx]

	ret
LoadFile Endp

;͸
; DetectFileExtention                                                     
;                                                                         
; Input: ESI File Name                                                    
;                                                                         
; Output: al, file type (MOD, XM or USM)                                  
;                                                                         
;

Nb_Ext EQU 6
ModExt DB 'MOD ','XM  ','USM ','STM ','S3M ','IT ',0

LoadersOffset DD Offset MOD_Load
	      DD Offset XM_Load
	      DD Offset USM_Load
	      DD Offset STM_Load
              DD Offset S3M_Load
              DD Offset IT_Load

DefPanning DD 20202020h,20202020h,0,20202020h   ; Mono
;DefPanning DD 10301030h,0,0,10301030h   ; Stereo
;DefPanning DD 00404000h,0,0,00404000h   ; Full Stereo

DetectFileExtention Proc

	push esi

DFELoop:
        lodsb
        cmp al,'.'
        je CheckExt
        cmp al,0
        je NotFound
        jmp DFELoop
CheckExt:
        lodsb
        cmp al,'.'
        je DFELoop
        dec esi

; File extention is in [esi]
        mov edi,esi

        xor eax,eax
DoNextExtention:
        inc eax
        mov edx,eax
        dec edx
        shl edx,2
        mov bl,ModExt[edx]
        cmp bl,0
        je NotFound

        mov ecx,0
        mov esi,edi
CompExtLoop:
        mov bl,ModExt[edx]
        cmp bl,' '
        jne NotExtEnd
        cmp Byte Ptr [esi],' '
        je CheckOk
        cmp Byte Ptr [esi],0
        je CheckOk
        jmp DoNextExtention
NotExtEnd:
        mov bh,[esi]
        cmp bl,'9'
        ja NoNumber
        cmp bl,'0'
        jae Number
NoNumber:
        and bh,not 20h    ; convert to uppercase (Letters)
Number:
        cmp bl,bh
        jne DoNextExtention
        inc esi
        inc edx
        inc ecx
        cmp ecx,(Nb_Ext-1)
        jne CompExtLoop 

CheckOk:
	pop esi
	clc
	ret

NotFound:
	pop esi
	stc
	ret

DetectFileExtention Endp

CODE32 ENDS
;=============================================================================
END
; PLAY.ASM (c) 1997 FreddyV/Useless
