/* tmpalloc.c
 *
 * Additional to malloc(), realloc(), free().
 * If we temporarily need only a 'small' amount of memory, we
 * do not need the assistence of an operating system and can
 * handle our own memory.
 * (to gain speed this data should not be swappable.)
 *
 * 31-Jul-93; Harald Zappe
 *
 */

/* lowest level: no #includes, no externals, no os-calls */

#define POOLSIZE  16*1024
#define NULL      (char *)0L
#define INI_PAT   0xA5F0

char mempool[POOLSIZE] = {0};     /* here it is */
int  mem_initted       = 0;

typedef struct { char     *prev;  /* back link     */
                 char     *next;  /* forw link     */
                 unsigned  len;   /* of used mem   */
                 int       used;  /* 0: no, 1: yes */
               } mlist;

/* If these routines may also be called be interrupt
 * routines you should avoid internal interruption by
 * disabling the interrupts.
 */

#ifdef  INTER_TOO
# ifndef __TURBOC__
#  define asm _asm
# else
#  pragma (inline)
# endif
# define CRITICAL_START asm pushf\
                        asm cli
# define CRITICAL_END   asm popf
#else
# define CRITICAL_START
# define CRITICAL_END
#endif


/* --------------------------------------------------------- */

/* ret NULL: not enough mem
 *     else ptr to mem
 */
char *tmp_alloc (unsigned len) {

  mlist *cur   = (mlist *)&mempool;
  int    mylen = (len + 3 +sizeof(mlist)) & 0xFFFC; /* mod 4 */

  if (mem_initted != INI_PAT) {

#ifdef INIT_REQUEST
    int i;
    for (i=0; i<POOLSIZE; i++)
      mempool[i] = 0;
#endif

    cur->prev = NULL;
    cur->next = NULL;
    cur->len  = POOLSIZE-sizeof(mlist);
    cur->used = 0;
    mem_initted = INI_PAT;
  }
  if (len > (POOLSIZE-(sizeof(mlist)+4))) return (NULL);

  CRITICAL_START;

  /* find first block which fits */
  while ((cur->next) && ((cur->len < mylen) || (cur->used))) {
    cur = (mlist *)cur->next;
  }

  if ((cur->len >= mylen) && !(cur->used)) {
    /* create new entry */
    mlist *nex = (mlist *)(((char *)cur) + mylen);

    nex->prev = (char *)cur;
    nex->next = cur->next;
    nex->len  = cur->len - mylen;
    nex->used = 0;

    /* ajust old entry */
    /* cur->prev = cur->prev */
    cur->next = (char *)nex;
    cur->len  = len;
    cur->used = 1;

    CRITICAL_END;
    /* adjust after list stuff */
    return ((char *)cur) + sizeof(mlist);
  }
  else {
    /* nothing found */
    CRITICAL_END;
    return (NULL);
  }

} /* tmp_alloc() */

/* --------------------------------------------------------- */

/* ret NULL: not changed
 *     else ptr to mem
 */
char *tmp_realloc (char *mem, unsigned len) {
  /* ...tbd... */
  return (NULL);
} /* tmp_realloc() */

/* --------------------------------------------------------- */

/* ret 0: ok, -1: invalid ptr */
int tmp_free (char *ptr) {

  mlist *cur = (mlist *)&mempool;
  char  *s = ptr - sizeof(mlist); /* start of stuff */

  if ( (ptr == NULL) || (s == NULL) ) return (-1);

  CRITICAL_START;

  /* find this block */
  while ((cur != (mlist *)s) && (cur->next)) {
    cur = (mlist *)cur->next;
  }

  if (cur == (mlist *)s) {
    /* free it */
    cur->used = 0;

    /*  special case 1: if there is a block in front and
     *  this block is free, it can be enlarged.
     */
    if (cur->prev) {
      mlist *prev = (mlist *)cur->prev;

      if (prev->used == 0) {
        prev->len += (cur->len +3+sizeof(mlist)) & 0xFFFC; /* mod 4 */
        prev->next = cur->next; /* discard current block */
        cur = prev;  /* so it's lost */
      }
    }

    /*  special case 2: if there is a block behind us and
     *  this block is free, the current block can be enlarged.
     */
    if (cur->next) {
      mlist *nex = (mlist *)cur->next;

      if (nex->used == 0) {
        cur->len += (nex->len +3+sizeof(mlist)) & 0xFFFC; /* mod 4 */
        cur->next = nex->next; /* discard next block */
      }
    }

    CRITICAL_END;
    return (0);
  }
  else {
    /* not found */
    CRITICAL_END;
    return (-1);
  }

} /* tmp_free() */

/* --------------------------------------------------------- */
/* <eof> tmpalloc.c */
