/*
 * TChip output -> TARGA convertor
 * Copyright (c) 1997 Image!
 * Version 0.1
 *
 * Written by Rick van Lieshout (a.k.a. Mr.Aurum / Image!)
 * Mail me at marm@hetnet.nl
 *
*/

// Tab size = 3

#include	<stdio.h>
#include	<stdlib.h>


typedef	unsigned char	BYTE;
typedef	unsigned short	WORD;

#pragma pack(1)

typedef	struct	{

	BYTE	zero,cmt,itc;
	WORD	corigx,corigy;
	BYTE	cmes;
	WORD	origx,origy,width,heigth;
	BYTE	bpp,descriptor;
	
} TARGA_Header;


typedef	struct	{

	BYTE	red,green,blue;
	
} TChip_format;


typedef	struct	{

	BYTE	blue,green,red;
	
} TARGA_format;


#pragma pack()


FILE				*InFile,*OutFile;
int				FileSize;
TARGA_Header	Header;
TARGA_format	OutPixel;
TChip_format	InPixel;



void	main(int argc,char **argv)
{
	printf("\nTChip output -> TARGA Convertor  v0.1  Copyright (c) 1997 Image!\n\n");

	if (argc != 3) {
		printf("Usage:\n  out2tga <infile.ext> <outfile.tga>\n\n");
		printf("<infile.ext>  The file generated by the TChip program\n");
		printf("<outfile.tga> The new file, a 24bits TARGA file\n\n");
		exit(EXIT_FAILURE);
	}
	
	InFile = fopen(argv[1],"rb");
	if (!InFile) {
		printf("FATAL: Unable to open input file (%s)\n\n",argv[1]);
		exit(EXIT_FAILURE);
	}
	
	fseek(InFile,0,SEEK_END);
	FileSize = ftell(InFile);
	fseek(InFile,0,SEEK_SET);
	
	if (FileSize < 196608) {
		printf("FATAL: Input file too small\n\n");
		exit(EXIT_FAILURE);
	}
	
	OutFile = fopen(argv[2],"wb");
	if (!OutFile) {
		printf("FATAL: Unable to create output file (%s)\n\n",argv[2]);
		exit(EXIT_FAILURE);
	}
	
	Header.width = 256;
	Header.heigth = (FileSize/196608)*256;
	Header.bpp = 24;
	Header.zero = Header.corigx = Header.corigy = Header.origx = Header.origy = 0;
	Header.cmes = Header.cmt = 0;
	Header.itc = 2;
	Header.descriptor = 0x20;
	
	printf(" Input file        : %s\n",argv[1]);
	printf(" Output file       : %s\n",argv[2]);
	printf(" Output resolution : 256x%d\n",(FileSize/196608)*256);
	printf("\nPlease wait...");
	fflush(stdout);
	
	fwrite(&Header,sizeof(TARGA_Header),1,OutFile);
	
	FileSize /= 3;
	while (FileSize > 0) {
	
		fread(&InPixel,3,1,InFile);
		OutPixel.red = InPixel.red;
		OutPixel.green = InPixel.green;
		OutPixel.blue = InPixel.blue;
		fwrite(&OutPixel,3,1,OutFile);
	
		--FileSize;
	}
	
	fclose(OutFile);
	fclose(InFile);
	
	printf("Done\n\n");
}