{$N+,G+,F+}
PROGRAM	TChipParser;


USES	Crt,Dos;


TYPE  Routine						= PROCEDURE;
		TInstructionType			= STRING[32];

		PInstruction				= ^TInstruction;
		TInstruction				= RECORD

			Name						: TInstructionType;
			ByteCode					: Byte;
			Size						: Byte;

			Handler					: PROCEDURE;

			Next						: PInstruction;

		END;

		PLabel						= ^TLabel;
		TLabel						= RECORD

			Name						: STRING;
			IP							: WORD;

			Next						: PLabel;

		END;


VAR	INSTRUCTION					: TInstructionType;
		IDENTIFIER					: STRING;

		IP								: WORD;

		REG_1,REG_2					: Byte;
		ABS_1,ABS_2					: Single;

		InstrRoot					: PInstruction;
		LabelRoot					: PLabel;

		LineNr						: LongInt;

		InF							: Text;
		OutF							: FILE;

		Pass							: Byte;

		ParseLine 					: STRING;

		ProcOpen						: Boolean;
		TheEnd						: Boolean;

		cINSTRUCTION				: TInstruction;

		EntryPoint					: Word;



PROCEDURE	AddInstruction(VAR Root : PInstruction; Name : TInstructionType; ByteCode : Byte; Handler : Routine; Size : Byte);
BEGIN

	IF Root = NIL THEN BEGIN

		New(Root);
		Root^.Next := NIL;

		Root^.Name := Name;
		Root^.ByteCode := ByteCode;
		Root^.Handler := Handler;
		Root^.Size := Size;

	END ELSE BEGIN

		AddInstruction(Root^.Next,Name,ByteCode,Handler,Size);

	END;

END;


PROCEDURE	AddLabel(VAR Root : PLabel; Name : STRING; IP : Word);
BEGIN

	IF Root = NIL THEN BEGIN

		New(Root);
		Root^.Next := NIL;

		Root^.Name := Name;
		Root^.IP := IP;

	END ELSE BEGIN

		IF Root^.Name = Name THEN BEGIN
			Writeln('FATAL: Identifier already used at line: ',LineNr);
			Halt(1);
		END;
		AddLabel(Root^.Next,Name,IP);

	END;

END;


PROCEDURE	OutByte(B : Byte);
BEGIN

	BlockWrite(OutF,B,1);

END;


PROCEDURE	OutWord(W : Word);
BEGIN

	BlockWrite(OutF,W,2);

END;


PROCEDURE	OutReg(R : Single);
BEGIN

	BlockWrite(OutF,R,4);

END;


PROCEDURE	Dummy_Handler;
BEGIN
  Writeln('If you see this message contact me at marm@hetnet.nl');
END;


PROCEDURE	Handle_PROCi;
BEGIN
{	Writeln('Adding subroutine: ',IDENTIFIER,' (at ',IP,')');}
	AddLabel(LabelRoot,IDENTIFIER,IP);
	ProcOpen := True;
END;


PROCEDURE	Handle_PROCi2;
BEGIN
	IF ProcOpen THEN BEGIN
		Writeln('WARNING: Last PROC not closed at line: ',LineNr);
	END;
	ProcOpen := True;
END;


PROCEDURE	Handle_Label;
BEGIN
{	Writeln('Adding label: ',IDENTIFIER,' (at ',IP,')');}
	IF IDENTIFIER = 'MAIN' THEN EntryPoint := IP;
	AddLabel(LabelRoot,IDENTIFIER,IP);
END;


PROCEDURE	Handle_ENDP;
BEGIN
	IF NOT ProcOpen AND (Pass <> 1) THEN Writeln('WARNING: No open PROC''s detected at line: ',LineNr);
	ProcOpen := False;
END;


PROCEDURE   Handle_END;
BEGIN
	TheEnd := True;
END;


PROCEDURE	Handle_rr;
BEGIN
	OutByte(cINSTRUCTION.ByteCode);
	OutByte(Reg_1);
	OutByte(Reg_2);
END;


PROCEDURE	Handle_ra;
BEGIN
	OutByte(cINSTRUCTION.ByteCode);
	OutByte(Reg_1);
	OutReg(ABS_2);
END;


PROCEDURE	Handle_r;
BEGIN
	OutByte(cINSTRUCTION.ByteCode);
	OutByte(Reg_1);
END;

PROCEDURE	Handle_a;
BEGIN
	OutByte(cINSTRUCTION.ByteCode);
	OutReg(ABS_1);
END;


PROCEDURE	Handle_i;

VAR	Walker						: PLabel;

BEGIN
	OutByte(cINSTRUCTION.ByteCode);

	Walker := LabelRoot;
	WHILE (Walker <> NIL) AND (Walker^.Name <> IDENTIFIER) DO
		Walker := Walker^.Next;

	IF Walker = NIL THEN BEGIN
		Writeln('FATAL: Unknown jump address at line: ',LineNr);
		Halt(1);
	END;

	OutWord(Walker^.IP);

END;


PROCEDURE	Handle_Single;
BEGIN
	OutByte(cINSTRUCTION.ByteCode);
END;



PROCEDURE	InitInstructions;
BEGIN


	AddInstruction(InstrRoot,'PROCi',255,Handle_PROCi,0);
	AddInstruction(InstrRoot,'>i',255,Handle_Label,0);
	AddInstruction(InstrRoot,'ENDP',255,Handle_ENDP,0);

	AddInstruction(InstrRoot,'PROCi',254,Handle_PROCi2,0);
	AddInstruction(InstrRoot,'ENDP',254,Handle_ENDP,0);
	AddInstruction(InstrRoot,'END',254,Handle_END,0);

	AddInstruction(InstrRoot,'MOVr,r',0,Handle_rr,3);
	AddInstruction(InstrRoot,'MOVr,a',1,Handle_ra,6);

	AddInstruction(InstrRoot,'ADDr,r',2,Handle_rr,3);
	AddInstruction(InstrRoot,'ADDr,a',3,Handle_ra,6);

	AddInstruction(InstrRoot,'SUBr,r',4,Handle_rr,3);
	AddInstruction(InstrRoot,'SUBr,a',5,Handle_ra,6);

	AddInstruction(InstrRoot,'MULr,r',6,Handle_rr,3);
	AddInstruction(InstrRoot,'MULr,a',7,Handle_ra,6);

	AddInstruction(InstrRoot,'DIVr,r',8,Handle_rr,3);
	AddInstruction(InstrRoot,'DIVr,a',9,Handle_ra,6);

	AddInstruction(InstrRoot,'SQRr',10,Handle_r,2);

	AddInstruction(InstrRoot,'SQRTr',11,Handle_r,2);

	AddInstruction(InstrRoot,'LDCr,r',12,Handle_rr,3);
	AddInstruction(InstrRoot,'STCr,r',13,Handle_rr,3);

	AddInstruction(InstrRoot,'INCr',14,Handle_r,2);
	AddInstruction(InstrRoot,'DECr',15,Handle_r,2);

	AddInstruction(InstrRoot,'CMPr,r',16,Handle_rr,3);
	AddInstruction(InstrRoot,'CMPr,a',17,Handle_ra,6);

	AddInstruction(InstrRoot,'JMPi',18,Handle_i,3);
	AddInstruction(InstrRoot,'JGi',19,Handle_i,3);
	AddInstruction(InstrRoot,'JEi',20,Handle_i,3);
	AddInstruction(InstrRoot,'JLi',21,Handle_i,3);
	AddInstruction(InstrRoot,'JGEi',22,Handle_i,3);
	AddInstruction(InstrRoot,'JLEi',23,Handle_i,3);

	AddInstruction(InstrRoot,'RET',24,Handle_Single,1);

	AddInstruction(InstrRoot,'STMr',25,Handle_r,2);
	AddInstruction(InstrRoot,'STMa',26,Handle_a,5);

	AddInstruction(InstrRoot,'LDZr',27,Handle_r,2);

	AddInstruction(InstrRoot,'CLRM',28,Handle_Single,1);
	AddInstruction(InstrRoot,'SAVM',29,Handle_Single,1);

	AddInstruction(InstrRoot,'CALLi',30,Handle_i,3);

	AddInstruction(InstrRoot,'LDPIr',31,Handle_r,2);

	AddInstruction(InstrRoot,'SINr',32,Handle_r,2);
	AddInstruction(InstrRoot,'COSr',33,Handle_r,2);
	AddInstruction(InstrRoot,'BLUR',34,Handle_Single,1);
	AddInstruction(InstrRoot,'MONO',35,Handle_Single,1);
	AddInstruction(InstrRoot,'RNDP',36,Handle_Single,1);

    AddInstruction(InstrRoot,'RNDD',37,Handle_Single,1);
    AddInstruction(InstrRoot,'RNDDa',38,Handle_a,5);

    AddInstruction(InstrRoot,'SRNDr',39,Handle_r,2);
    AddInstruction(InstrRoot,'SRNDa',40,Handle_a,5);

    AddInstruction(InstrRoot,'CLIPr',41,Handle_r,2);

END;


FUNCTION	InstructionExists(VAR I : TInstruction) : Boolean;

VAR	Walker						: PInstruction;
		RetValue						: Boolean;

BEGIN

	RetValue := True;

	Walker := InstrRoot;
	WHILE (Walker <> NIL) AND (Walker^.Name <> INSTRUCTION) DO
		Walker := Walker^.Next;

	IF Walker <> NIL THEN I := Walker^
	ELSE RetValue := False;

	InstructionExists := RetValue;

END;


PROCEDURE 	DetectInstruction;

VAR	Index							: Byte;
		Ch								: Char;
		Count							: Byte;
		Code							: Integer;
		PARAM_1,PARAM_2			: STRING;

BEGIN

	{ Remove all remarks }
	WHILE Pos(';',ParseLine) <> 0 DO
		Delete(ParseLine,Pos(';',ParseLine),Length(ParseLine)-Pos(';',ParseLine)+1);

	IF Length(ParseLine) = 0 THEN Exit;

	WHILE ParseLine[1] IN [' ',#9] DO Delete(ParseLine,1,1);
	Index := Length(ParseLine);
	WHILE ParseLine[Index] IN [' ',#9] DO BEGIN
		Delete(ParseLine,Index,1);
		Index := Length(ParseLine);
	END;

	WHILE Pos(#9,ParseLine) <> 0 DO ParseLine[Pos(#9,ParseLine)] := ' ';

	WHILE Pos('  ',ParseLine) <> 0 DO BEGIN
		Index := Pos('  ',ParseLine);
		Delete(ParseLine,Index,2);
		Insert(' ',ParseLine,Index);
	END;

	FOR Index := 1 TO Length(ParseLine) DO
		ParseLine[Index] := UpCase(ParseLine[Index]);

	INSTRUCTION := '';
	Index := 1;
	REPEAT
		Ch := ParseLine[Index];
		Ch := UpCase(Ch);
		INSTRUCTION := INSTRUCTION + Ch;
		Inc(Index);
	UNTIL (ParseLine[Index] IN [' ',';',#9]) OR (Index > Length(ParseLine));

	Delete(ParseLine,1,Length(INSTRUCTION)+1);

	IF Length(ParseLine) <> 0 THEN BEGIN

		IF Pos(',',ParseLine) <> 0 THEN BEGIN
			{ 2 paramters }

			WHILE Pos(',',ParseLine) <> 0 DO
				ParseLine[Pos(',',ParseLine)] := ' ';

			WHILE Pos('  ',ParseLine) <> 0 DO BEGIN
				Index := Pos('  ',ParseLine);
				Delete(ParseLine,Index,2);
				Insert(' ',ParseLine,Index);
			END;

			PARAM_1 := Copy(ParseLine,1,Pos(' ',ParseLine)-1);
			Delete(ParseLine,1,Pos(' ',ParseLine));

			Count := 0;
			FOR Index := 1 TO Length(ParseLine) DO
				IF ParseLine[Index] = ' ' THEN Inc(Count);

			IF Count > 0 THEN BEGIN

				Writeln('WARNING: Illegal number of parameters on line: ',LineNr);
				PARAM_2 := Copy(ParseLine,1,Pos(' ',ParseLine)-1);

			END ELSE PARAM_2 := ParseLine;

			ParseLine := PARAM_1;
			IF Length(ParseLine) = 1 THEN BEGIN

				IF	ParseLine[1] IN ['A'..'Z'] THEN BEGIN
					INSTRUCTION := INSTRUCTION + 'r,';
					REG_1 := Ord(ParseLine[1]) - Ord('A');
				END;

			END ELSE BEGIN

				IF ParseLine[1] IN ['-','0'..'9'] THEN BEGIN
					INSTRUCTION := INSTRUCTION + 'a,';
					Val(ParseLine,ABS_1,Code);
					IF Code <> 0 THEN BEGIN

						Writeln('FATAL: Incorrect parameter at line: ',LineNr);
						Halt(1);

					END;
				END ELSE BEGIN
					INSTRUCTION := INSTRUCTION + 'i,';
					IDENTIFIER := ParseLine;
				END;

			END;

			ParseLine := PARAM_2;
			IF Length(ParseLine) = 1 THEN BEGIN

				IF	ParseLine[1] IN ['A'..'Z'] THEN BEGIN
					INSTRUCTION := INSTRUCTION + 'r';
					REG_2 := Ord(ParseLine[1]) - Ord('A');
				END ELSE	IF ParseLine[1] IN ['0'..'9'] THEN BEGIN
					INSTRUCTION := INSTRUCTION + 'a';
					Val(ParseLine,ABS_2,Code);
					IF Code <> 0 THEN BEGIN

						Writeln('FATAL: Incorrect parameter at line: ',LineNr);
						Halt(1);

					END;
				END;

			END ELSE BEGIN

				IF ParseLine[1] IN ['-','0'..'9'] THEN BEGIN
					INSTRUCTION := INSTRUCTION + 'a';
					Val(ParseLine,ABS_2,Code);
					IF Code <> 0 THEN BEGIN

						Writeln('FATAL: Incorrect parameter at line: ',LineNr);
						Halt(1);

					END;
				END ELSE BEGIN
					INSTRUCTION := INSTRUCTION + 'i';
					IDENTIFIER := ParseLine;
				END;

			END;

		END ELSE BEGIN
			{ 1 parameter }

			IF Length(ParseLine) = 1 THEN BEGIN

				IF	ParseLine[1] IN ['A'..'Z'] THEN BEGIN
					INSTRUCTION := INSTRUCTION + 'r';
					REG_1 := Ord(ParseLine[1]) - Ord('A');
				END ELSE	IF ParseLine[1] IN ['0'..'9'] THEN BEGIN
					INSTRUCTION := INSTRUCTION + 'a';
					Val(ParseLine,ABS_1,Code);
					IF Code <> 0 THEN BEGIN

						Writeln('FATAL: Incorrect parameter at line: ',LineNr);
						Halt(1);

					END;
				END;

			END ELSE BEGIN

				IF ParseLine[1] IN ['-','0'..'9'] THEN BEGIN
					INSTRUCTION := INSTRUCTION + 'a';
					Val(ParseLine,ABS_1,Code);
					IF Code <> 0 THEN BEGIN

						Writeln('FATAL: Incorrect parameter at line: ',LineNr);
						Halt(1);

					END;
				END ELSE BEGIN
					INSTRUCTION := INSTRUCTION + 'i';
					IDENTIFIER := ParseLine;
				END;

			END;

		END;

	END ELSE BEGIN
		{ No parameters }

	END;

	IF NOT InstructionExists(cINSTRUCTION) THEN BEGIN

		Writeln('FATAL: Illegal instruction on line: ',LineNr);
		Writeln(' Instruction ',INSTRUCTION);
		Writeln(' IP          ',IP);

		Halt(1);

	END;

	IF Pass = 1 THEN
		IF cINSTRUCTION.ByteCode = 255 THEN cINSTRUCTION.Handler;
	IF Pass <> 1 THEN
		IF cINSTRUCTION.ByteCode <> 255 THEN cINSTRUCTION.Handler;
	IP := IP + cINSTRUCTION.Size;

END;


FUNCTION	GetLine : Boolean;

VAR	RetValue						: Boolean;

BEGIN

	RetValue := True;

	ParseLine := '';

	Inc(LineNr);
	GetLine := True;
	IF NOT EoF(InF) THEN BEGIN
		Readln(InF,ParseLine);
		IF Length(ParseLine) <> 0 THEN DetectInstruction;
	END ELSE RetValue := False;

	GetLine := RetValue;

END;



BEGIN	{ Main }

	ClrScr;

	IP := 0;
	LineNr := 0;
	ProcOpen := False;
	TheEnd := False;
	Pass := 1;
	EntryPoint := 0;

	InitInstructions;

	Writeln('TChip source assembler  v0.1  Copyright (c) 1997 Image!');
	Writeln;

	IF ParamCount <> 2 THEN BEGIN

		Writeln('Usage: PARSER <infile.ext> <outfile.ext>');
		Halt(2);

	END;

	Assign(InF,ParamStr(1));
	{$I-} Reset(InF); {$I+}
	IF IOResult <> 0 THEN BEGIN

		Writeln('ERROR: Unable to open the input file: ',ParamStr(1));
		Halt(3);

	END;
	Writeln('Using input file   : ',ParamStr(1));
	Assign(OutF,ParamStr(2));
	{$I-} Rewrite(OutF,1); {$I+}
	IF IOResult <> 0 THEN BEGIN

		Writeln('ERROR: Unable to create the output file: ',ParamStr(2));
		Halt(3);

	END;
	Writeln('Using output file  : ',ParamStr(2));
	Writeln;
	Write('Pass #1..');
	REPEAT UNTIL NOT GetLine OR TheEnd;
	Close(InF);

	BlockWrite(OutF,EntryPoint,2);

	Assign(InF,ParamStr(1));
	{$I-} Reset(InF); {$I+}
	IF IOResult <> 0 THEN BEGIN

		Writeln('ERROR: Unable to open the input file: ',ParamStr(1));
		Halt(3);

	END;
	Pass := 2;
	Writeln('Ok.');
	Write('Pass #2..');
	LineNr := 0;
	IP := 0;
	REPEAT UNTIL NOT GetLine OR TheEnd;

	Close(InF);

	Writeln('Ok.');
	Writeln;
	Writeln('Status:');
	Writeln(' Entry point at address ',EntryPoint);

END.	{ Main }
