{$A-,B-,D+,E-,F-,G-,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V+,X+,Y-}
{$M 1024,0,0}

{
Program to test of judge's machine is suitable for 8086 compo.
Written by Trixter / Hornet (Jim Leonard) on 10/7/95 with some
routines written by Bruce J. Lackore.

This program was optimized for size in the hour I felt like
optimizing it.  :-)
}

Program Test8086;

uses
  dos;

Type
  vsystem=(MONO,HERC,CGA,EGA,VGA,MCGA,OTHER);

Const
  {timer ticks per second}
  ticksper=18;

  {message 1}
  m1=' acceptable for testing the 8086 entries.';

  {cpu types}
  Cpu8086   = 1;
  Cpu80286  = 2;
  Cpu80386  = 3;
  Cpu80486  = 4;

  {video names}
  vidnames : Array[vsystem] Of String[34]=
  (
  'Monochrome Text',
  'Hercules Monochrome Graphics/Text',
  'Color Graphics Adapter',
  'Extended Graphics Adapter',
  'Video Graphics Array',
  'Multi-Color Graphics Adapter',
  'Could not identify'
  );

var
  TimerTicks : LongInt Absolute $40 : $6C;

{---------floppy delay and other system code-----------}

Procedure WaitForFloppy;
{Many systems slow down to 8MHz when accessing the floppy drive,
 so in order to get a good speed test, we need to wait until the
 floppy drive has spun down.}
const
  secs=5;
Var
  tickTil     : LongInt;
  motorStatus : Byte Absolute $40 : $3F;
begin
  if MotorStatus and $F > 0 then
  begin
    WriteLn('Waiting for floppy drive to stop spinning...');
    {wait for floppy drive, or a number of seconds, whichever comes first}
    TickTil := TimerTicks + (ticksper * secs);
    if TickTil > $17FE80            {There are $17FE80 ticks in a day}
      then Dec(TickTil, $17FE80);   {(for running the program at midnight)}
    Repeat
      {wait until motor is stopped or amount of time has gone by}
    Until (MotorStatus and $F = 0) or (TimerTicks >= TickTil);
    writeln('Floppy drive has stopped.  Continuing...');
  end;
end;

procedure delay(ms:longint);
{very sloppy approximation of delay code, but it will suffice}
var
  LastTick:longint;
begin
  LastTick:=TimerTicks;
  Repeat UNTIL (TimerTicks-LastTick) > ((ticksper * ms) div 1000);
end;

Function Readkey:Char;Assembler;
asm
 Xor ax,ax
 Int 16h
 Cmp al,00h
 Jnz @1
 Mov al,ah
  Or  al,$80
@1:
end;

{------------------cpu identifing routines--------------------}

Function WhatCPU:Word;  Assembler;

  Asm  { Function WhatCPU }
    MOV     DX,Cpu8086
    PUSH    SP
    POP     AX
    CMP     SP,AX
    JNE     @OUT
    MOV     DX,Cpu80286
    PUSHF
    POP     AX
    Or      AX,4000h
    PUSH    AX
    POPF
    PUSHF
    POP     AX
    Test    AX,4000h
    JE      @OUT
    MOV     DX,Cpu80386     {"DB 66h" makes '386 extended instruction }
    DB 66h; MOV BX,SP       { MOV EBX,ESP }
    DB 66h, 83h, 0E4h, 0FCh { AND ESP,FFFC }
    DB 66h; PUSHF           { PUSHFD }
    DB 66h; POP AX          { POP EAX }
    DB 66h; MOV CX, AX      { MOV ECX,EAX }
    DB 66h, 35h, 00h
    DB 00h, 04h, 00         { XOR EAX,00040000 }
    DB 66h; PUSH AX         { PUSH EAX }
    DB 66h; POPF            { POPFD }
    DB 66h; PUSHF           { PUSHFD }
    DB 66h; POP AX          { POP EAX }
    DB 66h, 25h,00h
    DB 00h, 04h,00h         { AND EAX,00040000 }
    DB 66h, 81h,0E1h,00h
    DB 00h, 04h,00h         { AND ECX,00040000 }
    DB 66h; CMP AX,CX       { CMP EAX,ECX }
    JE @Not486
    MOV DX, Cpu80486
    @Not486:
    DB 66h; PUSH CX         { PUSH ECX }
    DB 66h; POPF            { POPFD }
    DB 66h; MOV SP, BX      { MOV ESP,EBX }
    @Out:
    MOV AX, DX
  End;        { Function WhatCPU }

Procedure CPUSpd(Var MHz, KHz:  Word);

Const
  Processor_cycles: Array[0..4] Of Byte = (165, 165, 25, 103, 42);
  {Cycle times of 8086, 80186, 80286, 80386, 80486}

  {
  Notice that here I have defined the 8086 as a Processor type of 0 vice
  the returned value of 1 from WhatCPU.  Since the original code did not
  distinguish between the 8086 and the 80186, I can get away with this.
  }
  
Var
  Ticks,
  Cycles,
  CPS:                                                                                LongInt;
  Which_CPU:Word;

Function i86_to_i286:Word;Assembler;

  Asm { Function i86_to_i286 }
    CLI
    MOV   CX,1234
    XOr   DX,DX
    XOr   AX,AX
    MOV   AL,$B8
    OUT   $43,AL
    In    AL,$61
    Or    AL,1
    OUT   $61,AL
    XOr   AL,AL
    OUT   $42,AL
    OUT   $42,AL
    XOr   AX,AX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    IDIV  CX
    In    AL,$42
    MOV   AH,AL
    In    AL,$42
    XCHG  AL,AH
    NEG   AX
    STI
  End;  { Function i86_to_i286 }

Function i386_to_i486:Word;Assembler;

  Asm  { Function i386_to_i486 }
    CLI
    MOV   AL,$B8
    OUT   $43,AL
    In    AL,$61
    Or    AL,1
    OUT   $61,AL
    XOr   AL,AL
    OUT   $42,AL
    OUT   $42,AL
    DB 66H,$B8,00h,00h,00h,80h;
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    DB 66H,0FH,$BC,$C8; { BSF ECX,EAX }
    In    AL,42H
    MOV   AH,AL
    In    AL,42H
    XCHG  AL,AH
    NEG   AX
    STI
  End;  { Function i386_to_486 }

Begin  { Procedure CPUSpd }
  Which_CPU := WhatCPU;
  If Which_cpu < 3
  Then Ticks := i86_to_i286
  Else Ticks := i386_to_i486;
  Cycles := 20 * Processor_cycles[Which_CPU];
  CPS := (Cycles * 119318) Div Ticks;
  MHz := CPS Div 100000;
  KHz := (CPS Mod 100000 + 500) Div 1000
End;  { Procedure CPUSpd }

{--------------------video identifing routines--------------------}

Function whatvsystem:vsystem;

Const
  hcrt=$3b4;

Var
  rr:Registers;
  ts:vsystem;

Function find6845(Addr:Word):Boolean; (* TRUE IF 6845 *)
  Var
    tmp:Byte;
  Begin
    port[Addr]:=$F;
    tmp:=port[Addr+1];
    port[Addr+1]:=$66;
    Delay(150);
    find6845:=port[Addr+1]=$66;
    port[Addr+1]:=tmp;
  End;

  Function findmono:vsystem;
  Var
    cnt:Word;
    tmp1,tmp2:Byte;
  Begin
    If find6845(hcrt) Then
    Begin
      tmp1:=port[hcrt+6] And $80;
      Repeat
        tmp2:=port[hcrt+6] And $80;
      Until tmp1<>tmp2;
      If tmp1<>tmp2 Then findmono:=HERC
      Else findmono:=MONO;
    End
    Else (* Not Mono *)
      findmono:=OTHER;
  End;

  Function findCGA:vsystem;
  Begin
    If find6845($3D4) Then findCGA:=CGA
    Else findCGA:=OTHER;
  End;

  Function findEGA:vsystem;
  Begin
    rr.BX:=$0010;
    rr.AX:=$1200;
    Intr($10,rr);
    If Lo(rr.BX)<>$10 Then
    Begin
      Case Lo(rr.CL) Div 2 Of
        0,3:findEGA:=CGA;
        1,4:findEGA:=EGA;
        2,5:findEGA:=Herc;
      End
    End
    Else (* No ega *)
      findEGA:=OTHER;
  End;

  Function findPS2:vsystem;
  Begin
    rr.AX:=$1A00;
    Intr($10,rr);
    If Lo(rr.AX)=$1A Then
    Begin
      Case Lo(rr.BX) Of
        0,3,6,9:findPS2:=other;
        1:findPS2:=MONO;
        2:findPS2:=CGA;
        4,10:findPS2:=EGA;
        5:findPS2:=HERC;
        7,8:findPS2:=VGA;
        11,12:findPS2:=MCGA;
      End
    End
    Else
      findPS2:=OTHER;
  End;

Begin
  ts:=findPS2;
  If ts=other Then
    ts:=findEGA;
  If ts=other Then
    ts:=findmono;
  If ts=other Then
    ts:=findCGA;
  whatvsystem:=ts;
End; {whatvsystem}

{--------------------program flow----------------------}

Procedure init_8086;
const
  outname='results.txt';
Begin
  WaitForFloppy;
  writeln;
  WriteLn('TEST8086.EXE -- Verifies a computer''s configuration suitable for 8086 compo.');
  writeln('Written by Trixter / Hornet (Jim Leonard) on 10/10/95');
  writeln;
  write('Send results to file "',outname,'"? ');
  if upcase(readkey) = 'Y'
    then begin
      assign(output,outname);
      rewrite(output);
    end;
  writeln;
End;

Function test_8086:Boolean;

  {---------------------------------}
  Function testcpu:Boolean;

  const
    ThisIs='This CPU seems to be an ';

  Begin
    Write('Checking CPU type...  ');
    Case whatcpu Of
      1:write(ThisIs,'8086');
      2:write(ThisIs,'80286');
      3:write(ThisIs,'80386');
      4:write(ThisIs,'80486 or higher');
      Else
        Write('I can''t tell what CPU this is.');
    End;
    WriteLn('.');
    If (whatcpu>1)
      Then testcpu:=False
      Else testcpu:=True;
  End;
  {---------------------------------}
  Function testvideo:Boolean;
  Var
    vidcard:vsystem;
  Begin
    Write('Checking video...     ');
    vidcard:=whatvsystem;
    WriteLn('Video looks like a ',vidnames[vidcard],'.');
    If vidcard<>CGA
      Then testvideo:=False
      Else testvideo:=True;
  End;
  {---------------------------------}
  Function testspeed:Boolean;
  Var
    MHz,KHz:Word;
  Begin
    Write('Checking CPU speed... ');
    CpuSpd(MHz, KHz);
    WriteLn('This CPU is running at about ', MHz, '.', KHz, ' MHz.');
    If MHz>6
      Then testspeed:=False
      Else testspeed:=True;
  End;

var
  result:byte;

Begin
  result:=byte(TestVideo) and byte(TestSpeed) and byte(TestCPU);
  if result=1
    Then test_8086:=True
    Else test_8086:=False;
  close(output);
  assign(output,'');
  rewrite(output);
  writeln;
End;

Procedure done_8086;
Begin
  writeln;
  writeln('Contact trixter@ftp.cdrom.com if you have any problems or questions.');
End;

Begin
  Init_8086;
  If test_8086
    Then WriteLn('Congratulations!  This machine is',m1)
    Else Begin
      WriteLn('I''m sorry, but this machine is NOT',m1);
      WriteLn('The MAXIMUM requirements are:  An 8086 or 8088 running at 4.77 MHz with CGA.');
    End;
  done_8086;
End.
