DEFSNG A-Z

'$DYNAMIC

'**** check the command line ****
IF COMMAND$ = "" THEN
    PRINT "Name of TGA file to calculate for should be specified on command line"
    END
END IF
ON ERROR GOTO ErrorTrap
ErrorFlag = 0
OPEN COMMAND$ FOR INPUT AS #1: CLOSE #1
IF ErrorFlag THEN
    PRINT "Filename specified does not exist."
    END
END IF
ON ERROR GOTO 0

'**** determine the dimensions of the TGA file ****
OPEN COMMAND$ FOR BINARY AS #1
A$ = "  ": GET #1, 1 + &HC, A$: MapWidth = CVI(A$)
A$ = "  ": GET #1, 1 + &HE, A$: MapHeight = CVI(A$)
CLOSE #1

'**** other initialization ****
CONST Filename$ = "SPHERE.INC"
CONST PI = 3.141593
CONST YAspect = 7 / 8
SphereHeight = MapHeight
Radius = (SphereHeight / YAspect! - 1) / 2
SphereWidth = (Radius * 2 + 1)
IF Radius < 50 THEN StepRate = 1 ELSE StepRate = .5
DIM SphereArray(1 TO SphereHeight, 1 TO SphereWidth) AS INTEGER

'**** initialize the screen ****
'SCREEN 13
PRINT "Width of image is"; MapWidth
PRINT "Height of image is"; MapHeight

'**** actually calculate the sphere ****
'draws our sphere using the 2 angles THETA and NAUGHT, oh..get a
'calculus or a geometry book for this....I have to do pi/180 to turn my
'angle into radians (I don't think in radians)
FOR Angle = 90 TO 0 STEP -StepRate
    FOR Theta = -Angle TO Angle STEP 2 * Angle
        FOR Naught = 10 TO 170 STEP StepRate
            X = Radius * SIN(Naught * (PI / 180)) * SIN(Theta * (PI / 180))
            Y = Radius * COS(Naught * (PI / 180))

            'PSET (X + 160, Y * YAspect + 100), Theta + 90
            SphereArray(INT(Y * YAspect + 1 + SphereHeight / 2), INT(X + 1 + SphereWidth / 2)) = Theta + 90
        NEXT Naught
        IF Angle = 0 THEN EXIT FOR
    NEXT Theta
    LOCATE , 1: PRINT USING "Calculating... ### percent complete"; (90 - Angle) * 100 \ 90;
NEXT Angle
PRINT

'**** write our calculations to a file ****
PRINT "Saving calculations...  ";
OPEN "SPHERE.INC" FOR OUTPUT AS #1
PRINT #1, "MapWidth = "; INT(MapWidth)
PRINT #1, "MapHeight = "; INT(MapHeight)
PRINT #1, "SphereWidth = "; INT(SphereWidth)
PRINT #1, "SphereHeight = "; INT(SphereHeight)
PRINT #1, "label SphereData byte"
FOR Row = 1 TO SphereHeight
    Count = 0
    FOR Column = 1 TO SphereWidth
        IF Count = 0 THEN
            PRINT #1, "db ";
        ELSE
            PRINT #1, ",";
        END IF
        PRINT #1, LTRIM$(RTRIM$(STR$(SphereArray(Row, Column))));
        Count = Count + 1
    NEXT Column
    IF Count <> 0 THEN PRINT #1,
NEXT Row
CLOSE #1
PRINT "done"

'SCREEN 0: WIDTH 80, 25
END

'**** a simple error handler that ignores errors ***
ErrorTrap: ErrorFlag = 1: RESUME NEXT

