DEFSNG A-Z

CONST FALSE = 0
CONST TRUE = NOT FALSE

INPUT "Height of fall in pixels [200]  ", Height
INPUT "Acceleration of gravity in pixels/second [9.8]  ", PelPerSec
INPUT "Frame rate in cycles per second [60]  ", FrameRate
INPUT "Surface absorption factor [.8]  ", SAF
PRINT
INPUT "Filename to write computations [FREEFALL.INC]  ", Filename$
INPUT "Identifier to use for include file [FreeFallData]  ", Identifier$

'this transformation changes the computed height values (from the ground)
'from "0 to Height" (0 meaning touching the ground) to whatever values are
'needed.  in this case, we need to change the rows to buffer offsets for
'mode X, but if you need values measured from the initial position, you
'could use "DEF fnTransformation (x) = Height - x"
DEF fnTransformation (x) = INT(x + .5) * (320 / 4)

Acceleration = PelPerSec / FrameRate
CurrentVelocity = 0
CurrentHeight = Height
BounceFlag = FALSE

OPEN Filename$ FOR OUTPUT AS #1
PRINT #1, "label", Identifier$, "word"
PRINT #1, "dw", LTRIM$(RTRIM$(STR$(INT(fnTransformation(CurrentHeight)))));
ItemCount = 1
DO
    IF ItemCount = 0 THEN PRINT #1, "dw", ;  ELSE PRINT #1, ",";

    CurrentVelocity = CurrentVelocity + Acceleration
    DeltaHeight = (CurrentVelocity / Acceleration - 1 + .5) * Acceleration
    CurrentHeight = CurrentHeight - DeltaHeight
    IF CurrentHeight <= 0 THEN
        CurrentVelocity = -CurrentVelocity * SAF
        IF BounceFlag = TRUE THEN EXIT DO
        BounceFlag = TRUE

        PRINT #1, LTRIM$(RTRIM$(STR$(INT(fnTransformation(0)))));
        ItemCount = ItemCount + 1
    ELSE
        BounceFlag = FALSE

        PRINT #1, LTRIM$(RTRIM$(STR$(INT(fnTransformation(CurrentHeight)))));
        ItemCount = ItemCount + 1
    END IF

    IF ItemCount = 15 THEN PRINT #1, : ItemCount = 0
LOOP
PRINT #1, "-1"
CLOSE #1

