.386
ideal
locals
jumps
model huge
stack 100h

LoopDemo = 0            ;set to 1 to loop the text, 0 to quit upon end
XOffset = 95
YOffset = 53
Scr_Width = 320
Scr_Height = 200
Flame_Width = 140
Flame_Height = 95

struc   Flake
        Xpos        dd ?
        Ypos        dd ?
        Xmovement   dd ?
        Ymovement   dd ?
        Position    dw ?        ;rounded screen offset of position
        OldPixel    db 0
        OldPosition dw 0FFFFh
ends    Flake

macro       absolute a,b        ;returns in AX the absolute value of (a - b)
            mov ax,a
            sub ax,b
            cwd
            xor ax,dx
            sub ax,dx
endm        absolute

macro       CenterString padlength,stringtext
            stringlength sizestr <stringtext>
            errif (stringlength-2) gt (padlength) "String too long"
            padwidth = ((padlength)-(stringlength-2))/2
            if (padwidth) ge 1
                db (padwidth) dup (' ')
            endif
            db stringtext
            padwidth = (padlength-((stringlength-2)+padwidth))
            if (padwidth) ge 1
                db (padwidth) dup (' ')
            endif
endm


segment Code
        assume cs:Code
;
include         "treefnt.dmp"
include         "treesnow.inc"
include         "palette.inc"
                                ;1234567890123456789012345678901234567890
label           Message_Text byte   
                CenterString 40,"Hi there!  This is my very first demo"
                CenterString 40,"and I'm actually surprised that it runs!"
                CenterString 40,"- - - - -"
                CenterString 40,"Yeah, I know this doesn't really look"
                CenterString 40,"like much, but it was interesting to"
                CenterString 40,"program because each snow flake has"
                CenterString 40,"16.16 fixed point precision for both"
                CenterString 40,"its position and velocity and it gave"
                CenterString 40,"me a chance to program something of my"
                CenterString 40,"own that used the 32-bit registers."
                CenterString 40,"- - - - -"
                CenterString 40,"Well, let's wrap up this part and go"
                CenterString 40,"on to the next..."
                CenterString 40,"- - - - -"
                db  0
Message_Ptr     dw  ?,?
Message_Column  dw  0
Message_Pos     dw  (Scr_Height-16)*Scr_Width,0A000h
CurPalette      db 256 dup (0,0,0)
;
proc    Start
        cld

        ;switch over to graphics mode
        mov ax,0013h
        int 10h

        ;display the black palette
        mov ax,cs
        mov ds,ax
        mov si,offset CurPalette
        xor al,al
        mov cx,256
        @WritePalette

        ;initialize some stuff for the scrolly
        mov [word cs:Message_Ptr+0],offset Message_Text
        mov [word cs:Message_Ptr+2],cs
        mov [cs:Message_Column],0

        ;load in a pretty picture to look at
        call LoadTGA
        call DisplaySnow

        ;Fade in to the current palette (Fade in updates snow too)
        call FadeIn

@@MainLoop:
        call UpdateSnow

        mov dx,[cs:Message_Column]
        and dx,1111111b
        absolute dx,64
        inc ax
        mov dh,al
        lds si,[dword cs:Message_Ptr]
        mov cx,[cs:Message_Column]
        les di,[dword cs:Message_Pos]
        call DisplayColOfText
        inc [cs:Message_Column]
        cmp [cs:Message_Column],Scr_Width
        jnz @@NoNewText
        mov [cs:Message_Column],0
        lds si,[dword cs:Message_Ptr]
        add si,(Scr_Width/8)
        cmp [byte ds:si],0
        jnz @@GotNewText
        if LoopDemo eq 0
            jmp @@AllDone
        else
            mov si,offset Message_Text
        endif
@@GotNewText:
        mov [word cs:Message_Ptr+0],si
        mov [word cs:Message_Ptr+2],ds
@@NoNewText:

        ;wait for a retrace to complete (for timing)
        mov dx,3dah
@@ras1: in al,dx
        test al,8
        jnz @@ras1
@@ras2: in al,dx
        test al,8
        jz @@ras2

        ;get stdio.  If something's been pressed, quit
        mov ah,6
        mov dl,0FFh
        int 21h
        jz @@MainLoop

@@AllDone:
        ;fade the screen out to black
        call fade_out

        ;change back to text mode and quit
        ;mov ax,0003h
        ;int 10h
        mov ax,4C00h
        int 21h
endp    Start
;
proc        FadeIn
            ;**** converge the current palette to the desired one ****
            mov ax,cs
            mov es,ax
            mov di,offset CurPalette    ;ES:DI ==> current palette

            mov ax,Picture
            mov ds,ax
            mov si,offset TREE+18       ;DS:SI ==> desired palette
            
            cld
            mov cx,256*3
            xor bx,bx
@@NextColor:lodsb
            cmp [byte es:di],al
            jz @@ColorDone
            jb @@Increment
@@Decrement:dec [byte es:di]
            inc bx
            jmp @@ColorDone
@@Increment:inc [byte es:di]
            inc bx
@@ColorDone:inc di
            dec cx
            jnz @@NextColor
            cmp bx,0
            jz @@Done

            ;**** load in the new palette ****
            mov ax,cs
            mov ds,ax
            mov si,offset CurPalette
            mov cx,256
            xor al,al
            @WritePalette

            ;**** wait for a vertical retrace (for timing) ****
            mov cx,3
@@Delay:    push cx
            call UpdateSnow
            pop cx
            mov dx,3dah
@@ras1:     in al,dx
            test al,8
            jnz @@ras1
@@ras2:     in al,dx
            test al,8
            jz @@ras2
            dec cx
            jnz @@Delay

            jmp FadeIn
@@Done:     ret
endp        FadeIn
;
;display the stars on top of the backdrop without erasure of old ones
proc    DisplaySnow
        mov ax,cs
        mov ds,ax
        mov ax,0A000h
        mov es,ax
        ;------------------------------------
        mov si,offset TheSnowFlakes
        mov cx,TotalSnowFlakes
@@GetOldPixels:
        mov ax,[word ds:si+2+Flake.YPos]    ;\
        mov dx,Scr_Width                    ; \
        mul dx                              ;  \ convert the position
        add ax,[word ds:si+2+Flake.XPos]    ;  / to a screen offset
        mov di,ax                           ; /
        mov [ds:si+Flake.Position],di       ;/
        mov al,[es:di]                      ;get the old pixel's color
        mov [ds:si+Flake.OldPixel],al       ;save the old pixel's color
        mov [ds:si+Flake.OldPosition],di    ;save the old pixel's position
        add si,size Flake
        dec cx
        jnz @@GetOldPixels
        ;------------------------------------
        mov si,offset TheSnowFlakes
        mov cx,TotalSnowFlakes
@@DrawFlake:
        mov di,[ds:si+Flake.Position]       ;\
        cmp di,(Scr_Height-16)*Scr_Width    ; \
        ja @@DontDraw                       ;  > plot the current position
        mov [byte es:di],255                ; /
@@DontDraw:                                 ;/
        mov eax,[ds:si+Flake.Xpos]          ;\
        add eax,[ds:si+Flake.Xmovement]     ; \
IFDEF WRAPX
        cmp eax,Scr_Width*10000h            ;  \
        jb @@Xokay                          ;   \ update position
        sub eax,Scr_Width*10000h            ;   /
ENDIF
@@Xokay:mov [ds:si+Flake.Xpos],eax          ;  /
        mov eax,[ds:si+Flake.Ymovement]     ; /
        add [ds:si+Flake.Ypos],eax          ;/
        add si,size Flake
        dec cx
        jnz @@DrawFlake
        ;------------------------------------
        ret
endp    DisplaySnow
;
;display the stars on top of the backdrop, and erase the old ones
proc    UpdateSnow
        mov ax,cs
        mov ds,ax
        mov ax,0A000h
        mov es,ax
        ;------------------------------------
        mov si,offset TheSnowFlakes
        mov cx,TotalSnowFlakes
@@RestoreScreen:
        mov di,[ds:si+Flake.OldPosition]    ;\
        cmp di,(Scr_Height-16)*Scr_Width    ; \
        ja @@DontErase                      ;  > restore the old pixel
        mov al,[ds:si+Flake.OldPixel]       ; /
        mov [es:di],al                      ;/
@@DontErase:
        add si,size Flake
        dec cx
        jnz @@RestoreScreen
        ;------------------------------------
        mov si,offset TheSnowFlakes
        mov cx,TotalSnowFlakes
@@GetOldPixels:
        mov ax,[word ds:si+2+Flake.YPos]    ;\
        mov dx,Scr_Width                    ; \
        mul dx                              ;  \ convert the position
        add ax,[word ds:si+2+Flake.XPos]    ;  / to a screen offset
        mov di,ax                           ; /
        mov [ds:si+Flake.Position],di       ;/
        mov al,[es:di]                      ;get the old pixel's color
        mov [ds:si+Flake.OldPixel],al       ;save the old pixel's color
        mov [ds:si+Flake.OldPosition],di    ;save the old pixel's position
        add si,size Flake
        dec cx
        jnz @@GetOldPixels
        ;------------------------------------
        mov si,offset TheSnowFlakes
        mov cx,TotalSnowFlakes
@@DrawFlake:
        mov di,[ds:si+Flake.Position]       ;\
        cmp di,(Scr_Height-16)*Scr_Width    ; \
        ja @@DontDraw                       ;  > plot the current position
        mov [byte es:di],255                ; /
@@DontDraw:                                 ;/
        mov eax,[ds:si+Flake.Xpos]          ;\
        add eax,[ds:si+Flake.Xmovement]     ; \
IFDEF WRAPX
        cmp eax,Scr_Width*10000h            ;  \
        jb @@Xokay                          ;   \ update position
        sub eax,Scr_Width*10000h            ;   /
ENDIF
@@Xokay:mov [ds:si+Flake.Xpos],eax          ;  /
        mov eax,[ds:si+Flake.Ymovement]     ; /
        add [ds:si+Flake.Ypos],eax          ;/
        add si,size Flake
        dec cx
        jnz @@DrawFlake
        ;------------------------------------
        ret
endp    UpdateSnow
;
;load a TGA and display it
proc    LoadTGA
        push ds

        mov ax,Picture
        mov ds,ax
        mov es,ax
        mov si,offset TREE+18
        mov di,offset TREE+18
        mov cx,256
        cld
@@FixPal:
        lodsb           ;\
        shr al,2        ; > load in Blue component
        mov ah,al       ;/
        lodsb           ;\
        shr al,2        ; > load in Green component
        mov bh,al       ;/
        lodsb           ;\ load in Red component
        shr al,2        ;/
        stosb           ;write out Red
        mov al,bh       ;\ write out Green
        stosb           ;/
        mov al,ah       ;\ write out Blue
        stosb           ;/
        dec cx
        jnz @@FixPal

        ;mov ax,1012h
        ;mov bx,0
        ;mov cx,256
        ;mov dx,offset TREE+18
        ;int 10h

        mov ax,0A000h
        mov es,ax
        xor di,di
        mov si,offset TREE+18+768
        cld
        mov cx,64000
        rep movsb

        pop ds
        ret
endp    LoadTGA
;
;       DH = color to print in (0 to 255)
;       DS:SI ==> message to print
;       CX = column number to display (0 to 319)
;       ES:DI ==> offset to start display
proc    DisplayColOfText
        mov bx,cx               ;\
        shr bx,3                ; > current letter being drawn
        add si,bx               ;/
        add di,cx               ;ES:DI ==> correct position of this column
        and cx,7                ;\
        neg cx                  ; > CL = number of places to shift
        add cx,7                ;/
        mov bl,[byte ds:si]         ;\
        xor bh,bh                   ; \ BX ==> font data for this letter
        shl bx,4                    ; /
        add bx,offset Font_buffer   ;/
        mov dl,16                   ;DL = number of rows to print
@@DisplayChar:
        mov al,[byte ds:bx]
        shr al,cl
        and al,1
        jz @@Nothing
@@Something:
        mov [byte es:di],dh
        jmp @@Next
@@Nothing:
        mov [byte es:di],0
@@Next:
        add di,Scr_Width
        inc bx
        dec dl
        jnz @@DisplayChar

        ret
endp    DisplayColOfText
;
ends    Code

segment Picture
include "treetga.dmp"
ends    Picture

        end     Start
