;
;  USKY.ASM  //  ARM 12/93
;

        Ideal
        Model TPascal
        P286
        Radix 10

; Constants:

INCLUDE "meshsize.inc"

        DATASEG

EXTRN   B      : DWord
EXTRN   TOPS   : Word
EXTRN   FONT   : Byte

        CODESEG

PUBLIC SkyPutPixel   ; ( X, Y : integer; C : Byte )
PUBLIC SkyWriteCh    ; ( X, Y : integer; cc : char; col : byte )
PUBLIC SkyCursor     ; ( X, Y : integer; col : byte )

; // SkyPutPixel : draws water surface in fake 3D
;

LABEL TTable NEAR
    Y = 0
    rept 200-NY+1
      dw Y*320
      Y = Y + 1
    endm

       PROC SkyPutPixel NEAR
       ARG X : Word, Y : Word, C : Byte
         mov cl, [C]

         mov bx, [Y]
         shl bx, 1
         mov bx, [cs:(offset TTable)+bx]
         add bx, [X]

         mov ax, [word ptr B+2]
         mov es, ax
         mov [es:bx],cl

         mov si, [X]
         and si, not 1
         mov si, [offset TOPS + si]
;?       add si, 320
         cmp bx, si
         ja @@1
         mov ax, 0a000h
         mov es, ax
         mov [es:bx], cl
       @@1:
       ret
       ENDP



; // SkyWriteCh : writes a char on sky, behind water
;

       PROC SkyWriteCh NEAR
       ARG X : Word, Y : Word, CC : Byte, COL : Byte
P386
           mov al, [CC]
           xor ah,ah
           shl ax, 4
           add ax, offset FONT
           mov si, ax             ; cs:si -> FONT+16*ch

           mov ax, 0a000h
           mov es, ax
           mov di, [Y]
           shl di, 1
           mov di, [cs:(offset TTable)+di]
           add di, [X]            ; es:di -> screen

           mov ax, [word ptr B+2]
           mov fs, ax             ; fs:di -> B

           mov bx, [X]
           and bx, not 1
           add bx, offset TOPS    ; ds:bx -> TOPS[X]


           mov dl, [COL]          ; dl = ink color
           mov dh, [byte ptr Y]
           inc dh                 ; dh = paper color
           mov cx, 16

         @@1:
           mov al, [cs:si]
           inc si

           push cx
           mov cx, 8

          @@bits:
           shl al,1

           mov ah, dl        ; foreground
           jc @@2
           mov ah, dh        ; background
           @@2:

           mov [fs:di], ah

           cmp di, [bx]
           ja @@3
           mov [es:di], ah
         @@3:

           add bx,2
           add di,2
           dec cx
           jnz @@bits

           pop cx

           sub bx, 16        ; back 8 surf columns for TOPS
           add dx, 0201h     ; update both fore and background
           add di, 320*2-16  ; two lines ahead, one char back
           dec cx
           jnz @@1
P286
       ret
       ENDP

; // SkyCursor : writes a char
;

       PROC SkyCursor NEAR
       ARG X : Word, Y : Word, COL : Byte
P386
         mov ax, 0a000h
         mov es, ax
         mov ax, [word ptr B+2]
         mov fs, ax

         mov dl, [COL]
         mov dh, [byte ptr Y]
         inc dh
         mov di, 0201h
         or dl, dl
         jnz @@0
         mov dl, dh                      ; col = 0 to print blank space
         mov di, 0202h
        @@0:


         mov bx, [Y]
         shl bx, 1
         mov bx, [cs:(offset TTable)+bx]  ; es:bx -> screeen
         add bx, [X]                     ; fs:bx -> B


         mov si, [X]
         and si, not 1
         add si, offset TOPS             ; SI -> TOPS

         mov cx, 16
      @@Y:
         push bx cx si
         mov cx, 8
      @@X:
         mov [fs:bx],dx                  ; unconditional to B
         mov ax, [si]
         cmp bx, ax
         ja @@1
         mov [es:bx], dx                 ; to screen if not covered
       @@1:
         add si, 2
         add bx, 2
         dec cx
         jnz @@X
         pop si cx bx
         add dx, di
         add bx, 640
         dec cx
         jnz @@Y

P286
       ret
       ENDP


       END

