{$G+}
{$M 32000,0,655360}
(* Full 320x200 screen rotation & scaling (C) '95 By Paradise *)

Unit Rotate;

Interface

 Procedure Rotate_Init;
 Procedure Rotate_Setup(NSteps : Word);
 Procedure Rotate_Run;
 Procedure Rotate_Done;

Implementation

Uses Crt, Vga, FP, TPUnpack, DAC;

Var
 Time                            : Longint absolute $0000:$046c;
 TimeStart, TimeEnd, Frames      : LongInt;
 I, Degree, Scale, Direction     : Integer;
 FScale, FDirection              : LongInt;
 BigSpr                          : Pointer;
 IncX, IncY                      : Integer;
 PosX, PosY                      : Integer;
 Step, Steps                     : LongInt;
 ZeroPal, LiPal                  : Array [0..255,1..3] of Byte;

Procedure Texture; Assembler;
Asm
   cld
   mov ax,-160
   imul incx
   mov posx,ax
   mov ax,-100
   imul incy
   mov posy,ax
   mov ax,0A000h
   mov es,ax
   mov ax,word ptr [BigSpr+2]
   db  $8e,$e8 {mov gs,ax}
   mov cx, 200
@scanline:
   push cx
   mov ax,cx
   xchg al,ah
   mov di,ax
   shr di,2
   add di,ax
   mov ax,incx
   db 66h; shl ax,16
   mov ax,incy
   db 66h; mov si,ax
   mov dx,posx
   db 66h; shl dx,16
   mov dx,posy
   mov cx,160
@innerloop:
   db 66h; add dx,si
   db 66h; mov bx,dx
   db 66h; shr bx,16
   mov bl,dh
   db $65,$8a,$7; {mov al,[bx]}
   db 66h; add dx,si
   db 66h; mov bx,dx
   db 66h; shr bx,16
   mov bl,dh
   db $65,$8a,$27; {mov ah,[bx]}
   stosw
   dec cx
   jnz @innerloop
   mov ax,incy
   add posx,ax
   mov ax,incx
   neg ax
   add posy,ax
   pop cx
   dec cx
   jnz @scanline
End;


{$L LiP.Obj}
{$L Li1.Obj}
{$L Li2.Obj}
Procedure LiPalette; External;
Procedure UnpackLi1(Var Buffer); Far; External;
Procedure UnpackLi2(Var Buffer); Far; External;

Procedure LoadSprite;
Begin
 UnpackLi1(BigSpr^);
 UnpackLi2(Ptr(Seg(BigSpr^),Ofs(BigSpr^)+32768)^);
 Move(@LiPalette^,LiPal,768);
End;

Var
 TrackX, TrackY : Array [0..360] of LongInt;

Procedure Rotate_Init;
Begin
 FillChar(ZeroPal,768,0);
 GetMem(BigSpr,65535);
 FillChar(BigSpr^,65535,0);
 LoadSprite;
 Degree:=0; Direction:=8; Scale:=180;
 FDirection:=I2L(Direction); FScale:=I2L(Scale);
 For I:=0 to 360 do
 Begin
  TrackX[I]:=LongInt(Round( Cos(I/180*Pi*2) *65536));
  TrackY[I]:=LongInt(Round( Sin(I/180*Pi)   *65536));
 End;
 Step:=0; Steps:=300;
End;

Procedure Rotate_Setup(NSteps : Word);
Begin
 Steps:=NSteps;
End;

Procedure Rotate_Run;
Begin
 DAC_SetPalette(@ZeroPal);
 DAC_SetFading(@ZeroPal,@LiPal,20);
 While Step<Steps do
 Begin
  DAC_UpdateFading;
  IncX:=FixedMul(TrackX[Degree], FScale) shr 16;
  IncY:=FixedMul(TrackY[Degree], FScale) shr 16;
  Texture;
  Inc(Degree,2);
  Inc(Scale,Direction);
  Inc(FScale,FDirection);
  If (Degree>=360) then Degree:=Degree-360;
  If (Scale>600) or (Scale<160) then
  Begin
   Direction:=-Direction;
   FDirection:=-FDirection;
  End;
  Inc(Step);
  If Step=Steps-20 then
  Begin
   DAC_SetFading(@LiPal,@ZeroPal,20);
  End;
 End;
End;

Procedure Rotate_Done;
Begin
 FreeMem(BigSpr,65535);
End;

End.

