{$M 32000,0,655360}
{$G+,N+}

(* CHROME ENV MAPPING (C) '95 By Paradise *)

Unit Chrome;

Interface

 Procedure Chrome_Init;
 Procedure Chrome_Run;
 Procedure Chrome_Done;

Implementation

Uses Crt, Vga, Math, TFont, TPUnpack;

Const
 MaxP                    = 144;
 MaxL                    = 256;
 NumP                    = 144;
 NumL                    = 256;
 Light                   : Vector = (0, 0, 65536);

Type
 PNormalsTab             = ^TNormalsTab;
 TNormalsTab             = Array [1..MaxL] of Vector;

Var
 Time                    : Longint absolute $0000:$046c;
 RPoints, Points         : Array [1..MaxP] of Vector;
 ScreenP                 : Array [1..MaxP] of Wsp;
 Polys                   : Array [1..MaxL,1..3] of Integer;
 Lista                   : Array [1..MaxL] of Integer;
 ZTab                    : Array [1..MaxL] of Fixed32;
 RNormals1, Normals1,
 RNormals2, Normals2,
 RNormals3, Normals3     : PNormalsTab;
 Count                   : Integer;
 Frames, STime, ETime    : LongInt;
 Mapping                 : Pointer;
 ChPal,ZeroPal           : Array [0..255,1..3] of Byte;

(****************************************************************************)
(****************************************************************************)
(****************************************************************************)

Var
 ScanLines  : Array [0..199] of Record
                                 StartX, EndX : Integer;
                                 LNx, LNy,
                                 PNx, PNy     : Fixed32;
                                End;

Procedure SwapInt(Var A,B: Integer);
Var T : Integer;
Begin
 T:=A; A:=B; B:=T;
End;

Procedure SwapFixed(Var A,B: Fixed32);
Var T : Fixed32;
Begin
 T:=A; A:=B; B:=T;
End;

Procedure ScanEdge(X1,Y1,X2,Y2: Integer; N1,N2 : Vector);
Var
 i : Integer;
 XLen, YLen, XPos, XInc : Fixed32;
 Nx, Ny, NxInc, NyInc : Fixed32;
Begin
 If Y2<Y1 then
 Begin
  SwapInt(X2,X1);
  SwapInt(Y2,Y1);
  SwapFixed(N1[0],N2[0]);
  SwapFixed(N1[1],N2[1]);
 End;
 XLen:=INT_TO_FIXED(X2-X1);
 YLen:=INT_TO_FIXED(Y2-Y1);
 If (YLen=0) then Exit;
 XPos:=INT_TO_FIXED(X1);
 XInc:=FixedDiv(XLen,YLen);
 Nx:=N1[0]; Ny:=N1[1];
 NxInc:=FixedDiv(N2[0]-N1[0], YLen);
 NyInc:=FixedDiv(N2[1]-N1[1], YLen);
 For i:=0 to (Y2-Y1-1) do
 Begin
  Inc(XPos,XInc);
  Inc(Nx,NxInc);
  Inc(Ny,NyInc);
  If (ScanLines[i+Y1].StartX=16000) then
  Begin
   ScanLines[i+Y1].StartX:=FIXED_TO_INT(XPos);
   ScanLines[i+Y1].LNx:=Nx;
   ScanLines[i+Y1].LNy:=Ny;
  End else
  Begin
   ScanLines[i+Y1].EndX:=FIXED_TO_INT(XPos);
   ScanLines[i+Y1].PNx:=Nx;
   ScanLines[i+Y1].PNy:=Ny;
  End;
 End;
End;

Procedure DrawLine(X1,X2,Y : Integer; Nx1,Ny1,Nx2,Ny2 : Fixed32; GSeg : Word);
Var
 Color : Byte;
 Dot, XLen : Fixed32;
 Nx, Ny, NxInc, NyInc : Fixed32;
 mX, mY : Byte;
 Wsp, X : Word;
Begin
 If X2<X1 then
 Begin
  SwapInt(X1,X2);
  SwapFixed(Nx1,Nx2);
  SwapFixed(Ny1,Ny2);
 End;
 XLen:=INT_TO_FIXED(X2-X1);
 If (XLen=0) then Exit;
 Nx:=Nx1; Ny:=Ny1;
 NxInc:=FixedDiv(Nx2-Nx1, XLen);
 NyInc:=FixedDiv(Ny2-Ny1, XLen);
 Wsp:=YOfs[Y]+X1;
 For X:=X1 to X2 do
 Begin
  Inc(Nx,NxInc);
  Inc(Ny,NyInc);
  mX:=(Nx shr 10)+64;
  mY:=(Ny shr 9)+128;
  Color:=Mem[Seg(Mapping^):mY shl 7+mX];
  If Color<15 then Color:=0;
  Mem[GSeg:Wsp]:=Color;
  Inc(Wsp);
 End;
End;

Procedure ClsScanLines; Assembler;
Asm
 xor bx, bx
 mov dx, 16000
 db $66; xor ax, ax
 mov cx, 200
@clearone:
 mov word ptr ScanLines[bx], dx
 mov word ptr ScanLines[bx+2], dx
 db $66; mov word ptr ScanLines[bx+4], ax
 db $66; mov word ptr ScanLines[bx+8], ax
 db $66; mov word ptr ScanLines[bx+12], ax
 db $66; mov word ptr ScanLines[bx+16], ax
 add bx, 20
 dec cx
 jnz @clearone
End;

Procedure Polygon(X1,Y1,X2,Y2,X3,Y3 : Integer; NL : Integer; GSeg : Word);
Var
 i : Integer;
Begin
 ClsScanLines;
 ScanEdge(X1,Y1,X2,Y2,Normals1^[NL],Normals2^[NL]);
 ScanEdge(X2,Y2,X3,Y3,Normals2^[NL],Normals3^[NL]);
 ScanEdge(X3,Y3,X1,Y1,Normals3^[NL],Normals1^[NL]);
 For i:=0 to 199 do
 Begin
  If (ScanLines[i].StartX<>16000){ and (ScanLines[i].EndX<>16000)} then
  Begin
   DrawLine(ScanLines[i].StartX,ScanLines[i].EndX,i,
            ScanLines[i].LNx,ScanLines[i].LNy,
            ScanLines[i].PNx,ScanLines[i].PNy,GSeg);
  End;
 End;
End;

(****************************************************************************)
(****************************************************************************)
(****************************************************************************)
{$L Chrome.Obj}
{$L ChromeP.Obj}
{$L Normals.Obj}
{$L Points.Obj}
{$L Polys.Obj}
Procedure TorusPolys; External;
Procedure TorusPoints; External;
Procedure TorusNormals; External;
Procedure ChromePalette; External;
Procedure UnpackChrome(Var Buffer); Far; External;
(****************************************************************************)

Procedure LoadObject;
Begin
 Move(@TorusPoints^,RPoints,NumP*12);
 Move(@TorusPolys^,Polys,NumL*6);
End;

Procedure QuickSort;
Procedure Sort(L,R : integer);
Var i,j : Integer;
    x,buf : Fixed32;
Begin
 i := L; j := R;
 x := ZTab[Lista[(L+R) div 2]];
 Repeat
  While ZTab[Lista[i]]<x do Inc(i); While x<ZTab[Lista[j]] do Dec(j);
  If i<=j then
  Begin
   buf:=Lista[i];
   Lista[i]:=Lista[j];
   Lista[j]:=buf;
   Inc(i);
   Dec(j);
  End;
 Until (i>j);
 If L<j then Sort (L,j);
 If i<R then Sort (i,R);
End;
Begin
 For Count:=1 to NumL do
 Begin
  Lista[Count]:=Count;
  ZTab[Count]:=(Points[Polys[Count,1],2]+Points[Polys[Count,2],2]+Points[Polys[Count,3],2]) div 3;
 End;
 Sort(1,numL);
End;

Function IsVisible(PolyNum : Integer): Boolean;
Var Dot1,Dot2,Dot3 : Fixed32;
Begin
 Dot1:=DotProduct(Normals1^[PolyNum],Light);
 Dot2:=DotProduct(Normals2^[PolyNum],Light);
 Dot3:=DotProduct(Normals3^[PolyNum],Light);
 IsVisible:=(Dot1>=0) or (Dot2>=0) or (Dot3>=0);
End;

Procedure Draw(GSeg : Word);
Var L : Integer;
Begin
 For Count:=1 to NumL do
 Begin
  L:=Lista[Count];
  If IsVisible(L) then
  Polygon(ScreenP[Polys[L,1],0],ScreenP[Polys[L,1],1],
          ScreenP[Polys[L,2],0],ScreenP[Polys[L,2],1],
          ScreenP[Polys[L,3],0],ScreenP[Polys[L,3],1],L,GSeg);
 End;
End;

Procedure ScaleRPoints(Factor : Real);
Var
 FFactor : Fixed32;
Begin
 FFactor:=DOUBLE_TO_FIXED(Factor);
 For Count:=1 to NumP do
 Begin
  RPoints[Count,0]:=FixedMul(RPoints[Count,0], FFactor);
  RPoints[Count,1]:=FixedMul(RPoints[Count,1], FFactor);
  RPoints[Count,2]:=FixedMul(RPoints[Count,2], FFactor);
 End;
End;

Procedure MoveRPoints(dX, dY, dZ : Integer);
Begin
 For Count:=1 to NumP do
 Begin
  RPoints[Count,0]:=RPoints[Count,0]+INT_TO_FIXED(dX);
  RPoints[Count,1]:=RPoints[Count,1]+INT_TO_FIXED(dY);
  RPoints[Count,2]:=RPoints[Count,2]+INT_TO_FIXED(dZ);
 End;
End;

Procedure SetNormals;
Var
 i : Integer;
 Off : Word;
Begin
 Off:=0;
 GetMem(RNormals1,SizeOf(TNormalsTab)); GetMem(Normals1, SizeOf(TNormalsTab));
 GetMem(RNormals2,SizeOf(TNormalsTab)); GetMem(Normals2, SizeOf(TNormalsTab));
 GetMem(RNormals3,SizeOf(TNormalsTab)); GetMem(Normals3, SizeOf(TNormalsTab));
 For i:=1 to NumL do
 Begin
  Move(Mem[Seg(TorusNormals):Ofs(TorusNormals)+Off], RNormals1^[i], SizeOf(Vector)); Inc(Off, SizeOf(Vector));
  Move(Mem[Seg(TorusNormals):Ofs(TorusNormals)+Off], RNormals2^[i], SizeOf(Vector)); Inc(Off, SizeOf(Vector));
  Move(Mem[Seg(TorusNormals):Ofs(TorusNormals)+Off], RNormals3^[i], SizeOf(Vector)); Inc(Off, SizeOf(Vector));
 End;
End;

Procedure FreeNormals;
Begin
 FreeMem(RNormals1,SizeOf(TNormalsTab));
 FreeMem(Normals1, SizeOf(TNormalsTab));
 FreeMem(RNormals2,SizeOf(TNormalsTab));
 FreeMem(Normals2, SizeOf(TNormalsTab));
 FreeMem(RNormals3,SizeOf(TNormalsTab));
 FreeMem(Normals3, SizeOf(TNormalsTab));
End;

Procedure LoadMapping;
Begin
 UnpackChrome(Mapping^);
 Move(@ChromePalette^,ChPal,768);
 FillChar(ZeroPal,768,0);
End;

Procedure RotateRPoints(xA,yA,zA : Integer);
Begin
 InitRotation(0,0,0,xA,yA,zA);
 UpdateRotation;
 Rotate(RPoints,RPoints,NumP);
 Rotate(RNormals1^,RNormals1^,NumL);
 Rotate(RNormals2^,RNormals2^,NumL);
 Rotate(RNormals3^,RNormals3^,NumL);
End;

Procedure DrawTekst(Num : Byte; GSeg : Word);
Begin
 Case Num of
  1: Begin
      TFont_Print(10,10,'code',GSeg);
      TFont_Print(220,140,'paradise',GSeg);
     End;
  2: Begin
      TFont_Print(10,10,'graphic',GSeg);
      TFont_Print(200,80,'paradise',GSeg);
      TFont_Print(200,120,'ped',GSeg);
      TFont_Print(200,160,'and others',GSeg);
     End;
  3: Begin
      TFont_Print(10,10,'music',GSeg);
      TFont_Print(200,80,'harkonen',GSeg);
      TFont_Print(200,120,'probe',GSeg);
      TFont_Print(200,160,'and others',GSeg);
     End;
  4: Begin
      TFont_Print(10,10,'design',GSeg);
      TFont_Print(220,140,'paradise',GSeg);
     End;
 End;
End;

Procedure Chrome_Init;
Begin
 InitSinCos;
 InitYOfs;
 InitVPage;
 LoadObject;
 SetNormals;
 ScaleRPoints(0.2);
 InitRotation(0,0,0,10,10,5);
 GetMem(Mapping,32768);
 LoadMapping;
 TFont_Init;
 TFont_Setup(0);
 Move(FontPalette,ChPal[0],42);
 SetPalette(@ChPal);
End;

Procedure Chrome_Done;
Begin
 TFont_Done;
 FreeNormals;
 FreeMem(Mapping,32768);
 DoneVPage;
End;

Procedure Chrome_Run;
Begin
 ClearFake($A000);
 SetColor(0,63,63,63);
 Delay(150);
 SetColor(0,0,0,0);
 For Frames:=0 to 39 do
 Begin
  UpdateRotation;
  Rotate(RPoints,Points,NumP);
  Rotate(RNormals1^,Normals1^,NumL);
  Rotate(RNormals2^,Normals2^,NumL);
  Rotate(RNormals3^,Normals3^,NumL);
  Perspective(Points,ScreenP,NumP);
  QuickSort;
  ClearFake(VSeg);
  Draw(VSeg);
  DrawTekst((Frames div 10)+1,VSeg);
  ShowFake(VSeg);
 End;
 ClearFake($A000);
 SetColor(0,63,63,63);
 Delay(150);
 SetColor(0,0,0,0);
End;

End.

