{$M 32000,0,655360}
{$G+,N+}
(* Warping effect (C) 1995 By Paradise *)

Unit Warp;

Interface

 Procedure Warp_Init;
 Procedure Warp_Run;
 Procedure Warp_Done;

Implementation

Uses Crt, Dos, Vga, FP, TPUnpack, DAC;

Const
 MeshX      = 19;
 MeshY      = 19;

Type
 MeshPoint  = Record X, Y : Integer; End;
 MeshIPoint = Record X, Y : LongInt; End;
 MeshArray  = Array [0..MeshY, 0..MeshX] of MeshPoint;
 MeshIArray = Array [0..MeshY, 0..MeshX] of MeshIPoint;

{$I Meshes.Inc}

Var
 WarpPtr    : Pointer;
 WarpSeg    : Word;
 IncMesh    : MeshIArray;
 Mesh       : MeshArray;
 F          : File;
 Frame      : Integer;
 ZeroPal,
 WarpPal    : Array [0..255,1..3] of Byte;

{$I Texture.Inc}

{$L Amber.Obj}
{$L AmberP.Obj}
Procedure AmberPalette; External;
Procedure UnpackAmber(Var Buffer); Far; External;

Procedure WarpInit;
Begin
 GetMem(WarpPtr,64000);
 WarpSeg:=Seg(WarpPtr^);
 UnpackAmber(WarpPtr^);
 Move(@AmberPalette^,WarpPal,768);
 FillChar(ZeroPal,768,0);
End;

Procedure WarpDone;
Begin
 FreeMem(WarpPtr,64000);
End;

Procedure WarpCalculate(SrcM,DestM : MeshArray; Var IM : MeshIArray; Frames : Integer);
Var X, Y : Integer;
Begin
 For Y:=0 to MeshY do
 For X:=0 to MeshX do
 Begin
  IM[Y,X].X:=FixedDiv(I2L(DestM[Y,X].X-SrcM[Y,X].X),I2L(Frames));
  IM[Y,X].Y:=FixedDiv(I2L(DestM[Y,X].Y-SrcM[Y,X].Y),I2L(Frames))
 End;
End;

Procedure WarpUpdate(SM : MeshArray; IM : MeshIArray; Var M : MeshArray; Frame : Integer);
Var X, Y : Integer;
Begin
 For Y:=0 to MeshY do
 For X:=0 to MeshX do
 Begin
  M[Y,X].X:=L2I(I2L(SM[Y,X].X)+FixedMul(IM[Y,X].X,I2L(Frame)));
  M[Y,X].Y:=L2I(I2L(SM[Y,X].Y)+FixedMul(IM[Y,X].Y,I2L(Frame)));
 End;
End;

Procedure WarpDraw(sMesh,dMesh : MeshArray; GSeg : Word);
Var X, Y, dX, dY : Integer;
Begin
 dX:=10; dY:=10;
 For Y:=0 to MeshY-1 do
 For X:=0 to MeshX-1 do
 Begin
  TriangleTexture(
    dMesh[Y,X].X,       dMesh[Y,X].Y,
    dMesh[Y,X+1].X,     dMesh[Y,X+1].Y,
    dMesh[Y+1,X+1].X,   dMesh[Y+1,X+1].Y,
    sMesh[Y,X].X,       sMesh[Y,X].Y,
    sMesh[Y,X+1].X,     sMesh[Y,X+1].Y,
    sMesh[Y+1,X+1].X,   sMesh[Y+1,X+1].Y, WarpPtr, GSeg);
  TriangleTexture(
    dMesh[Y,X].X,       dMesh[Y,X].Y,
    dMesh[Y+1,X+1].X,   dMesh[Y+1,X+1].Y,
    dMesh[Y+1,X].X,     dMesh[Y+1,X].Y,
    sMesh[Y,X].X,       sMesh[Y,X].Y,
    sMesh[Y+1,X+1].X,   sMesh[Y+1,X+1].Y,
    sMesh[Y+1,X].X,     sMesh[Y+1,X].Y, WarpPtr, GSeg);
 End;
End;

Procedure MeshDraw(dMesh : MeshArray; GSeg : Word);
Var X, Y : Integer;
Begin
 For Y:=0 to MeshY-1 do
 For X:=0 to MeshX-1 do
 Begin
   Line( dMesh[Y,X].X,        dMesh[Y,X].Y,
         dMesh[Y,X+1].X,      dMesh[Y,X+1].Y,   255, GSeg);
   Line( dMesh[Y,X+1].X,      dMesh[Y,X+1].Y,
         dMesh[Y+1,X+1].X,    dMesh[Y+1,X+1].Y, 255, GSeg);
   Line( dMesh[Y+1,X+1].X,    dMesh[Y+1,X+1].Y,
         dMesh[Y+1,X].X,      dMesh[Y+1,X].Y,   255, GSeg);
   Line( dMesh[Y+1,X].X,      dMesh[Y+1,X].Y,
         dMesh[Y,X].X,        dMesh[Y,X].Y,     255, GSeg);
 End;
End;

Procedure DoWarp(SM, DM : MeshArray; F : Integer);
Begin
 Mesh:=SM;
 WarpCalculate(SM,DM,IncMesh,F);
 For Frame:=1 to F do
 Begin
  WarpDraw(SM,Mesh,VSeg);
  ShowFake(VSeg);
  WarpUpdate(SM,IncMesh,Mesh,Frame);
 End;
End;

Procedure Warp_Init;
Begin
 InitVPage;
 WarpInit;
End;

Procedure Warp_Done;
Begin
 WarpDone;
 DoneVPage;
End;

Procedure Warp_Run;
Begin
 DAC_SetPalette(@ZeroPal);
 WarpDraw(Mesh0,Mesh0,$A000);
 CopyFake($A000,WarpSeg);
 DAC_SetFading(@ZeroPal,@WarpPal,20);
 While Fading do
 Begin
  DAC_UpdateFading;
  VRet;
 End;
 DoWarp(Mesh0,Mesh1,10);
 WarpDraw(Mesh0,Mesh1,$A000);
 CopyFake($A000,WarpSeg);
 DoWarp(Mesh1,Mesh2,10);
 WarpDraw(Mesh1,Mesh2,$A000);
 CopyFake($A000,WarpSeg);
 DoWarp(Mesh2,Mesh3,10);
 WarpDraw(Mesh2,Mesh3,$A000);
 CopyFake($A000,WarpSeg);
 DoWarp(Mesh3,Mesh0,10);
 DAC_SetFading(@WarpPal,@ZeroPal,20);
 While Fading do
 Begin
  DAC_UpdateFading;
  VRet;
 End;
End;

End.
