{$M 32000,0,655360}
{$G+}
(* IAURUS FIRE (C) '95 By Paradise *)

Unit Iaurus;

Interface

 Procedure Iaurus_Init;
 Procedure Iaurus_Setup(NSteps : LongInt);
 Procedure Iaurus_Run;
 Procedure Iaurus_Done;

Implementation

Uses Crt, Dos, Vga, Palette, FireGFX1, FireGFX2, DAC;

Type
 PalTyp                  = (Fire,Ice);

Var
 TPtr, BPtr, XPtr, YPtr  : Pointer;
 XSeg, YSeg, TSeg, BSeg  : Word;
 X, Y                    : Integer;
 RandSeed                : LongInt;
 Bluring                 : Boolean;
 IcePalette, FirePalette,
 WhitePalette            : PaletteType;
 PalType                 : PalTyp;
 Fading                  : Boolean;
 ScrP, DestP             : Pointer;
 Steps, Step             : LongInt;

Procedure PaletteData; Assembler;
(* Obliczone 256-kolorow palety RGB dla efektu ognia. *)
Asm
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,3,0,0,5,0,0,7,1,0,9,1,0,11,1,0,14,2,0,16,2,0,18,2,0,20,3,0,22,3,1,24,4,1,26
 db 4,1,28,5,1,30,5,1,33,5,1,35,6,1,37,7,1,39,8,1,41,8,1,42,9,1,44,11,1,46,11,1,48,13,2,50,14,2
 db 52,15,2,53,16,2,55,17,2,57,18,3,59,20,3,61,21,3,63,23,4,63,25,5,63,27,6,63,29,7,63,31,8,63,34,9,63,35
 db 9,63,36,10,63,38,11,63,39,11,63,40,12,63,42,13,63,43,13,63,44,14,63,45,15,63,46,15,63,47,16,63,49,17,63,50,18,63
 db 50,18,63,52,19,63,53,20,63,53,22,63,54,24,63,54,27,63,55,29,63,55,32,63,56,34,63,56,36,63,57,39,63,58,41,63,58,43
 db 63,59,46,63,59,48,63,60,51,63,60,53,63,61,55,63,61,58,63,62,60,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
 db 63,63,63,63,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
End;

Procedure Randomize; Assembler;
(* Procedura inicjuje generator liczb losowych. *)
Asm
 mov ah, 2Ch
 int 21h
 mov word ptr [RandSeed], cx
 mov word ptr [RandSeed+2], dx
End;

Procedure Random; Assembler;
(* Procedura generuje liczbe losowa z przedzialu [0..AX-1]. *)
Asm
 mov cx, ax
 mov ax, word ptr [RandSeed+2]
 mov bx, word ptr [RandSeed]
 mov si, ax
 mov di, bx
 mov dl, ah
 mov ah, al
 mov al, bh
 mov bh, bl
 xor bl, bl
 rcr dl, 1
 rcr ax, 1
 rcr bx, 1
 add bx, di
 adc ax, si
 add bx, 62e9h
 adc ax, 3619h
 mov word ptr [RandSeed], bx
 mov word ptr [RandSeed+2], ax
 xor dx, dx
 div cx
 mov ax, dx
End;

Procedure RandomSpots; Assembler;
(* Procedura rysuje losowe punkty w ostatniej lini ognia. *)
Asm
 mov ax, TSeg
 mov es, ax
 mov di, 199*256
 add di, 2
 mov cx, 6
@spots:
 push di
 push cx
 push di
 mov  ax, 255
 call Random
 pop  di
 add  di, ax
 mov  ax, 80
 push di
 call Random
 add  ax, 90
 pop  di
 pop  cx
 mov  ah, al
 mov  es:[di], ax
 pop  di
 loop @spots
End;

Procedure BlurFlame; Assembler;
(* Rozmywa i przesuwa ogien w gore. *)
Asm
 mov ax, TSeg
 mov es, ax
 mov di, 256*130
@blurpoint:
 xor ax, ax
 xor bx, bx
 mov bl, es:[di]
 mov al, es:[di+256]
 add bx, ax
 mov al, es:[di-1]
 add bx, ax
 mov al, es:[di+1]
 add bx, ax
 shr bx, 2
 jz  @nodec
 dec bx
@nodec:
 mov es:[di-256+2], bl
 inc di
 cmp di, 256*200
 jb @blurpoint
End;

Procedure TubeMap(GSeg : Word); Assembler;
(* Mapuje ekran o wielkosci 256*256 na ekran 320*200. *)
Const
 Poczatek =  10;
 Koniec   = 190;
Asm
  push ds
  mov  ax, XSeg
{ mov  fs, ax }     db 8Eh,0E0h
  mov  ax, YSeg
{ mov  gs, ax }     db 8Eh,0E8h
  mov  ax, TSeg
  mov  ds, ax
  mov  ax, GSeg
  mov  es, ax
  mov  di, Poczatek*320
 @punkt:
{ mov bh, fs:[di] } db 64h,8Ah,3Dh
{ mov bl, gs:[di] } db 65h,8Ah,1Dh
  neg bh
  cmp bh, 195
  jg @koniec
  mov al, ds:[bx]
  or  al, al
  jz @koniec
  mov es:[di], al
 @koniec:
  inc di
  cmp di, Koniec*320
  jnz @punkt
  pop  ds
End;

Procedure Blur(GSeg : Word); Assembler;
(* Rozmywa ekran. *)
Asm
 cld
 mov ax, GSeg
 mov es, ax
 xor di, di
@blurpixel:
 xor ax, ax
 mov al, es:[di+320]
 mov bx, ax
 mov al, es:[di-1]
 add bx, ax
 mov al, es:[di+1]
 add bx, ax
 mov al, es:[di-320]
 add bx, ax
 shr bx, 2
 mov es:[di], bl
 inc di
 cmp di, 199*320
 jnz @blurpixel
End;

Procedure AllocateMemory;
(* Rezerwuje ok. 200kb na tablice potrzebne do dzialania. *)
Begin
 GetMem(TPtr,65535);
 GetMem(BPtr,64000);
{ GetMem(XPtr,64000);
 GetMem(YPtr,64000);}
 BSeg:=Seg(BPtr^);
 XSeg:=Seg(TubeXData);
 YSeg:=Seg(TubeYData);
 TSeg:=Seg(TPtr^);
 FillChar(TPtr^,65535,0);
End;

Procedure LoadTubes;
(* Wczytuje tube mapping offsety z pliku. *)
Begin
 {UnpackTubeX(XPtr^);}
 {
 Move(@TubeXData^,XPtr^,64000);
 Move(@TubeYData^,YPtr^,64000);
 }
End;

Procedure DeAllocateMemory;
(* Zwalnia pamiec zarezerwonana na poczatku. *)
Begin
{ FreeMem(YPtr,64000);
 FreeMem(XPtr,64000);}
 FreeMem(BPtr,64000);
 FreeMem(TPtr,65535);
End;

{$L Zoom.Obj}
{$F+}
Procedure ZoomBuffer(srcSeg,destSeg : Word; xOffset,yOffset : Integer); External;
(* Powieksza ekran z 'srcSeg:0' do 'destSeg:0'. *)
{$F-}

Var
 Dr : Byte;

Const
 MDr = 7;
 sc  = 1;
 DirX : Array [0..MDr] of Integer = (  0, sc, sc, sc,  0,-sc,-sc,-sc);
 DirY : Array [0..MDr] of Integer = (-sc,-sc,  0, sc, sc, sc,  0,-sc);

Var
 Ch : Char;

Procedure MakePalettes;
Var i : Byte;
Begin
 For i:=0 to 255 do
 Begin
  IcePalette[i,0]:=Mem[Seg(PaletteData):Ofs(PaletteData)+i*3+2];
  IcePalette[i,1]:=Mem[Seg(PaletteData):Ofs(PaletteData)+i*3+1];
  IcePalette[i,2]:=Mem[Seg(PaletteData):Ofs(PaletteData)+i*3+0];
  FirePalette[i,0]:=Mem[Seg(PaletteData):Ofs(PaletteData)+i*3+0];
  FirePalette[i,1]:=Mem[Seg(PaletteData):Ofs(PaletteData)+i*3+1];
  FirePalette[i,2]:=Mem[Seg(PaletteData):Ofs(PaletteData)+i*3+2];
  WhitePalette[i,0]:=63;
  WhitePalette[i,1]:=63;
  WhitePalette[i,2]:=63;
 End;
End;

Procedure Iaurus_Init;
Begin
 InitVPage;
 AllocateMemory;
 LoadTubes;
 MakePalettes;
 SetPalette(@FirePalette);
 Randomize;
 Step:=0; Steps:=200; Dr:=0; NTimes:=4;
End;

Procedure Iaurus_Setup(NSteps : LongInt);
Begin
 Steps:=NSteps;
End;

Procedure Iaurus_Done;
Begin
 DeAllocateMemory;
 DoneVPage;
End;

Procedure Iaurus_Run;
Begin
 While Step<Steps do
 Begin
  DAC_UpdateFading;
  DoFade;
  RandomSpots;
  BlurFlame;
  TubeMap(VSeg);
  Blur(VSeg);
  ZoomBuffer(VSeg,BSeg,DirX[Dr],DirY[Dr]);
  CopyFake(BSeg,VSeg);
  Inc(Dr); If Dr>MDr then Dr:=0;
  Inc(Step);
  If Step=Steps-20 then
  Begin
   DAC_SetFading(@FirePalette,@WhitePalette,20);
  End;
 End;
End;

End.
