{$M 32000,0,655360}

(* Unlimited Doom's sprites (C) '95 By Paradise *)

Unit UnlSpr;

Interface

 Procedure UnlSpr_Init;
 Procedure UnlSpr_Setup(NSteps : Word);
 Procedure UnlSpr_Run;
 Procedure UnlSpr_Done;

Implementation

Uses Crt, Dos, Vga, DAC, TPUnpack;

CONST
 sL = 501;

VAR
 Lissa : array [0..sL] of record x,y: integer; end;

VAR
 BitMap: Array [1..70,1..69] of Byte;

VAR
 Page        : Byte;
 position    : Word;
 Step, Steps : LongInt;
 USPal, ZPal : Array [0..255,1..3] of Byte;

{$L Lissa.Obj}
{$L DoomSpr.Obj}
{$L DoomSprP.Obj}
Procedure Lis; External;
Procedure UnpackDoom(Var Buffer); Far; External;
Procedure DoomPalette; External;

procedure LoadSprite;
begin
 Move(@DoomPalette^,USPal,768);
 UnpackDoom(BitMap);
end;

procedure LoadLissa;
begin
 Move(Mem[Seg(Lis):Ofs(Lis)],Lissa,sL*4);
end;

PROCEDURE ModeX; ASSEMBLER;
ASM
    mov    ax, 0013h    { Use bios to enter standard Mode 13h }
    int    10h
    mov    dx, 03c4h    { Set up DX to one of the VGA registers }
    mov    al, 04h      { Register = Sequencer : Memory Modes }
    out    dx, al
    inc    dx           { Now get the status of the register }
    in     al, dx       { from the next port }
    and    al, 0c7h     { AND it with 11000111b ie, bits 3,4,5 wiped }
    or     al, 04h      { Turn on bit 2 (00000100b) }
    out    dx, al       { and send it out to the register }
    mov    dx, 03c4h    { Again, get ready to activate a register }
    mov    al, 02h      { Register = Map Mask }
    out    dx, al
    inc    dx
    mov    al, 0fh      { Send 00001111b to Map Mask register }
    out    dx, al       { Setting all planes active }
    mov    ax, 0a000h   { VGA memory segment is 0a000h }
    mov    es, ax       { load it into ES }
    sub    di, di       { clear DI }
    mov    ax, di       { clear AX }
    mov    cx, 8000h    { set entire 64k memory area (all 4 pages) }
    repnz  stosw        { to colour BLACK (ie, Clear screens) }
    mov    dx, 03d4h    { User another VGA register }
    mov    al, 14h      { Register = Underline Location }
    out    dx, al
    inc    dx           { Read status of register }
    in     al, dx       { into AL }
    and    al, 0bFh     { AND AL with 10111111b }
    out    dx, al       { and send it to the register }
                        { to deactivate Double Word mode addressing }
    dec    dx           { Okay, this time we want another register,}
    mov    al, 17h      { Register = CRTC : Mode Control }
    out    dx, al
    inc    dx
    in     al, dx       { Get status of this register }
    or     al, 40h      { and Turn the 6th bit ON }
    out    dx, al       { to turn WORD mode off }
                        { And thats all there is too it!}
END;

procedure PutPixel(X,Y: Integer; Color: Byte ); assembler;
var OfsAdr: Word;
ASM
 mov    bx, 16000
 mov    al, Page
 mov    ah, 0
 mul    bx
 mov    OfsAdr, ax
 mov    bx, x
 mov    ax, Y
 mov    cx, 80
 mul    cx
 mov    di, ax
 mov    ax, bx
 shr    ax, 1
 shr    ax, 1
 add    di, ax
 and    bx, 3
 mov    ah, 1
 mov    cl, bl
 shl    ah, cl
 mov    al, 2
 mov    dx, 03C4h
 mov    bx, $A000
 mov    es, bx
 add    di, OfsAdr
 out    dx, ax
 mov    al, Color
 mov    es:[di], al
end;

procedure ShowPage; assembler;
asm
 mov    bx, 16000
 mov    al, Page
 mov    ah, 0
 mul    bx
 mov    cx, ax
 mov    dx, 03D4h
 mov    al, 0Dh
 out    dx, al
 inc    dx
 mov    ax, cx
 out    dx, al
 dec    dx
 mov    al, 0Ch
 out    dx, al
 inc    dx
 mov    al, ah
 out    dx, al
end;

procedure Sprite(x,y: Integer);
var tx,ty: Integer;
begin
 for ty:=1 to 70 do
 for tx:=1 to 69 do
  if (BitMap[ty,tx]>0) and
  (x+tx<320) and (x+tx>0) and
  (y+ty<200) and (y+ty>0) then PutPixel(x+tx,y+ty,BitMap[ty,tx]);
end;

procedure NextPage;
begin
 inc(page);
 if page=4 then page:=0;
end;

procedure NextPos;
begin
 inc(position);
 if position>(sL-1) then position:=0;
end;

Procedure UnlSpr_Init;
Begin
 ModeX;
 LoadLissa;
 LoadSprite;
 Position:=0; Page:=0;
 ShowPage;
 Step:=0; Steps:=400;
 FillChar(ZPal,768,0);
End;

Procedure UnlSpr_Setup(NSteps : Word);
Begin
 Steps:=NSteps;
End;

Procedure UnlSpr_Done;
Begin
 InitVga;
End;

Procedure UnlSpr_Run;
Begin
 DAC_SetPalette(@ZPal);
 DAC_SetFading(@ZPal,@USPal,30);
 While Step<Steps do
 Begin
  DAC_UpdateFading;
  ShowPage;
  NextPage;
  Sprite(Lissa[Position].X,Lissa[Position].Y);
  NextPos;
  VRet;
  Inc(Step);
  If Step=Steps-30 then
  Begin
   DAC_SetFading(@USPal,@ZPal,30);
  End;
 End;
End;

End.