; Fixed point routines.

MUL_ROUNDING_ON equ     1
DIV_ROUNDING_ON equ     0

        IDEAL
        LOCALS
        P386N
        MODEL   LARGE,PASCAL

        CODESEG

        PUBLIC  FixedMul
        PUBLIC  FixedDiv

;=====================================================================
; Multiplies two fixed-point values together.
; C far-callable as:
;       Fixedpoint FixedMul(Fixedpoint M1, Fixedpoint M2);

PROC    FixedMul
        ARG     M1:DWORD,M2:DWORD

        mov     eax,[M1]
        imul    [dword ptr M2] ;multiply
if MUL_ROUNDING_ON
        add     eax,8000h       ;round by adding 2^(-17)
        adc     edx,0           ;whole part of result is in DX
endif ;MUL_ROUNDING_ON
        shr     eax,16          ;put the fractional part in AX

        ret

ENDP    FixedMul

;=====================================================================
; Divides one fixed-point value by another.
; C far-callable as:
;       Fixedpoint FixedDiv(Fixedpoint Dividend, Fixedpoint Divisor);

PROC    FixedDiv
        ARG     Dividend:DWORD,Divisor:DWORD

if DIV_ROUNDING_ON
        sub     cx,cx           ;assume positive result
        mov     eax,[Dividend]
        and     eax,eax         ;positive dividend?
        jns     FDP1            ;yes
        inc     cx              ;mark it's a negative dividend
        neg     eax             ;make the dividend positive
FDP1:   sub     edx,edx         ;make it a 64-bit dividend, then shift
                                ; left 16 bits so that result will be
                                ; in EAX
        rol     eax,16          ;put fractional part of dividend in
                                ; high word of EAX
        mov     dx,ax           ;put whole part of dividend in DX
        sub     ax,ax           ;clear low word of EAX
        mov     ebx,[dword ptr Divisor]
        and     ebx,ebx         ;positive divisor?
        jns     FDP2            ;yes
        dec     cx              ;mark it's a negative divisor
        neg     ebx             ;make divisor positive
FDP2:   div     ebx             ;divide
        shr     ebx,1           ;divisor/2, minus 1 if the divisor is
        adc     ebx,0           ; even
        dec     ebx
        cmp     ebx,edx         ;set Carry if the remainder is at least
        adc     eax,0           ; half as large as the divisor, then
                                ; use that to round up if necessary
        and     cx,cx           ;should the result be made negative?
        jz      FDP3            ;no
        neg     eax             ;yes, negate it
FDP3:
else ;!DIV_ROUNDING_ON
        mov     edx,[Dividend]
        sub     eax,eax
        shrd    eax,edx,16      ;position so that result ends up
        sar     edx,16          ; in EAX
        idiv    [dword ptr Divisor]
endif ;DIV_ROUNDING_ON
        shld    edx,eax,16      ;whole part of result in DX;
                                ; fractional part is already in AX

        ret

ENDP    FixedDiv

        END

