{$G+}
Unit Palette; { Palette handling procedures (C) 1995 By Paradise [The Crow] }

Interface

 Type
  PaletteType = Array [0..255,0..2] of Byte;

 Var
  SrcPalette,
  DestPalette,
  ZeroPalette : PaletteType;
  FadeActive  : Boolean;
  FadeTimer   : LongInt;
  FadeTick    : Byte;
  NTimes      : Byte;

 Procedure SetColor(Num, Red, Green, Blue : Byte);
 Procedure SetPalette(What : Pointer);
 Function  FadePalette(Var Src: PaletteType; Dest : PaletteType) : Boolean;
 Procedure SetFadingIn(ToPal : PaletteType; Tick : Byte);
 Procedure SetFadingOut(FromPal : PaletteType; Tick : Byte);
 Procedure SetFadingBetween(FromPal, ToPal : PaletteType; Tick : Byte);
 Function  DoFade : Boolean;

Implementation

Procedure SetColor(Num,Red,Green,Blue : Byte); Assembler;
Asm
 mov dx, 3c8h
 mov al, Num
 out dx, al
 inc dx
 mov al, Red
 out dx, al
 mov al, Green
 out dx, al
 mov al, Blue
 out dx, al
End;

Procedure SetPalette(What : Pointer); Assembler;
Asm
 cld
 push ds
 mov ax, word ptr [What+2]
 mov ds, ax
 mov si, word ptr [What]
 mov cx, 768
 mov dx, 3c8h
 xor ax, ax
 out dx, al
 inc dx
 rep outsb
 pop ds
End;

Function  FadePalette(Var Src: PaletteType; Dest : PaletteType) : Boolean;
Var
 Count : Byte;
 Done  : Boolean;
Begin
 Done:=True;
 For Count:=0 to 255 do
 Begin
  If Src[Count,0]<>Dest[Count,0] then
  Begin
   Done:=False;
   If Src[Count,0]>Dest[Count,0] then Dec(Src[Count,0])
                                 else Inc(Src[Count,0]);
  End;
  If Src[Count,1]<>Dest[Count,1] then
  Begin
   Done:=False;
   If Src[Count,1]>Dest[Count,1] then Dec(Src[Count,1])
                                 else Inc(Src[Count,1]);
  End;
  If Src[Count,2]<>Dest[Count,2] then
  Begin
   Done:=False;
   If Src[Count,2]>Dest[Count,2] then Dec(Src[Count,2])
                                 else Inc(Src[Count,2]);
  End;
 End;
 FadePalette:=Done;
End;

Procedure SetFadingIn(ToPal : PaletteType; Tick : Byte);
Begin
 FadeActive:=True;
 SrcPalette:=ZeroPalette;
 DestPalette:=ToPal;
 SetPalette(@SrcPalette);
 FadeTimer:=0;
 FadeTick:=Tick;
End;

Procedure SetFadingOut(FromPal : PaletteType; Tick : Byte);
Begin
 FadeActive:=True;
 SrcPalette:=FromPal;
 DestPalette:=ZeroPalette;
 SetPalette(@SrcPalette);
 FadeTimer:=0;
 FadeTick:=Tick;
End;

Procedure SetFadingBetween(FromPal, ToPal : PaletteType; Tick : Byte);
Begin
 FadeActive:=True;
 SrcPalette:=FromPal;
 DestPalette:=ToPal;
 SetPalette(@SrcPalette);
 FadeTimer:=0;
 FadeTick:=Tick;
End;

Function DoFade : Boolean;
Var i : Integer;
Begin
 Inc(FadeTimer);
 If FadeActive and (FadeTimer=FadeTick) then
 Begin
  For i:=1 to NTimes do
  If FadePalette(SrcPalette, DestPalette) then FadeActive:=False;
  SetPalette(@SrcPalette);
  FadeTimer:=0;
 End;
 DoFade:=FadeActive;
End;

Begin
 NTimes:=1;
 FillChar(ZeroPalette,768,0);
End.