--      PCHARSET.PAS    -- character set routines by FAC

--      this unit contains some routines to work with a character set
--      contained in a PCX image. bad thing is that all chars must have
--      the same size, but anyway, it's a nice thing to have

unit pCharSet;

{ Unidad pCharSet para TMT Pascal }

interface

uses Mode13PM;

{ type definitions }

{ TCharInfo only contains the position of a character within the PCX map }
type TCharInfo = record
                 x, y : word;
                 end;

{ TCharSetInfo: contains information for all the character set          }
     TCharSetInfo = record
                    Chars : array[char] of TCharInfo; { chars position }
                    SizeX, SizeY : byte;              { common size    }
                    charmap : string[12];             { PCX filename   }
                    end;

{ the TCharSet class is everything you need to print text in mode 13h }
     PTCharSet = ^TCharSet;
     TCharSet = object
              public
                    Info : TCharSetInfo;    { the charset information }
                    MapScr : PTVirtual;     { the character image map }
                    MapOff : dword;         { offset of the image map }
                    Palette : TPalette;     { palette of the charset  }

                    constructor Init(fn : string);
                    destructor Done;
                    procedure Load(fn : string);
                    procedure PrintChar(x, y : word; c : char; where : dword);
                    procedure PrintString(x, y : word; s : string; hs : integer; where : dword);
              end;


implementation

{ TCharSet class implementation }

{ the class constructor }
constructor TCharSet.Init(fn : string);
begin
     SetupVirtual(MapScr, MapOff); { allocate memory for the image map  }
     if fn <> '' then Load(fn);    { load the character set information }
end;

{ the class destructor }
destructor TCharSet.Done;
begin
     if MapScr <> nil then ShutDownVirtual(MapScr);
     MapScr := nil;
end;

{ Load character set information from disk and also loads the image map }
{ this procedure loads a structure of type TCharSetInfo         }
{ take a look at GENINFO1.PAS to see how the file is created    }
procedure TCharSet.Load(fn : string);
var f : file of TCharSetInfo;
begin
     assign(f, fn);
     reset(f);
     read(f, Info);
     LoadPCX(Info.CharMap, MapOff, 320, 200, 0, 0, Palette);
     close(f);
end;

{ this method prints a single char on the screen                     }
{ should have done this in asm, but I forgot to optimize this part   }
{ anyway, the procedure's written in such a way the asm-translation  }
{ is almost trivial                                                  }
procedure TCharSet.PrintChar(x, y : word; c: char; where : dword);
var i, j, sx, scrofs, mapofs, yinc : dword;
begin
     sx := Info.SizeX;
     scrofs := y * 320 + x + where;  { initial destination screen offset }
     yinc := 321 - sx;  { y increments }
     { below is the initial offset within the character map     }
     mapofs := (Info.Chars[c].y + 1) * 320 + Info.Chars[c].x + 1 + MapOff;

     { now, draw the thing }
     for j := 2 to Info.SizeY do
     begin
          for i := 2 to sx do
          begin
               { the "if" is because we want the text to be transparent }
               if mem[mapofs] <> 0 then mem[scrofs] := mem[mapofs];
               inc(scrofs);
               inc(mapofs);
          end;
          inc(scrofs, yinc);
          inc(mapofs, yinc);
     end;
end;

{ and finally, the method that prints a whole string                    }
{ this procedure doesn't perform any clipping!                          }
{ the HS parameter is used to control the character spacing, and it's   }
{ usually a negative number                                             }
procedure TCharSet.PrintString(x, y : word; s : string; hs : integer; where : dword);
var i, xx : word;
begin
     xx := x;   { initial X position }
     for i := 1 to length(s) do
     begin
          PrintChar(xx, y, s[i], where);  { draw the char }
          inc(xx, Info.SizeX);            { increment X position }
          inc(xx, hs);                    { and fix the spacing  }
     end;
end;

end.
