Unit ZMSystem;

Interface

type 
  tSysInfo=
   record
     Host32bit:Boolean;
     VirtualMemory:Boolean;
     CPU:WORD;
   end;

Var 
  SysInfo:tSysInfo;
  ZMSError:integer;

Procedure PMODESysInfo;
Procedure ShowSysInfo;
Function  EscPressed:boolean;
Function  keypressed:Boolean;
Function  Hex(r:DWORD):String;
Function  Random:DWORD;

Implementation
 
Procedure PMODESysInfo;
var
  temp:Word;
begin
  asm
    mov   ax,$400
    int   $31
    mov   bh,cl
    mov   [temp],bx
  end;
  SysInfo.Host32bit:=(temp AND 1)>0;
  SysInfo.VirtualMemory:=(temp AND 2)>0;
  if Hi(temp)in [3..5] then
   SysInfo.CPU:=Hi(temp)*100+86
  else
   SysInfo.CPU:=0;   
end;

Procedure ShowSysInfo;
begin
  With SysInfo do
   begin
     WriteLn('CPU: ',CPU);
     If Host32bit then 
      WriteLN('32bit Host');
     If VirtualMemory then
      WriteLn('Virtual Memory supported');
   end;
end;

Function EscPressed:boolean;
code;
asm
  in     al,$60
  cmp    al,1
  sete   al
  ret
end;

Function  keypressed:Boolean;
code;
asm
  mov   al,[$41A]
  sub   al,[$41C]
  jnz   @True
  ret
  align 4
  @True:
  mov   al,True
  ret
end;

Function Hex(r:DWORD):String;
const
  hexst:string='0123456789ABCDEF';
var
  st:string;
begin
  st:='';
  repeat
   st:=hexst[1+(r and $F)]+st;
   r:=r shr 4;
  until st[0]=#8;
  Hex:=st
end;

const
  Sem1:DWORD=$1234;
  Sem2:DWORD=$9876;

Function  Random:DWORD;
code;
asm
  push  edx
  mov   eax,[Sem1]
  mov   edx,[Sem2]
  add   edx,eax
  mul   edx
  mov   [Sem2],eax
  xor   edx,eax
  add   edx,$E46C
  mov   [Sem1],edx
  mov   eax,edx
  pop   edx
  ret
end;


begin
  PMODESysInfo;

  ZMSError:=0;
end.

