.386p

_DATA SEGMENT PAGE PUBLIC 'DATA'

EXTRN C graphics_system:dword

CX_ equ [graphics_system+12]
CY equ [graphics_system+16]
XRATIO equ [graphics_system+20]
YRATIO equ [graphics_system+24]

ALIGN 8

temp    dq      ?
disp    dd      ?
magic   dd      59c00000h

sword   dw      ?

_DATA ENDS


_TEXT SEGMENT PAGE PUBLIC 'CODE'
        assume cs:_text, ds:_data

PUBLIC BACK_FACE_
PUBLIC TRANSFORM_PTS_

;----------------------------------------------------------------------------
;----------------------------------------------------------------------------

TRANSFORM_PTS_ PROC

;       Queda por hacer:
;               -Comprobar si X,Y se desborda

        pushad
        mov ebp,eax             ; Un pequeo truco para liberar un registro
        add ebp,ecx
        mov eax,ecx
        neg eax

        fld1                    ; Para calcular inversos

ALIGN 32
@@xform:cmp byte ptr [eax+ebp],0
        je @@no_xform_pto

        ; Componente Z
        fld dword ptr [esi]     ;1
        fmul dword ptr [ebx+8]  ;1
        fld dword ptr [esi+4]   ;1
        fmul dword ptr [ebx+24] ;1
        fld dword ptr [esi+8]   ;1
        fmul dword ptr [ebx+40] ;1
        fxch                    ;0
        faddp st(2),st          ;1
        fld dword ptr [esi]     ;1              * Siguiente valor
        fmul dword ptr [ebx]    ;1              *
        fxch                    ;0
        faddp st(2),st          ;1  /10

        ; Componente X
        fld dword ptr [esi+4]   ;1
        fmul dword ptr [ebx+16] ;1
        fld dword ptr [esi+8]   ;1
        fmul dword ptr [ebx+32] ;1
        fxch                    ;0
        faddp st(2),st          ;1
        fld dword ptr [esi]     ;1              * Siguiente valor
        fmul dword ptr [ebx+4]  ;1              *
        fxch                    ;0
        faddp st(2),st          ;1  /8

        ; Componente Y
        fld dword ptr [esi+4]   ;1
        fmul dword ptr [ebx+20] ;1
        fld dword ptr [esi+8]   ;1
        fmul dword ptr [ebx+36] ;1
        fxch                    ;0
        faddp st(2),st          ;1
        fld dword ptr [ebx+48]  ;1
        faddp st(3),st          ;1
        fadd dword ptr [ebx+52] ;1
        fld dword ptr [ebx+56]  ;1
        faddp st(4),st          ;1
        fadd                    ;1  /11

;       -- Rotacion: 29 ciclos/vector

        fld st(2)               ;1      z
        fdivr st,st(4)          ;38     1/z

        ;----Hasta 38 ciclos paralelos con la divisin----
                cmp dword ptr [edx],eax ; Dummy Read
                cmp dword ptr [edx+4],eax ;
                cmp dword ptr [edi],eax
                cmp dword ptr [edi+4],eax
                cmp dword ptr [edi+8],eax
                cmp dword ptr [eax+ebp],eax
                cmp dword ptr [esi],eax
                cmp dword ptr [ebx],eax
                cmp dword ptr [ebx+32],eax
        ;-------------------------------------------------

        fld st(0)               ;1      1/z
        fmul YRATIO             ;1      Yratio/z

        fld st(2)               ;1      y
        fmul                    ;1      (y*Yratio)/z

        fld st(3)               ;1      x
        fmul XRATIO             ;1      x*Xratio
        fxch                    ;0

        fadd [magic]            ;1
        add edi,12              ;U(1) Paralelo FPU
        add edx,8               ;V(0) Paralelo FPU
        fstp qword ptr [temp]   ;2
        fmul                    ;1      (x*Xratio)/z
        mov ecx,dword ptr [temp];U(1) Paralelo FPU
        add esi,12              ;V(0) Paralelo FPU
        fadd [magic]            ;1
        add ecx,CY              ;U(1) Paralelo FPU


        fstp qword ptr [temp]   ;2
        mov [edx-4],ecx
        mov ecx,dword ptr [temp];1 Bank Conflict - Paralelo FPU
        fstp dword ptr [edi-12+4] ;1
        add ecx,CX_             ;1 Paralelo FPU
        fstp dword ptr [edi-12] ;2
        mov dword ptr [edx-8],ecx ;1
        add eax,1               ;1
        fstp dword ptr [edi-12+8] ;2

        jnc @@xform             ;1

        ffree st
        popad
        ret

ALIGN 32
@@no_xform_pto:

        add edi,12
        add esi,12
        add edx,8

        add eax,1
        jnc @@xform

        ffree st

        popad
        ret

TRANSFORM_PTS_ ENDP

;----------------------------------------------------------------------------
;       Implementacin de Back Face Culling rotando la posicin de la camara
;  en el mundo a las coordenadas del objeto
;----------------------------------------------------------------------------

;       Optimizacin: Pentium, a pesar de esto, NO tengo un Pentium y no puedo
;  probar el cdigo en mi ordenador.
;       Se usa cdigo automodificable (:-oo). No es elegante, pero es necesario

;       Cdigo C:
;       for(j=0;j<obj->n_tri;j++) {             // Eliminar caras posteriores
;
;              *(goods+j)=FALSE;
;              if(((eq_tri+j)->a)*local_camara.x+((eq_tri+j)->b)*local_camara.y+
;                  ((eq_tri+j)->c)*local_camara.z>-(eq_tri+j)->d) continue;
;
;              *(vis+((cur_tri+j)->a))=TRUE;
;              *(vis+((cur_tri+j)->b))=TRUE;
;              *(vis+((cur_tri+j)->c))=TRUE;
;              *(goods+j)=TRUE;
;           }

BACK_FACE_ PROC

        pushad

        fld dword ptr [ebx]             ; Posicin -X    ST(0)
        fchs
        fld dword ptr [ebx+4]           ; Posicin -Y    ST(1)
        fchs
        fld dword ptr [ebx+8]           ; Posicin -Z    ST(2)
        fchs


        ;DANGER!!!!!!! Self-Modifying-Code

        mov ebx,OFFSET smf2+2;          ; Automodificar cdigo. Usamos el
        mov dword ptr ds:[ebx],eax      ;  selector DS pues estamos en modo
        mov ebx,OFFSET smf4+2;          ;  Flat.
        mov dword ptr ds:[ebx],eax
        mov ebx,OFFSET smf6+2;
        mov dword ptr ds:[ebx],eax

        mov ebx,OFFSET smf1+3;
        mov dword ptr ds:[ebx],esi
        add esi,2
        mov ebx,OFFSET smf3+3;
        mov dword ptr ds:[ebx],esi
        add esi,2
        mov ebx,OFFSET smf5+3;
        mov dword ptr ds:[ebx],esi

        mov ebx,OFFSET smf0+2;
        mov dword ptr ds:[ebx],edx
        mov ebx,OFFSET smf7+2;
        mov dword ptr ds:[ebx],edx

        mov dx,1
        xor ebx,ebx
        xor eax,eax
        xor ebp,ebp
        xor esi,esi

ALIGN 32
d_face: fld dword ptr [edi]     ;1
        fmul st(0),st(3)        ;1
        fld dword ptr [edi+4]   ;1
        fmul st(0),st(3)        ;1
        fld dword ptr [edi+8]   ;1
        fmul st(0),st(3)        ;1
        fxch                    ;0
        faddp st(2),st          ;1

        fld dword ptr [edi+12]  ;1
        fxch                    ;0
        faddp st(2),st          ;1
smf1:   mov ax,[11223344h+ebx]
        fcompp                  ;1
smf0:   mov byte ptr [11223344h+ebp],dh   ; Tringulo no visible de momento
        add edi,16
        fnstsw [sword]          ;2
        and [sword],100h
        jz poly_no_visible

smf3:   mov si,[11223344h+ebx]                  ;1
smf2:   mov byte ptr [11223344h+eax],dl         ;0      May be Bank Conflict
smf5:   mov ax,[11223344h+ebx]                  ;1      May be Bank Conflict
        add ebx,6                               ;0
smf7:   mov byte ptr [11223344h+ebp],dl         ;1
        inc ebp                                 ;0

smf4:   mov byte ptr [11223344h+esi],dl         ;1
        dec ecx                                 ;0
smf6:   mov byte ptr [11223344h+eax],dl         ;1
        jnz d_face                              ;0

        jmp back_2_wc

ALIGN 32
poly_no_visible:

        inc ebp
        add ebx,6
        dec ecx
        jnz d_face

back_2_wc:

        ffree st
        ffree st(1)
        ffree st(2)

        popad

        ret

BACK_FACE_ ENDP

_TEXT ENDS

	END
